/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DirectoryClassLoader
extends ClassLoader {
    private File directory = null;
    private Map cache = Collections.synchronizedMap(new HashMap());
    private Map dates = Collections.synchronizedMap(new HashMap());

    public DirectoryClassLoader(String directory) {
        this.directory = new File(directory);
    }

    private File getClassFile(String classname) {
        String filename = classname.replace('.', File.separatorChar) + ".class";
        return new File(this.directory, filename);
    }

    public boolean isModified(String classname) {
        Long value = (Long)this.dates.get(classname);
        if (value != null) {
            try {
                File file = this.getClassFile(classname);
                return file.lastModified() != value.longValue();
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> c = (Class<?>)this.cache.get(classname);
            if (c == null) {
                try {
                    File file = this.getClassFile(classname);
                    FileInputStream fis = new FileInputStream(file);
                    byte[] data = new byte[fis.available()];
                    fis.read(data);
                    fis.close();
                    c = this.defineClass(classname, data, 0, data.length);
                    this.dates.put(classname, new Long(file.lastModified()));
                }
                catch (Throwable t) {
                    c = this.findSystemClass(classname);
                }
                this.cache.put(classname, c);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.toString());
        }
    }
}

