/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.io.Serializable;

public final class ObjectStack
implements Serializable {
    static final long serialVersionUID = -7896992305408562521L;
    private ObjectStackItem last = null;
    private int size = 0;

    public synchronized void push(Object value) {
        ObjectStackItem q;
        ++this.size;
        this.last = q = new ObjectStackItem(value, this.last);
    }

    public synchronized Object pop() {
        ObjectStackItem q = this.last;
        if (q != null) {
            --this.size;
            this.last = q.prev;
            return q.value;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public synchronized Object peek() {
        return this.last != null ? this.last.value : null;
    }

    public synchronized void clear() {
        this.size = 0;
        this.last = null;
    }

    private class ObjectStackItem
    implements Serializable {
        public Object value;
        public ObjectStackItem prev;

        public ObjectStackItem(Object value, ObjectStackItem prev) {
            this.value = value;
            this.prev = prev;
        }
    }
}

