/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus.commands;

import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.InsertAttribute;
import org.xmldb.xupdate.lexus.commands.InsertCDATA;
import org.xmldb.xupdate.lexus.commands.InsertComment;
import org.xmldb.xupdate.lexus.commands.InsertElement;
import org.xmldb.xupdate.lexus.commands.InsertProcessingInstruction;
import org.xmldb.xupdate.lexus.commands.InsertStates;
import org.xmldb.xupdate.lexus.commands.InsertText;
import org.xmldb.xupdate.lexus.commands.InsertVariable;

public abstract class InsertCommand
extends CommandObject {
    private Node current = null;
    protected Node result = null;
    private int state = -1;
    private InsertStates[] states = new InsertStates[7];
    private static final int STATE_COUNT = 7;

    public InsertCommand(Node node) throws Exception {
        super(node);
        this.states[0] = new InsertElement();
        this.states[1] = new InsertAttribute();
        this.states[2] = new InsertComment();
        this.states[3] = new InsertText();
        this.states[4] = new InsertCDATA();
        this.states[5] = new InsertProcessingInstruction();
        this.states[6] = new InsertVariable();
    }

    public void submitAttributes(Hashtable hashtable) {
        if (this.state < 0) {
            super.submitAttributes(hashtable);
        } else {
            this.states[this.state].submitAttributes(hashtable);
        }
    }

    public void submitCharacters(String string) {
        if (this.state < 0) {
            super.submitCharacters(string);
        } else {
            this.states[this.state].submitCharacters(string);
        }
    }

    public boolean submitInstruction(int n) throws Exception {
        if (this.result == null) {
            this.current = this.result = this.document.createElementNS(null, "temporaryXUpdateTree");
            this.document.getDocumentElement().appendChild(this.result);
        }
        if (this.state >= 0) {
            this.current = this.states[this.state].execute(this.current);
        }
        switch (n) {
            case 101: {
                this.state = 0;
                break;
            }
            case 102: {
                this.state = 1;
                break;
            }
            case 103: {
                this.state = 2;
                break;
            }
            case 104: {
                this.state = 3;
                break;
            }
            case 105: {
                this.state = 4;
                break;
            }
            case 106: {
                this.state = 5;
                break;
            }
            case 107: {
                this.state = 6;
                break;
            }
            default: {
                this.state = -1;
            }
        }
        if (this.state >= 0) {
            this.states[this.state].reset();
        }
        return this.state >= 0;
    }

    public boolean executeInstruction() throws Exception {
        if (this.state >= 0) {
            this.current = this.states[this.state].execute(this.current);
            this.state = -1;
        }
        if (!this.current.equals(this.result)) {
            switch (this.current.getNodeType()) {
                case 2: {
                    this.current = ((Attr)this.current).getOwnerElement();
                    return true;
                }
            }
            this.current = this.current.getParentNode();
            return true;
        }
        return false;
    }

    protected void insertAttributes(NamedNodeMap namedNodeMap, Node node) throws Exception {
        if (namedNodeMap == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            throw new Exception("can't append attribute to !");
        }
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = attr.getNamespaceURI();
            ((Element)node).setAttributeNS(string, attr.getNodeName(), attr.getNodeValue());
            ++n2;
        }
    }

    public abstract Node execute() throws Exception;
}

