/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.util.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeHelper {
    protected final Map<String, String> attrs = new HashMap<String, String>();

    public AttributeHelper(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!"".equals(attributes.getURI(i))) continue;
            this.attrs.put(attributes.getLocalName(i), attributes.getValue(i));
        }
    }

    public String consume(String string, boolean bl) throws ParseException {
        String string2 = this.attrs.get(string);
        if (string2 == null) {
            if (bl) {
                throw new ParseException("Missing attribute: '" + string + "'");
            }
            return null;
        }
        this.attrs.remove(string);
        return string2;
    }

    public int consumeInteger(String string, boolean bl) throws ParseException {
        String string2 = this.consume(string, bl);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid integer value for attribute: '" + string + "'");
        }
    }

    public long consumeLong(String string, boolean bl) throws ParseException {
        String string2 = this.consume(string, bl);
        if (string2 == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid long value for attribute: '" + string + "'", numberFormatException);
        }
    }

    public boolean consumeBoolean(String string, boolean bl) throws ParseException {
        String string2 = this.consume(string, bl);
        if (string2 == null) {
            return false;
        }
        if ("true".equals(string2)) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        throw new ParseException("Invalid boolean value for attribute: '" + string + "'");
    }

    public <T extends Enum<T>> T consumeEnum(String string, boolean bl, Class<T> clazz) throws ParseException {
        String string2 = this.consume(string, bl);
        if (string2 == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, string2.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Invalid value for attribute : '" + string + "'", illegalArgumentException);
        }
    }

    public void assertAllConsumed() throws ParseException {
        if (!this.attrs.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("Unknown attribute");
            if (this.attrs.size() > 1) {
                stringBuffer.append('s');
            }
            stringBuffer.append(':');
            for (String string : this.attrs.keySet()) {
                stringBuffer.append(" '");
                stringBuffer.append(string);
                stringBuffer.append('\'');
            }
            throw new ParseException(stringBuffer.toString());
        }
    }
}

