/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.extensions.Comments;
import com.google.gdata.data.extensions.OriginalEvent;
import com.google.gdata.data.extensions.Recurrence;
import com.google.gdata.data.extensions.RecurrenceException;
import com.google.gdata.data.extensions.Reminder;
import com.google.gdata.data.extensions.When;
import com.google.gdata.data.extensions.Where;
import com.google.gdata.data.extensions.Who;
import com.google.gdata.util.Namespaces;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/g/2005#event")
public class EventEntry
extends BaseEntry<EventEntry> {
    public static final String EVENT_KIND = "http://schemas.google.com/g/2005#event";
    public static final Category EVENT_CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/g/2005#event");

    public EventEntry() {
        this.getCategories().add(EVENT_CATEGORY);
    }

    public EventEntry(BaseEntry baseEntry) {
        super(baseEntry);
        this.getCategories().add(EVENT_CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extensionProfile) {
        extensionProfile.declareEntryExtension(RecurrenceException.getDefaultDescription());
        extensionProfile.declareEntryExtension(Reminder.getDefaultDescription());
        extensionProfile.declareEntryExtension(Recurrence.getDefaultDescription());
        extensionProfile.declareEntryExtension(Where.getDefaultDescription());
        extensionProfile.declareEntryExtension(EventStatus.getDefaultDescription());
        extensionProfile.declareEntryExtension(Visibility.getDefaultDescription());
        extensionProfile.declareEntryExtension(Transparency.getDefaultDescription());
        extensionProfile.declareEntryExtension(Who.getDefaultDescription());
        extensionProfile.declareEntryExtension(When.getDefaultDescription());
        extensionProfile.declareEntryExtension(OriginalEvent.getDefaultDescription());
        extensionProfile.declareEntryExtension(Comments.getDefaultDescription());
        extensionProfile.declare(When.class, Reminder.getDefaultDescription());
    }

    public List<When> getTimes() {
        return this.getRepeatingExtension(When.class);
    }

    public void addTime(When when) {
        this.getTimes().add(when);
    }

    public List<Where> getLocations() {
        return this.getRepeatingExtension(Where.class);
    }

    public void addLocation(Where where) {
        this.getLocations().add(where);
    }

    public EventStatus getStatus() {
        return this.getExtension(EventStatus.class);
    }

    public void setStatus(EventStatus eventStatus) {
        this.setExtension(eventStatus);
    }

    public Visibility getVisibility() {
        return this.getExtension(Visibility.class);
    }

    public void setVisibility(Visibility visibility) {
        this.setExtension(visibility);
    }

    public Transparency getTransparency() {
        return this.getExtension(Transparency.class);
    }

    public void setTransparency(Transparency transparency) {
        this.setExtension(transparency);
    }

    public List<Who> getParticipants() {
        return this.getRepeatingExtension(Who.class);
    }

    public void addParticipant(Who who) {
        this.getParticipants().add(who);
    }

    public Recurrence getRecurrence() {
        return this.getExtension(Recurrence.class);
    }

    public void setRecurrence(Recurrence recurrence) {
        this.setExtension(recurrence);
    }

    public List<RecurrenceException> getRecurrenceException() {
        return this.getRepeatingExtension(RecurrenceException.class);
    }

    public void addRecurrenceException(RecurrenceException recurrenceException) {
        this.getRecurrenceException().add(recurrenceException);
    }

    public OriginalEvent getOriginalEvent() {
        return this.getExtension(OriginalEvent.class);
    }

    public void setOriginalEvent(OriginalEvent originalEvent) {
        this.setExtension(originalEvent);
    }

    public List<Reminder> getReminder() {
        if (this.getRecurrence() != null) {
            return this.getRepeatingExtension(Reminder.class);
        }
        List<When> list = this.getTimes();
        if (list.size() >= 1) {
            return list.get(0).getRepeatingExtension(Reminder.class);
        }
        return null;
    }

    public static class Transparency
    extends ValueConstruct {
        public static final String OPAQUE_VALUE = "http://schemas.google.com/g/2005#event.opaque";
        public static final String TRANSPARENT_VALUE = "http://schemas.google.com/g/2005#event.transparent";
        public static final Transparency OPAQUE = new Transparency("http://schemas.google.com/g/2005#event.opaque");
        public static final Transparency TRANSPARENT = new Transparency("http://schemas.google.com/g/2005#event.transparent");

        public Transparency() {
            super(Namespaces.gNs, "transparency", "value");
        }

        public Transparency(String string) {
            super(Namespaces.gNs, "transparency", "value", string);
        }

        public static ExtensionDescription getDefaultDescription() {
            return new ExtensionDescription(Transparency.class, Namespaces.gNs, "transparency");
        }
    }

    public static class Visibility
    extends ValueConstruct {
        public static final String DEFAULT_VALUE = "http://schemas.google.com/g/2005#event.default";
        public static final String PUBLIC_VALUE = "http://schemas.google.com/g/2005#event.public";
        public static final String CONFIDENTIAL_VALUE = "http://schemas.google.com/g/2005#event.confidential";
        public static final String PRIVATE_VALUE = "http://schemas.google.com/g/2005#event.private";
        public static final Visibility DEFAULT = new Visibility("http://schemas.google.com/g/2005#event.default");
        public static final Visibility PUBLIC = new Visibility("http://schemas.google.com/g/2005#event.public");
        public static final Visibility CONFIDENTIAL = new Visibility("http://schemas.google.com/g/2005#event.confidential");
        public static final Visibility PRIVATE = new Visibility("http://schemas.google.com/g/2005#event.private");

        public Visibility() {
            super(Namespaces.gNs, "visibility", "value");
        }

        public Visibility(String string) {
            super(Namespaces.gNs, "visibility", "value", string);
        }

        public static ExtensionDescription getDefaultDescription() {
            return new ExtensionDescription(Visibility.class, Namespaces.gNs, "visibility");
        }
    }

    public static class EventStatus
    extends ValueConstruct {
        public static final String CONFIRMED_VALUE = "http://schemas.google.com/g/2005#event.confirmed";
        public static final String TENTATIVE_VALUE = "http://schemas.google.com/g/2005#event.tentative";
        public static final String CANCELED_VALUE = "http://schemas.google.com/g/2005#event.canceled";
        public static final EventStatus CONFIRMED = new EventStatus("http://schemas.google.com/g/2005#event.confirmed");
        public static final EventStatus TENTATIVE = new EventStatus("http://schemas.google.com/g/2005#event.tentative");
        public static final EventStatus CANCELED = new EventStatus("http://schemas.google.com/g/2005#event.canceled");

        public EventStatus() {
            super(Namespaces.gNs, "eventStatus", "value");
        }

        public EventStatus(String string) {
            super(Namespaces.gNs, "eventStatus", "value", string);
        }

        public static ExtensionDescription getDefaultDescription() {
            ExtensionDescription extensionDescription = new ExtensionDescription();
            extensionDescription.setExtensionClass(EventStatus.class);
            extensionDescription.setNamespace(Namespaces.gNs);
            extensionDescription.setLocalName("eventStatus");
            extensionDescription.setRepeatable(false);
            return extensionDescription;
        }
    }
}

