/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.spreadsheet.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomElementCollection
implements Extension {
    private Map<String, CustomElement> values = new LinkedHashMap<String, CustomElement>();

    public String getValue(String string) {
        CustomElement customElement = this.values.get(string.toLowerCase());
        if (customElement == null) {
            return null;
        }
        return customElement.getValue();
    }

    public void setValueLocal(String string, String string2) {
        if (string2.startsWith("=")) {
            throw new IllegalArgumentException("Formulas are not supported.");
        }
        this.values.put(string.toLowerCase(), new CustomElement(string2));
    }

    public void clearValueLocal(String string) {
        this.values.remove(string.toLowerCase());
    }

    public void replaceWithLocal(CustomElementCollection customElementCollection) {
        this.values.clear();
        this.values.putAll(customElementCollection.values);
    }

    public Set<String> getTags() {
        return this.values.keySet();
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(CustomElementCollection.class);
        extensionDescription.setNamespace(Namespaces.gSpreadCustomNs);
        extensionDescription.setLocalName("*");
        extensionDescription.setAggregate(true);
        return extensionDescription;
    }

    @Override
    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        for (Map.Entry<String, CustomElement> entry : this.values.entrySet()) {
            ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
            xmlWriter.simpleElement(Namespaces.gSpreadCustomNs, entry.getKey(), arrayList, entry.getValue().getValue());
        }
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new CustomElementHandler(string2);
    }

    private class CustomElementHandler
    extends XmlParser.ElementHandler {
        private String tagName;

        public CustomElementHandler(String string) {
            this.tagName = string;
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
        }

        public void processEndElement() throws ParseException {
            if (this.value == null) {
                CustomElementCollection.this.values.put(this.tagName, new CustomElement(null));
            } else {
                CustomElementCollection.this.values.put(this.tagName, new CustomElement(this.value));
            }
        }
    }

    private class CustomElement {
        private String value;

        public CustomElement(String string) {
            this.value = string;
        }

        public CustomElement(String string, String string2) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }
}

