/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class BatchStatus
extends ExtensionPoint
implements Extension {
    private int code;
    private String reason;
    private ContentType contentType;
    private String content;

    public BatchStatus() {
    }

    public BatchStatus(ServiceException serviceException) {
        this.code = serviceException.getHttpErrorCodeOverride();
        if (this.code == -1) {
            this.code = 500;
        }
        this.reason = serviceException.getMessage();
        this.contentType = serviceException.getResponseContentType();
        this.content = serviceException.getResponseBody();
    }

    public static BatchStatus createSuccessStatus() {
        BatchStatus batchStatus = new BatchStatus();
        batchStatus.setCode(200);
        batchStatus.setReason("Success");
        return batchStatus;
    }

    public static BatchStatus createCreatedStatus() {
        BatchStatus batchStatus = new BatchStatus();
        batchStatus.setCode(201);
        batchStatus.setReason("Created");
        return batchStatus;
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(BatchStatus.class);
        extensionDescription.setNamespace(Namespaces.batchNs);
        extensionDescription.setLocalName("status");
        extensionDescription.setRepeatable(false);
        return extensionDescription;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(4);
        if (this.code > 0) {
            arrayList.add(new XmlWriter.Attribute("code", Integer.toString(this.code)));
        }
        if (this.reason != null) {
            arrayList.add(new XmlWriter.Attribute("reason", this.reason));
        }
        if (this.contentType != null) {
            this.contentType.getAttributes().remove("charset");
            arrayList.add(new XmlWriter.Attribute("content-type", this.contentType.toString()));
        }
        this.generateStartElement(xmlWriter, Namespaces.batchNs, "status", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        if (this.content != null) {
            xmlWriter.characters(this.content);
        }
        xmlWriter.endElement(Namespaces.batchNs, "status");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new BatchStatusElementHandler(extensionProfile, attributes);
    }

    private class BatchStatusElementHandler
    extends ExtensionPoint.ExtensionHandler {
        private BatchStatusElementHandler(ExtensionProfile extensionProfile, Attributes attributes) throws ParseException, IOException {
            String string;
            String string2;
            super(extensionProfile, BatchStatus.class);
            String string3 = attributes.getValue("code");
            if (string3 != null) {
                try {
                    BatchStatus.this.setCode(Integer.parseInt(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Invalid integer value for code attribute : '" + string3 + "'", numberFormatException);
                }
            }
            if ((string2 = attributes.getValue("reason")) != null) {
                BatchStatus.this.setReason(string2);
            }
            if ((string = attributes.getValue("content-type")) != null) {
                try {
                    BatchStatus.this.setContentType(new ContentType(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Invalid content type: " + string, illegalArgumentException);
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (this.value != null) {
                BatchStatus.this.setContent(this.value);
            }
        }
    }
}

