/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationException
extends ServiceException {
    private String authHeader;
    private String scheme;
    private Map<String, String> parameters = new HashMap<String, String>();
    private static final Pattern SCHEME_PATTERN = Pattern.compile("([^\\s$]*)\\s*(.*)?");
    private static String TOKEN = "[\\p{ASCII}&&[^\\p{Cntrl} \t;/=\\[\\]\\(\\)\\<\\>\\@\\,\\:\\\"\\?\\=]]+";
    private static final Pattern PARAM_PATTERN = Pattern.compile("(" + TOKEN + ")" + "\\s*=\\s*" + "(?:" + "\"([^\"]*)\"" + "|" + "(" + TOKEN + ")?" + ")");

    public AuthenticationException(String string, String string2) {
        super(string);
        this.initFromAuthHeader(string2);
    }

    public AuthenticationException(String string) {
        super(string);
    }

    public AuthenticationException(HttpURLConnection httpURLConnection) throws IOException {
        super(httpURLConnection);
        this.initFromAuthHeader(httpURLConnection.getHeaderField("WWW-Authenticate"));
    }

    private void initFromAuthHeader(String string) {
        this.authHeader = string;
        if (string == null) {
            throw new NullPointerException("No authentication header information");
        }
        Matcher matcher = SCHEME_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalStateException("Unable to parse auth header: " + string);
        }
        this.scheme = matcher.group(1);
        if (matcher.groupCount() > 1) {
            Matcher matcher2 = PARAM_PATTERN.matcher(matcher.group(2));
            while (matcher2.find()) {
                String string2 = matcher2.group(2);
                if (string2 == null) {
                    string2 = matcher2.group(3);
                }
                this.parameters.put(matcher2.group(1), string2);
            }
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.parameters.get("realm");
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getAuthHeader() {
        return this.authHeader;
    }
}

