/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.ContentType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceException
extends Exception {
    protected int httpErrorCodeOverride = -1;
    protected ContentType responseContentType;
    protected String responseBody;
    private Map<String, List<String>> httpHeaders = new HashMap<String, List<String>>();

    public ServiceException(String string) {
        super(string);
    }

    public ServiceException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ServiceException(Throwable throwable) {
        super(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceException(HttpURLConnection httpURLConnection) throws IOException {
        super(httpURLConnection.getResponseMessage());
        StringBuilder stringBuilder;
        this.httpHeaders = Collections.unmodifiableMap(httpURLConnection.getHeaderFields());
        this.responseContentType = new ContentType(httpURLConnection.getContentType());
        int n = httpURLConnection.getContentLength();
        if (n < 0) {
            stringBuilder = new StringBuilder();
        } else if (n > 0) {
            stringBuilder = new StringBuilder(n);
        } else {
            return;
        }
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream != null) {
            try {
                String string;
                String string2 = this.responseContentType.getAttributes().get("charset");
                if (string2 == null) {
                    string2 = "iso8859-1";
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                    stringBuilder.append('\n');
                }
                this.responseBody = stringBuilder.toString();
            }
            finally {
                inputStream.close();
            }
        }
    }

    public int getHttpErrorCodeOverride() {
        return this.httpErrorCodeOverride;
    }

    public void setHttpErrorCodeOverride(int n) {
        this.httpErrorCodeOverride = n;
    }

    public ContentType getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(ContentType contentType) {
        this.responseContentType = contentType;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String string) {
        this.responseBody = string;
    }

    public Map<String, List<String>> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public String toString() {
        if (this.responseBody == null) {
            return super.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("\n");
        stringBuilder.append(this.responseBody);
        return stringBuilder.toString();
    }
}

