/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Element;

public class IdentifiersParser
implements ITypeParser {
    private static String NAMESPACE = "http://concierge.sourceforge.jp/ns/identifiers";
    private static String PREFIX = "ids";
    private static String TAGNAME = "identifier";
    private static String ATTRIBUTE = "type";
    private static String MESSAGE = "Each ID ([type]:=[value]) must be separate by a COMMA, e.g. \"isbn:=4-10-199025, doi:=10.10.16/342\".";
    public static String DELIM_IDTYPE_ID = ":=";
    public static String DELIM_ID_ID = ",";

    @Override
    public void putToElement(Element data, String str) {
        if (str != null) {
            String[] words = str.split(DELIM_ID_ID);
            DataDomImpl.removeAllChildren(data);
            int i = 0;
            while (i < words.length) {
                String[] idset;
                if (words[i].trim().length() > 0 && (idset = words[i].split(DELIM_IDTYPE_ID)).length == 2) {
                    this.addTypeAndIdToElement(data, idset[0], idset[1]);
                }
                ++i;
            }
        }
    }

    public void addTypeAndIdToElement(Element data, String idtype, String id) {
        if (idtype != null && id != null && idtype.length() > 0 && id.length() > 0) {
            Element e = DataDomImpl.appendElement(data, TAGNAME, PREFIX);
            e.setAttribute(ATTRIBUTE, idtype.trim());
            DataDomImpl.setElementText(e, id.trim());
        }
    }

    @Override
    public ArrayList<String> getMultiText(Element data) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            String idtype = e.getAttribute(ATTRIBUTE);
            String id = DataDomImpl.getElementText(e);
            String idset = String.valueOf(idtype) + DELIM_IDTYPE_ID + id;
            out.add(idset);
            ++i;
        }
        return out;
    }

    @Override
    public ArrayList<String> getIndexValues(Element data, String abc) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            String idtype = e.getAttribute(ATTRIBUTE);
            String id = DataDomImpl.getElementText(e);
            if (abc != null) {
                if (idtype.equalsIgnoreCase(abc)) {
                    out.add(id);
                }
            } else {
                out.add(id);
            }
            ++i;
        }
        return out;
    }

    @Override
    public ArrayList<String> getIndexABC(Element data) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            String idtype = e.getAttribute(ATTRIBUTE);
            out.add(idtype);
            ++i;
        }
        return out;
    }

    @Override
    public String getParserNS() {
        return NAMESPACE;
    }

    @Override
    public String getParserNSPrefix() {
        return PREFIX;
    }

    @Override
    public String getSingleText(Element data) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        String out = "";
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            String idtype = e.getAttribute(ATTRIBUTE);
            String id = DataDomImpl.getElementText(e);
            String idset = String.valueOf(idtype) + DELIM_IDTYPE_ID + id;
            out = i == 0 ? idset : String.valueOf(out) + DELIM_ID_ID + " " + idset;
            ++i;
        }
        return out;
    }

    @Override
    public String getMessage() {
        return MESSAGE;
    }
}

