/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactoryExtension;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteURLContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.UpdateSiteFeatureReference;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.core.connection.IResponse;
import org.eclipse.update.internal.model.SiteWithTimestamp;

public class SiteURLFactory
extends BaseSiteFactory
implements ISiteFactoryExtension {
    @Override
    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        return this.createSite(url, null);
    }

    @Override
    public ISite createSite(URL url, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        IResponse response;
        SiteURLContentProvider contentProvider;
        InputStream siteStream;
        Site site;
        block14: {
            block15: {
                site = null;
                siteStream = null;
                contentProvider = new SiteURLContentProvider(url);
                URL resolvedURL = URLEncoder.encode(url);
                response = ConnectionFactory.get(resolvedURL);
                UpdateManagerUtils.checkConnectionResult(response, resolvedURL);
                siteStream = response.getInputStream(monitor);
                if (siteStream != null) break block14;
                if (siteStream == null) break block15;
                try {
                    siteStream.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        try {
            try {
                SiteURLFactory factory = this;
                site = (Site)factory.parseSite(siteStream);
                site.setSiteContentProvider(contentProvider);
                contentProvider.setSite(site);
                site.resolve(url, url);
                site.markReadOnly();
                ((SiteWithTimestamp)site).setTimestamp(new Date(response.getLastModified()));
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteURLFactory_UnableToCreateURL, (Object[])new String[]{url == null ? "" : url.toExternalForm()}), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteURLFactory_UnableToAccessSiteStream, (Object[])new String[]{url == null ? "" : url.toExternalForm()}), 42, e);
            }
        }
        catch (Throwable throwable) {
            if (siteStream != null) {
                try {
                    siteStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (siteStream != null) {
            try {
                siteStream.close();
            }
            catch (IOException iOException) {}
        }
        return site;
    }

    @Override
    public boolean canParseSiteType(String type) {
        return super.canParseSiteType(type) || "org.eclipse.update.core.http".equalsIgnoreCase(type);
    }

    @Override
    public SiteFeatureReferenceModel createFeatureReferenceModel() {
        return new UpdateSiteFeatureReference();
    }
}

