/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    private static HTMLTransfer _instance = new HTMLTransfer();
    private static final String TEXT_HTML = "text/html";
    private static final int TEXT_HTML_ID = HTMLTransfer.registerType("text/html");
    private static final String TEXT_HTML2 = "TEXT/HTML";
    private static final int TEXT_HTML2_ID = HTMLTransfer.registerType("TEXT/HTML");

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int charCount = string.length();
        char[] chars = new char[charCount + 1];
        string.getChars(0, charCount, chars, 0);
        int byteCount = chars.length * 2;
        int pValue = OS.g_malloc(byteCount);
        if (pValue == 0) {
            return;
        }
        OS.memmove(pValue, chars, byteCount);
        transferData.length = byteCount;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int size = transferData.format * transferData.length / 8 / 2 * 2;
        if (size <= 0) {
            return null;
        }
        char[] chars = new char[size / 2];
        OS.memmove(chars, transferData.pValue, size);
        String string = new String(chars);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TEXT_HTML_ID, TEXT_HTML2_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TEXT_HTML, TEXT_HTML2};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

