/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.localstore.HistoryBucket;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStore2;
import org.eclipse.core.internal.localstore.HistoryStoreEntry;
import org.eclipse.core.internal.localstore.IHistoryStoreVisitor;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class HistoryStoreConverter {
    public IStatus convertHistory(Workspace workspace, IPath location, int limit, HistoryStore2 destination, boolean rename) {
        if (!location.toFile().isDirectory()) {
            return Status.OK_STATUS;
        }
        IPath indexFile = location.append(".index");
        if (!indexFile.toFile().isFile()) {
            return Status.OK_STATUS;
        }
        long start = System.currentTimeMillis();
        final CoreException[] exception = new CoreException[1];
        final BucketTree tree = destination.getTree();
        final HistoryBucket currentBucket = (HistoryBucket)tree.getCurrent();
        HistoryStore source = new HistoryStore(workspace, location, limit);
        source.accept((IPath)Path.ROOT, new IHistoryStoreVisitor(){

            @Override
            public boolean visit(HistoryStoreEntry state) {
                try {
                    tree.loadBucketFor(state.getPath());
                }
                catch (CoreException e) {
                    exception[0] = e;
                    return false;
                }
                currentBucket.addBlob(state.getPath(), state.getUUID(), state.getLastModified());
                return true;
            }
        }, true);
        try {
            tree.getCurrent().save();
            source.shutdown(null);
        }
        catch (CoreException e) {
            exception[0] = e;
        }
        if (Policy.DEBUG_HISTORY) {
            Policy.debug((String)("Time to convert local history: " + (System.currentTimeMillis() - start) + "ms."));
        }
        if (exception[0] != null) {
            String conversionFailed = CompatibilityMessages.history_conversionFailed;
            MultiStatus failure = new MultiStatus("org.eclipse.core.resources", 567, new IStatus[]{exception[0].getStatus()}, conversionFailed, null);
            return failure;
        }
        if (rename) {
            indexFile.toFile().renameTo(indexFile.addFileExtension(Long.toString(System.currentTimeMillis())).toFile());
        }
        String conversionOk = CompatibilityMessages.history_conversionSucceeded;
        return new Status(1, "org.eclipse.core.resources", 0, conversionOk, null);
    }
}

