/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.styledtexteditor;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.editor.DataDialog;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.ImageUpdateListener;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.MemoGraph;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.DataHeaderValue;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.EmbeddedObject;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.HTMLReader;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.HTMLWriter;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.SizeDialog;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.StyleManager;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.StyleModifyListener;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.StyledTextEditorDropListener;
import jp.sourceforge.concierge.util.DataDomTransfer;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class StyledTextEditor
extends Composite {
    public static final int LISTINDENTSIZE = 25;
    private static final int DEFAULTIMAGEWIDTH = 240;
    private static final int DEFAULTINDENTRATIO = 5;
    private Color linkcolor = new Color(null, 0, 0, 255);
    private StyleManager stylemanager = null;
    public static final String IMAGECHAR = "\ufffc";
    public static final String INDENTCHAR = "\u30fb ";
    public static final String TABCHAR = "\t";
    private StyledText textview;
    private Label infolabel;
    private ArrayList<EmbeddedObject> eobjects;
    private MemoGraph memoview = null;
    private IPropertyChangeListener propertyChangeListener = null;
    private StyleModifyListener styleModifyListener = null;
    private ModifyListener modlistener = null;

    private EmbeddedObject getEmbeddedObjectAtLocation(Point l) {
        int i = 0;
        while (i < this.eobjects.size()) {
            EmbeddedObject o = this.eobjects.get(i);
            Point sz = o.getSize();
            if (sz == null) {
                Rectangle r = o.getImage().getBounds();
                sz = new Point(r.width, r.height);
            }
            int bl = this.textview.getBaseline(o.getOffset());
            Point p = this.textview.getLocationAtOffset(o.getOffset());
            if (p.x <= l.x && l.x < p.x + sz.x && p.y + bl - sz.y <= l.y && l.y <= p.y + bl) {
                return o;
            }
            ++i;
        }
        return null;
    }

    private void hookContextMenu() {
        this.textview.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                switch (event.button) {
                    case 1: {
                        if ((event.stateMask & 0x40000) != 0) break;
                        return;
                    }
                }
                Menu menu = new Menu((Decorations)StyledTextEditor.this.textview.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Cut");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        StyledTextEditor.this.textview.cut();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Copy");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        StyledTextEditor.this.textview.copy();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Paste");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        StyledTextEditor.this.textview.paste();
                    }
                });
                final EmbeddedObject o = StyledTextEditor.this.getEmbeddedObjectAtLocation(new Point(event.x, event.y));
                if (o != null && o.getDocument() != null) {
                    item = new MenuItem(menu, 2);
                    item = new MenuItem(menu, 8);
                    item.setText("Edit metadata");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            Document doc = o.getDocument();
                            String typename = DataDomImpl.getDefaultType((Document)doc);
                            DataDialog dd = new DataDialog(StyledTextEditor.this.textview.getShell(), 0);
                            dd.setDocument(doc, typename, (Object)"jp.sourceforge.concierge.plugin.labnote");
                            if (dd.open() != 0) {
                                return;
                            }
                            Point p = o.getSize();
                            StyleRange sr = StyledTextEditor.this.textview.getStyleRangeAtOffset(o.getOffset());
                            sr.start = o.getOffset();
                            sr.length = 1;
                            sr.metrics = new GlyphMetrics(p.y, 0, p.x);
                            StyledTextEditor.this.textview.setStyleRange(sr);
                            StyledTextEditor.this.textview.redraw();
                            StyledTextEditor.this.textview.update();
                        }
                    });
                }
                if (o != null && o.resizable()) {
                    item = new MenuItem(menu, 8);
                    item.setText(LabNotePlugin.getString("ConciergeEditor.10"));
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            Point sz = o.getSize();
                            if (sz == null) {
                                Rectangle rect = o.getImage().getBounds();
                                sz = new Point(rect.width, rect.height);
                            }
                            SizeDialog szdlg = new SizeDialog(StyledTextEditor.this.textview.getShell(), 0, StyledTextEditor.this.textview, o);
                            szdlg.open();
                        }
                    });
                    item = new MenuItem(menu, 8);
                    item.setText("Memo");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            try {
                                IViewPart iv = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("jp.sourceforge.concierge.plugin.memograph");
                                if (iv == null) {
                                    return;
                                }
                                StyledTextEditor.this.memoview = (MemoGraph)iv;
                                StyledTextEditor.this.memoview.setImage(o.getOriginalImage(), o.getMemoImage());
                                StyledTextEditor.this.memoview.setUpdateListener(new ImageUpdateListener(){

                                    public void imageUpdated(Image memo, Image org) {
                                        if (StyledTextEditor.this.textview == null || StyledTextEditor.this.textview.isDisposed()) {
                                            return;
                                        }
                                        o.setImage(org, memo);
                                        StyledTextEditor.this.textview.redraw();
                                        if (StyledTextEditor.this.modlistener != null) {
                                            StyledTextEditor.this.modlistener.modifyText(null);
                                        }
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                    });
                }
                Point tp = StyledTextEditor.this.textview.getLocation();
                Point dp = StyledTextEditor.this.textview.toDisplay(tp.x, tp.y);
                menu.setLocation(event.x + dp.x, event.y + dp.y);
                menu.setVisible(true);
                Display display = StyledTextEditor.this.textview.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                menu.dispose();
            }
        });
        this.textview.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StyledTextEditor.this.modlistener != null) {
                    StyledTextEditor.this.modlistener.modifyText(e);
                }
            }
        });
        this.textview.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                EmbeddedObject o = StyledTextEditor.this.getEmbeddedObjectAtLocation(new Point(e.x, e.y));
                if (o != null) {
                    StyledTextEditor.this.textview.setCursor(new Cursor(null, 0));
                    Document doc = o.getDocument();
                    if (doc == null) {
                        return;
                    }
                    String str = "ID:" + String.valueOf(DomImpl.getID((Document)doc));
                    String txt = DomImpl.getAllText((Document)doc);
                    if (txt.length() != 0) {
                        str = String.valueOf(str) + "\n" + txt;
                    }
                    StyledTextEditor.this.textview.setToolTipText(str);
                } else {
                    StyledTextEditor.this.textview.setCursor(new Cursor(null, 19));
                    StyledTextEditor.this.textview.setToolTipText("");
                }
            }
        });
    }

    private void updateCaretInfo() {
        int coffset = this.textview.getCaretOffset();
        int line = this.textview.getLineAtOffset(coffset);
        int col = coffset - this.textview.getOffsetAtLine(line);
        this.infolabel.setText("    Line:" + line + "  Column:" + col + "   ");
    }

    private void setPropertyChangeListener() {
        this.removePropertyChangeListener();
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String key = event.getProperty();
                if (key.equals("updatepreferencestore")) {
                    StyledTextEditor.this.stylemanager.updateStyle();
                    if (StyledTextEditor.this.styleModifyListener != null) {
                        StyledTextEditor.this.styleModifyListener.modifyStyle();
                    }
                }
            }
        };
        LabNotePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void removePropertyChangeListener() {
        if (this.propertyChangeListener != null) {
            LabNotePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    public void setStyleModifyListener(StyleModifyListener listener) {
        this.styleModifyListener = listener;
    }

    public StyledTextEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 1;
        gl.verticalSpacing = 1;
        this.setLayout((Layout)gl);
        Composite headerComp = new Composite((Composite)this, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        headerComp.setLayout((Layout)gl);
        headerComp.setLayoutData((Object)new GridData(768));
        ToolBar tb = new ToolBar(headerComp, 131072);
        tb.setLayoutData((Object)new GridData());
        ToolItem ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/bold.png").createImage());
        ti.setToolTipText("Bold");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, 1);
                newstyle.fontStyle = StyledTextEditor.this.stylemanager.isApplyed(p, newstyle, 4) ? -2 : 1;
                StyledTextEditor.this.stylemanager.setNewStyleAtRange(p, newstyle, 4);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/italic.png").createImage());
        ti.setToolTipText("Italic");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, 2);
                newstyle.fontStyle = StyledTextEditor.this.stylemanager.isApplyed(p, newstyle, 4) ? -3 : 2;
                StyledTextEditor.this.stylemanager.setNewStyleAtRange(p, newstyle, 4);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/underline.png").createImage());
        ti.setToolTipText("Underline");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.underline = true;
                newstyle.underline = !StyledTextEditor.this.stylemanager.isApplyed(p, newstyle, 32);
                StyledTextEditor.this.stylemanager.setNewStyleAtRange(p, newstyle, 32);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/strikeout.png").createImage());
        ti.setToolTipText("Strikeout");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.strikeout = true;
                newstyle.strikeout = !StyledTextEditor.this.stylemanager.isApplyed(p, newstyle, 64);
                StyledTextEditor.this.stylemanager.setNewStyleAtRange(p, newstyle, 64);
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/list.png").createImage());
        ti.setToolTipText("List");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void setBullet(int type) {
                Point p = StyledTextEditor.this.textview.getSelection();
                int sl = StyledTextEditor.this.textview.getLineAtOffset(p.x);
                int el = StyledTextEditor.this.textview.getLineAtOffset(p.y);
                int i = sl;
                while (i <= el) {
                    Bullet nblt;
                    StyleRange sr;
                    Bullet blt = StyledTextEditor.this.textview.getLineBullet(i);
                    int cidt = 0;
                    if (blt != null) {
                        cidt = blt.style.metrics.width;
                        if (blt.text.length() > 0) {
                            cidt -= 25;
                        }
                        StyledTextEditor.this.textview.setLineBullet(i, 1, null);
                    }
                    if (type != 3) {
                        sr = new StyleRange();
                        sr.metrics = new GlyphMetrics(2, 0, 25 + cidt);
                        nblt = new Bullet(16, sr);
                        if (type == 1) {
                            nblt.text = String.valueOf(i - sl + 1);
                        } else if (type == 2) {
                            nblt.text = LabNotePlugin.getDefault().getPreferenceStore().getString("mark");
                        }
                        StyledTextEditor.this.textview.setLineBullet(i, 1, nblt);
                    } else if (cidt > 0) {
                        sr = new StyleRange();
                        sr.metrics = new GlyphMetrics(2, 0, cidt);
                        nblt = new Bullet(16, sr);
                        nblt.text = "";
                        StyledTextEditor.this.textview.setLineBullet(i, 1, nblt);
                    }
                    ++i;
                }
                StyledTextEditor.this.textview.redraw();
                StyledTextEditor.this.textview.layout();
            }

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Decorations)StyledTextEditor.this.textview.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Unordered list");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        this.setBullet(2);
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Ordered list");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        this.setBullet(1);
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("No list");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        this.setBullet(3);
                    }
                });
                ToolItem ti = (ToolItem)e.widget;
                Point cp = ti.getDisplay().getCursorLocation();
                menu.setLocation(cp.x, cp.y);
                menu.setVisible(true);
                Display display = StyledTextEditor.this.textview.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                menu.dispose();
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/heading.png").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Decorations)StyledTextEditor.this.textview.getShell(), 8);
                int i = 0;
                while (i < 1) {
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText("Heading");
                    item.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            Color backColor;
                            int x = StyledTextEditor.this.textview.getCaretOffset();
                            int sl = StyledTextEditor.this.textview.getLineAtOffset(x);
                            MenuItem obj = (MenuItem)e.getSource();
                            Menu parentMenu = obj.getParent();
                            int index = parentMenu.indexOf(obj);
                            int red = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred" + index);
                            int green = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen" + index);
                            int blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue" + index);
                            Color foreColor = StyledTextEditor.this.stylemanager.newColor((Device)StyledTextEditor.this.textview.getDisplay(), red, green, blue);
                            red = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred" + index);
                            green = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen" + index);
                            blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue" + index);
                            Color lineColor = backColor = StyledTextEditor.this.stylemanager.newColor((Device)StyledTextEditor.this.textview.getDisplay(), red, green, blue);
                            StyledTextEditor.this.stylemanager.setHeadStyle(sl, LabNotePlugin.getDefault().getPreferenceStore().getString("fontname" + index), LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize" + index), LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle" + index), LabNotePlugin.getDefault().getPreferenceStore().getBoolean("underline" + index), foreColor, backColor);
                            StyledTextEditor.this.textview.setLineBackground(sl, 1, lineColor);
                            StyledTextEditor.this.textview.setLineBullet(sl, 1, null);
                            StyledTextEditor.this.textview.setLineBullet(sl, 1, StyledTextEditor.this.stylemanager.getDummyBullet());
                            if (StyledTextEditor.this.styleModifyListener != null) {
                                StyledTextEditor.this.styleModifyListener.modifyStyle();
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    ++i;
                }
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Normal");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        Color backColor;
                        int x = StyledTextEditor.this.textview.getCaretOffset();
                        int sl = StyledTextEditor.this.textview.getLineAtOffset(x);
                        int red = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred");
                        int green = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen");
                        int blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue");
                        Color foreColor = StyledTextEditor.this.stylemanager.newColor((Device)StyledTextEditor.this.textview.getDisplay(), red, green, blue);
                        red = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred");
                        green = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen");
                        blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue");
                        Color lineColor = backColor = StyledTextEditor.this.stylemanager.newColor((Device)StyledTextEditor.this.textview.getDisplay(), red, green, blue);
                        StyledTextEditor.this.stylemanager.setHeadStyle(sl, LabNotePlugin.getDefault().getPreferenceStore().getString("fontname"), LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize"), LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle"), LabNotePlugin.getDefault().getPreferenceStore().getBoolean("underline"), foreColor, backColor);
                        StyledTextEditor.this.textview.setLineBackground(sl, 1, lineColor);
                        StyledTextEditor.this.textview.setLineBullet(sl, 1, null);
                        if (StyledTextEditor.this.styleModifyListener != null) {
                            StyledTextEditor.this.styleModifyListener.modifyStyle();
                        }
                    }
                });
                ToolItem ti = (ToolItem)e.widget;
                Point cp = ti.getDisplay().getCursorLocation();
                menu.setLocation(cp.x, cp.y);
                menu.setVisible(true);
                Display display = StyledTextEditor.this.textview.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                menu.dispose();
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/foreground.png").createImage());
        ti.setToolTipText("Foreground");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                ColorDialog cd = new ColorDialog(StyledTextEditor.this.textview.getShell());
                RGB rgb = cd.open();
                if (rgb == null) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.foreground = new Color(null, rgb.red, rgb.green, rgb.blue);
                StyledTextEditor.this.stylemanager.setNewStyleAtRange(p, newstyle, 1);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/background.png").createImage());
        ti.setToolTipText("Background");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                ColorDialog cd = new ColorDialog(StyledTextEditor.this.textview.getShell());
                RGB rgb = cd.open();
                if (rgb == null) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.background = new Color(null, rgb.red, rgb.green, rgb.blue);
                StyledTextEditor.this.stylemanager.setNewStyleAtRange(p, newstyle, 2);
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/indent.png").createImage());
        ti.setToolTipText("indent");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                int sl = StyledTextEditor.this.textview.getLineAtOffset(p.x);
                int el = StyledTextEditor.this.textview.getLineAtOffset(p.y);
                int i = sl;
                while (i <= el) {
                    block4: {
                        String btxt;
                        int cidt;
                        block3: {
                            Bullet blt = StyledTextEditor.this.textview.getLineBullet(i);
                            cidt = 0;
                            btxt = "";
                            if (blt == null) break block3;
                            GlyphMetrics gm = blt.style.metrics;
                            if (gm.ascent == 1) break block4;
                            cidt = gm.width / 5;
                            btxt = blt.text;
                        }
                        Bullet nblt = StyledTextEditor.this.stylemanager.getIndentBullet(cidt + LabNotePlugin.getDefault().getPreferenceStore().getInt("indent"));
                        nblt.text = btxt;
                        StyledTextEditor.this.textview.setLineBullet(i, 1, null);
                        StyledTextEditor.this.textview.setLineBullet(i, 1, nblt);
                    }
                    ++i;
                }
                StyledTextEditor.this.textview.setSelection(p);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(LabNotePlugin.getImageDescriptor("icons/noindent.png").createImage());
        ti.setToolTipText("no indent");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = StyledTextEditor.this.textview.getSelection();
                int sl = StyledTextEditor.this.textview.getLineAtOffset(p.x);
                int el = StyledTextEditor.this.textview.getLineAtOffset(p.y);
                int i = sl;
                while (i <= el) {
                    block8: {
                        int istep;
                        int df;
                        String btxt;
                        int cidt;
                        block7: {
                            Bullet blt = StyledTextEditor.this.textview.getLineBullet(i);
                            cidt = 0;
                            btxt = "";
                            if (blt == null) break block7;
                            GlyphMetrics gm = blt.style.metrics;
                            if (gm.ascent == 1) break block8;
                            cidt = gm.width / 5;
                            btxt = blt.text;
                        }
                        if ((df = cidt - (istep = LabNotePlugin.getDefault().getPreferenceStore().getInt("indent"))) < 0) {
                            df = 0;
                        }
                        Bullet nblt = StyledTextEditor.this.stylemanager.getIndentBullet(df);
                        if (btxt.length() <= 0 || nblt.style.metrics.width >= 25) {
                            nblt.text = btxt;
                            StyledTextEditor.this.textview.setLineBullet(i, 1, null);
                            if (df > 0 || btxt.length() > 0) {
                                StyledTextEditor.this.textview.setLineBullet(i, 1, nblt);
                            }
                        }
                    }
                    ++i;
                }
                StyledTextEditor.this.textview.setSelection(p);
            }
        });
        Composite bodyComp = new Composite((Composite)this, 0);
        bodyComp.setLayoutData((Object)new GridData(1808));
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        bodyComp.setLayout((Layout)gl);
        this.textview = new StyledText(bodyComp, 2816);
        this.textview.setLayoutData((Object)new GridData(1808));
        this.textview.setLineSpacing(5);
        this.eobjects = new ArrayList();
        this.stylemanager = new StyleManager(this.textview);
        this.infolabel = new Label(bodyComp, 0);
        this.infolabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.updateCaretInfo();
        this.setPropertyChangeListener();
        this.stylemanager.LoadPrefNormalStyle();
        this.textview.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int start = e.start;
                int replaceCharCount = e.end - e.start;
                int newCharCount = e.text.length();
                int cnt = StyledTextEditor.this.eobjects.size();
                int i = 0;
                while (i < cnt) {
                    EmbeddedObject ei = (EmbeddedObject)StyledTextEditor.this.eobjects.get(i);
                    int offset = ei.getOffset();
                    if (start <= offset && offset < start + replaceCharCount) {
                        ei.remove();
                        StyledTextEditor.this.eobjects.remove(ei);
                        ei.setOffset(offset - start);
                        --cnt;
                        --i;
                    } else if (offset >= start) {
                        ei.setOffset(offset += newCharCount - replaceCharCount);
                    }
                    ++i;
                }
            }
        });
        this.textview.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                StyledTextEditor.this.updateCaretInfo();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.textview.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StyledTextEditor.this.updateCaretInfo();
            }
        });
        this.textview.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                StyledTextEditor.this.updateCaretInfo();
                StyledTextEditor.this.stylemanager.updateStyle();
            }
        });
        this.textview.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                GC gc = event.gc;
                StyleRange style = event.style;
                int start = style.start;
                int i = 0;
                while (i < StyledTextEditor.this.eobjects.size()) {
                    EmbeddedObject ei = (EmbeddedObject)StyledTextEditor.this.eobjects.get(i);
                    int offset = ei.getOffset();
                    if (start == offset) {
                        int x = event.x;
                        int y = event.y + event.ascent - style.metrics.ascent;
                        Image img = ei.getImage();
                        Point sz = ei.getSize();
                        if (sz != null) {
                            img = new Image((Device)StyledTextEditor.this.textview.getDisplay(), img.getImageData().scaledTo(sz.x, sz.y));
                            gc.drawImage(img, x, y);
                            img.dispose();
                            break;
                        }
                        gc.drawImage(img, x, y);
                        break;
                    }
                    ++i;
                }
            }
        });
        DropTarget target = new DropTarget((Control)this.textview, 17);
        DataDomTransfer transfer = DataDomTransfer.getInstance();
        Transfer[] types = new Transfer[]{transfer, FileTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new StyledTextEditorDropListener(this));
        this.hookContextMenu();
    }

    private EmbeddedObject createEmbeddedObject(String file, int offset) {
        EmbeddedObject e = new EmbeddedObject(file);
        e.setOffset(offset);
        return e;
    }

    private EmbeddedObject createEmbeddedObject(Document doc, int offset) {
        EmbeddedObject e = new EmbeddedObject(doc);
        e.setOffset(offset);
        return e;
    }

    private void addEmbeddedObject(EmbeddedObject em) {
        Image img = em.getImage();
        this.textview.replaceTextRange(em.getOffset(), 0, IMAGECHAR);
        StyleRange style = new StyleRange();
        style.start = em.getOffset();
        style.length = 1;
        style.foreground = this.textview.getBackground();
        Rectangle rect = img.getBounds();
        if (rect.width > 240) {
            double ratio = 240.0 / (double)rect.width;
            rect.width = (int)((double)rect.width * ratio);
            rect.height = (int)((double)rect.height * ratio);
            em.setSize(new Point(rect.width, rect.height));
        }
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        this.textview.setStyleRange(style);
        this.eobjects.add(em);
    }

    public void addEmbeddedFile(String file) {
        this.addEmbeddedObject(this.createEmbeddedObject(file, this.textview.getCaretOffset()));
    }

    public void addEmbeddedObject(Document doc) {
        this.addEmbeddedObject(this.createEmbeddedObject(doc, this.textview.getCaretOffset()));
    }

    public void setDocument(Document doc) {
        this.reset();
        HTMLReader htconv = new HTMLReader(this.textview, this.eobjects);
        htconv.importFromDocument(doc);
        this.stylemanager.updateStyle();
    }

    public Document getDocument() {
        HTMLWriter htwriter = new HTMLWriter(this.textview, this.eobjects);
        return htwriter.exportToDocument(null, null);
    }

    public void reset() {
        int cnt = this.textview.getCharCount();
        if (cnt > 0) {
            this.textview.replaceStyleRanges(0, cnt, new StyleRange[]{new StyleRange()});
            this.textview.replaceTextRange(0, cnt, "");
        }
        this.textview.setFont(this.stylemanager.getDefaultFont());
        this.textview.setForeground(this.stylemanager.getDefaultForeground());
        this.textview.setBackground(this.stylemanager.getDefaultBackground());
        this.eobjects.clear();
    }

    public ArrayList<EmbeddedObject> getEmbeddedObject() {
        return this.eobjects;
    }

    public void exportToHtml(String path, ArrayList<DataHeaderValue> bheads, String cssstr) {
        if (path == null) {
            return;
        }
        String ext = FilenameUtils.getExtension((String)path);
        String filename = "metadata.html";
        if (ext.equals("htm") || ext.equals("html")) {
            filename = FilenameUtils.getName((String)path);
            path = FilenameUtils.getFullPath((String)path);
        }
        HTMLWriter htwriter = new HTMLWriter(this.textview, this.eobjects);
        htwriter.exportToFile(path, filename, cssstr, bheads);
    }

    public void exportToHtml(ArrayList<DataHeaderValue> bheads, String cssstr, String subdir) {
        DirectoryDialog dd = new DirectoryDialog(this.textview.getShell(), 8192);
        dd.setMessage(LabNotePlugin.getString("ConciergeEditor.22"));
        String path = dd.open();
        if (path == null) {
            return;
        }
        path = String.valueOf(path) + File.separator + subdir;
        this.exportToHtml(path, bheads, cssstr);
    }

    public void removeEmbeddedObjectByDocument(Document doc) {
        int i = 0;
        while (i < this.eobjects.size()) {
            EmbeddedObject eo = this.eobjects.get(i);
            if (DomImpl.equalsByID((Document)eo.getDocument(), (Document)doc)) {
                this.textview.replaceTextRange(eo.getOffset(), 1, "");
                eo.remove();
                this.eobjects.remove(i);
                break;
            }
            ++i;
        }
    }

    public void updateEmbeddedObjectByDocument(Document doc) {
        int i = 0;
        while (i < this.eobjects.size()) {
            EmbeddedObject eo = this.eobjects.get(i);
            if (DomImpl.equalsByID((Document)eo.getDocument(), (Document)doc)) {
                eo.setDocument(doc);
                break;
            }
            ++i;
        }
    }

    public void setModifyListener(ModifyListener listener) {
        this.modlistener = listener;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modlistener = null;
    }

    public void close() {
        if (!this.memoview.isDisposed()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.memoview);
        }
    }

    public void dispose() {
        this.linkcolor.dispose();
        super.dispose();
    }
}

