/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.internal.databinding.viewers.CheckableCheckedElementsObservableSet;
import org.eclipse.jface.internal.databinding.viewers.CheckboxViewerCheckedElementsObservableSet;
import org.eclipse.jface.internal.databinding.viewers.SelectionProviderMultipleSelectionObservableList;
import org.eclipse.jface.internal.databinding.viewers.SelectionProviderSingleSelectionObservableValue;
import org.eclipse.jface.internal.databinding.viewers.ViewerInputObservableValue;
import org.eclipse.jface.internal.databinding.viewers.ViewerMultipleSelectionObservableList;
import org.eclipse.jface.internal.databinding.viewers.ViewerSingleSelectionObservableValue;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class ViewersObservables {
    public static IObservableValue observeSingleSelection(ISelectionProvider selectionProvider) {
        if (selectionProvider instanceof Viewer) {
            return ViewersObservables.observeSingleSelection((Viewer)selectionProvider);
        }
        return new SelectionProviderSingleSelectionObservableValue(SWTObservables.getRealm(Display.getDefault()), selectionProvider);
    }

    public static IObservableList observeMultiSelection(ISelectionProvider selectionProvider) {
        if (selectionProvider instanceof Viewer) {
            return ViewersObservables.observeMultiSelection((Viewer)selectionProvider);
        }
        return new SelectionProviderMultipleSelectionObservableList(SWTObservables.getRealm(Display.getDefault()), selectionProvider, Object.class);
    }

    public static IViewerObservableValue observeSingleSelection(Viewer viewer) {
        return new ViewerSingleSelectionObservableValue(SWTObservables.getRealm(Display.getDefault()), viewer);
    }

    public static IViewerObservableList observeMultiSelection(Viewer viewer) {
        return new ViewerMultipleSelectionObservableList(SWTObservables.getRealm(Display.getDefault()), viewer, Object.class);
    }

    public static IObservableValue observeInput(Viewer viewer) {
        return new ViewerInputObservableValue(SWTObservables.getRealm(viewer.getControl().getDisplay()), viewer);
    }

    public static IObservableSet observeCheckedElements(ICheckable checkable, Object elementType) {
        if (checkable instanceof CheckboxTableViewer) {
            return ViewersObservables.observeCheckedElements((CheckboxTableViewer)checkable, elementType);
        }
        if (checkable instanceof CheckboxTreeViewer) {
            return ViewersObservables.observeCheckedElements((CheckboxTreeViewer)checkable, elementType);
        }
        return new CheckableCheckedElementsObservableSet(SWTObservables.getRealm(Display.getDefault()), checkable, elementType);
    }

    public static IViewerObservableSet observeCheckedElements(CheckboxTableViewer viewer, Object elementType) {
        return new CheckboxViewerCheckedElementsObservableSet(SWTObservables.getRealm(viewer.getControl().getDisplay()), viewer, elementType);
    }

    public static IViewerObservableSet observeCheckedElements(CheckboxTreeViewer viewer, Object elementType) {
        return new CheckboxViewerCheckedElementsObservableSet(SWTObservables.getRealm(viewer.getControl().getDisplay()), viewer, elementType);
    }
}

