/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.plugin.BibTeX.BibTeXMappingDataDomImpl;
import jp.sourceforge.concierge.plugin.ExportReferencePlugin;
import jp.sourceforge.concierge.plugin.ReferBibIX.ReferBibIXMappingDataDomImpl;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatDomImpl;
import jp.sourceforge.concierge.util.IItemToString;
import org.w3c.dom.Document;

public class ItemToString
implements IItemToString {
    public String toString(Document datadoc, Document typedoc) {
        String typename = null;
        if (typedoc != null) {
            typename = TypeDomImpl.getTypeName((Document)typedoc);
        }
        return this.toString(datadoc, typename);
    }

    public String toRTFString(Document datadoc, Document typedoc) {
        String typename = null;
        if (typedoc != null) {
            typename = TypeDomImpl.getTypeName((Document)typedoc);
        }
        return this.toRTFString(datadoc, typename);
    }

    private String toString(Document datadoc, String typename) {
        String type = ExportReferencePlugin.getDefault().getPreferenceStore().getString("ReferenceType");
        if (type.equals("bibtex")) {
            return BibTeXMappingDataDomImpl.createString(datadoc, typename);
        }
        if (type.equals("referbibix")) {
            return ReferBibIXMappingDataDomImpl.createString(datadoc, typename);
        }
        if (type.equals("customize")) {
            return ReferenceDataFormatDomImpl.createPlainText(datadoc, typename);
        }
        return datadoc.toString();
    }

    private String toRTFString(Document datadoc, String typename) {
        String type = ExportReferencePlugin.getDefault().getPreferenceStore().getString("ReferenceType");
        if (type.equals("bibtex")) {
            return BibTeXMappingDataDomImpl.createString(datadoc, typename);
        }
        if (type.equals("referbibix")) {
            return ReferBibIXMappingDataDomImpl.createString(datadoc, typename);
        }
        if (type.equals("customize")) {
            return ReferenceDataFormatDomImpl.createRTFText(datadoc, typename);
        }
        return datadoc.toString();
    }
}

