/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jp.sourceforge.xoonips.XooNIpsItemType;
import jp.sourceforge.xoonips.XooNIpsSimpleItem;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SimpleItemTableViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String PREFTABLECOLUMNWIDTHKEY = "TABLE_SIMPLE34_COLUMNWIDTH";
    public static final String PREFTABLECOLUMNORDER = "TABLE_SIMPLE34_COLUMNORDER";
    public static final String[] xoonipsItemTableHead = new String[]{"Type", "Title", "Contributor", "LastUpdatedDate", "RegistrationDate", "ID"};
    public static final String[] xoonipsItemTableHeadName = new String[]{"Type", "Title", "Contributor", "Last Updated Date", "Registration Date", "Item ID"};
    public static final int XNP_SIMPLE_ITEM_TYPE_INDEX = 0;
    public static final int XNP_SIMPLE_ITEM_TITLE_INDEX = 1;
    public static final int XNP_SIMPLE_ITEM_CONTRIBUTOR_INDEX = 2;
    public static final int XNP_SIMPLE_ITEM_LASTUPDATEDDATE_INDEX = 3;
    public static final int XNP_SIMPLE_ITEM_REGISTRATIONDATE_INDEX = 4;
    public static final int XNP_SIMPLE_ITEM_ID_INDEX = 5;
    public static final int XNP_SIMPLE_ITEM_DESCRIPTION_INDEX = 6;
    private static DateFormat myformat = null;

    public String getColumnText(Object obj, int index) {
        if (obj instanceof XooNIpsSimpleItem) {
            XooNIpsSimpleItem xnpItem = (XooNIpsSimpleItem)obj;
            switch (index) {
                case 3: {
                    Calendar cal = xnpItem.getLastUpdatedDate();
                    if (myformat == null) {
                        myformat = new SimpleDateFormat("MMM d, yyyy HH:mm:ss", Locale.US);
                    }
                    Date date = cal.getTime();
                    String value = myformat.format(date);
                    return value;
                }
                case 4: {
                    Calendar cal = xnpItem.getRegistrationDate();
                    if (myformat == null) {
                        myformat = new SimpleDateFormat("MMM d, yyyy HH:mm:ss", Locale.US);
                    }
                    Date date = cal.getTime();
                    String value = myformat.format(date);
                    return value;
                }
                case 5: {
                    return String.valueOf(xnpItem.getItemID());
                }
                case 1: {
                    return xnpItem.getTitle();
                }
                case 2: {
                    return xnpItem.getUsername();
                }
                case 0: {
                    XooNIpsItemType xnpItemType = xnpItem.getItemType();
                    if (xnpItemType == null) break;
                    return xnpItemType.getTitle();
                }
                case 6: {
                    return xnpItem.getText();
                }
            }
        }
        return this.getText(obj);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

