/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.ProductPreferences;

public class TocSorter {
    public ITocContribution[] orderTocContributions(ITocContribution[] unorderedTocs) {
        ArrayList itemsToOrder = new ArrayList();
        Map categorized = this.categorizeTocs(Arrays.asList(unorderedTocs), itemsToOrder);
        Map nameIdMap = this.createNameIdMap(categorized);
        List orderedItems = ProductPreferences.getTocOrder(itemsToOrder, nameIdMap);
        orderedItems = TocSorter.substituteValues(orderedItems, categorized);
        orderedItems = this.expandCategories(orderedItems);
        return orderedItems.toArray(new ITocContribution[orderedItems.size()]);
    }

    private Map createNameIdMap(Map categorized) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : categorized.keySet()) {
            ITocContribution toc;
            Object value = categorized.get(key);
            if (value instanceof TocCategory) {
                TocCategory category = (TocCategory)value;
                toc = (ITocContribution)category.get(0);
            } else {
                toc = (ITocContribution)value;
            }
            map.put(key, toc.getToc().getLabel());
        }
        return map;
    }

    private Map categorizeTocs(List tocs, List tocOrder) {
        HashMap<String, Object> categorized = new HashMap<String, Object>();
        for (ITocContribution toc : tocs) {
            String id;
            String categoryId;
            try {
                categoryId = toc.getCategoryId();
            }
            catch (Throwable t) {
                String msg = "Error retrieving categoryId from " + ITocContribution.class.getName() + ": " + toc.getClass().getName();
                HelpPlugin.logError(msg, t);
                continue;
            }
            if (categoryId != null && categoryId.length() > 0) {
                TocCategory category = (TocCategory)categorized.get(categoryId);
                if (category == null) {
                    category = new TocCategory(categoryId);
                    categorized.put(categoryId, category);
                    tocOrder.add(categoryId);
                    category.add(toc);
                    continue;
                }
                String tocLabel = toc.getToc().getLabel();
                boolean done = false;
                int next = 0;
                while (next < category.size() && !done) {
                    String nextName = ((ITocContribution)category.get(next)).getToc().getLabel();
                    if (tocLabel.compareToIgnoreCase(nextName) < 0) {
                        done = true;
                        category.add(next, toc);
                    }
                    ++next;
                }
                if (done) continue;
                category.add(toc);
                continue;
            }
            try {
                id = toc.getId();
            }
            catch (Throwable t) {
                String msg = "Error retrieving id from " + ITocContribution.class.getName() + ": " + toc.getClass().getName();
                HelpPlugin.logError(msg, t);
                continue;
            }
            categorized.put(id, toc);
            tocOrder.add(id);
        }
        return categorized;
    }

    private List expandCategories(List entries) {
        ArrayList expanded = new ArrayList();
        for (Object entry : entries) {
            if (entry instanceof ITocContribution) {
                expanded.add(entry);
                continue;
            }
            if (!(entry instanceof TocCategory)) continue;
            expanded.addAll((TocCategory)entry);
        }
        return expanded;
    }

    private static List substituteValues(List items, Map map) {
        if (items != null && map != null) {
            ArrayList result = new ArrayList(items.size());
            for (Object key : items) {
                Object value = map.get(key);
                if (value == null) continue;
                result.add(value);
            }
            return result;
        }
        return null;
    }

    private static class TocCategory
    extends ArrayList {
        private static final long serialVersionUID = 1L;
        private String id;

        public TocCategory(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

