/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.PackageSource;

public class SingleSourcePackage
extends PackageSource {
    BundleLoaderProxy supplier;

    public SingleSourcePackage(String id, BundleLoaderProxy supplier) {
        super(id);
        this.supplier = supplier;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return new SingleSourcePackage[]{this};
    }

    public String toString() {
        return String.valueOf(this.id) + " -> " + this.supplier;
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.supplier.getBundleLoader().findLocalClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.supplier.getBundleLoader().findLocalResource(name);
    }

    @Override
    public Enumeration getResources(String name) {
        return this.supplier.getBundleLoader().findLocalResources(name);
    }

    public boolean equals(Object source) {
        if (this == source) {
            return true;
        }
        if (!(source instanceof SingleSourcePackage)) {
            return false;
        }
        SingleSourcePackage singleSource = (SingleSourcePackage)source;
        return this.supplier == singleSource.supplier && this.id == singleSource.getId();
    }
}

