/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.filters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.filters.OfficeFilter;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hslf.usermodel.PictureData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PPTFilter
extends OfficeFilter {
    HSLFSlideShow slideshow;

    public PPTFilter(String file) throws IOException {
        super(file);
        this.slideshow = new HSLFSlideShow(this.poifs);
    }

    @Override
    public ArrayList<Image> getImages() {
        PictureData[] pics = this.slideshow.getPictures();
        ArrayList<Image> imgs = new ArrayList<Image>();
        int i = 0;
        while (i < pics.length) {
            byte[] data = pics[i].getData();
            try {
                Image img = new Image((Device)PlatformUI.getWorkbench().getDisplay(), (InputStream)new ByteArrayInputStream(data));
                imgs.add(img);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            ++i;
        }
        return imgs;
    }

    @Override
    public String getText() {
        try {
            PowerPointExtractor ext = new PowerPointExtractor(this.poifs);
            return ext.getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

