/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.EmptyDirectoryException;
import org.eclipse.update.internal.core.FeaturePackagedContentProvider;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.BundleManifest;
import org.eclipse.update.internal.model.DefaultPluginParser;
import org.xml.sax.SAXException;

public class SiteFileFactory
extends BaseSiteFactory {
    private SiteFile site;

    @Override
    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        Site site = null;
        InputStream siteStream = null;
        SiteFileFactory factory = this;
        try {
            try {
                String path = url.getFile();
                File siteLocation = new File(path);
                if (siteLocation.isDirectory()) {
                    url = siteLocation.toURL();
                    File siteXMLFile = new File(siteLocation, "site.xml");
                    if (siteXMLFile.exists()) {
                        siteStream = new FileInputStream(siteXMLFile);
                        site = (Site)factory.parseSite(siteStream);
                    } else {
                        site = this.parseSite(siteLocation);
                    }
                } else {
                    try {
                        URL resolvedURL = URLEncoder.encode(url);
                        siteStream = this.openStream(resolvedURL);
                        site = (Site)factory.parseSite(siteStream);
                    }
                    catch (IOException iOException) {
                        File file = new File(url.getFile());
                        File parentDirectory = file.getParentFile();
                        if (parentDirectory != null && !parentDirectory.exists()) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_DirectoryDoesNotExist, (Object[])new String[]{file.getAbsolutePath()}), null);
                        }
                        if (parentDirectory == null || !parentDirectory.isDirectory()) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToObtainParentDirectory, (Object[])new String[]{file.getAbsolutePath()}), null);
                        }
                        site = this.parseSite(parentDirectory);
                    }
                }
                SiteFileContentProvider contentProvider = new SiteFileContentProvider(url);
                site.setSiteContentProvider(contentProvider);
                contentProvider.setSite(site);
                site.resolve(url, url);
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURL, (Object[])new String[]{url == null ? "" : url.toExternalForm()}), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Messages.SiteFileFactory_UnableToAccessSite, 42, e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (siteStream != null) {
                    siteStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (siteStream != null) {
                siteStream.close();
            }
        }
        catch (IOException iOException) {}
        return site;
    }

    private Site parseSite(File directory) throws CoreException {
        this.site = (SiteFile)this.createSiteMapModel();
        if (!directory.exists()) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_FileDoesNotExist, (Object[])new String[]{directory.getAbsolutePath()}), null);
        }
        File pluginPath = new File(directory, "plugins/");
        try {
            this.parsePackagedFeature(directory);
        }
        catch (EmptyDirectoryException ede) {
            UpdateCore.log(ede.getStatus());
        }
        try {
            this.parsePackagedPlugins(pluginPath);
        }
        catch (EmptyDirectoryException ede) {
            UpdateCore.log(ede.getStatus());
        }
        try {
            this.parseInstalledFeature(directory);
        }
        catch (EmptyDirectoryException ede) {
            UpdateCore.log(ede.getStatus());
        }
        try {
            this.parseInstalledPlugins(pluginPath);
        }
        catch (EmptyDirectoryException ede) {
            UpdateCore.log(ede.getStatus());
        }
        return this.site;
    }

    private void parseInstalledFeature(File directory) throws CoreException {
        File featureDir = new File(directory, "features/");
        if (featureDir.exists()) {
            String newFilePath = null;
            try {
                String[] dir = featureDir.list();
                if (dir == null) {
                    throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(directory.getName()) + File.separator + directory.getName() + "directory is empty", null));
                }
                int index = 0;
                while (index < dir.length) {
                    newFilePath = String.valueOf(dir[index]) + (dir[index].endsWith("/") ? "/" : "");
                    File currentFeatureDir = new File(featureDir, newFilePath);
                    File featureXMLFile = new File(currentFeatureDir, "feature.xml");
                    if (!featureXMLFile.exists()) {
                        UpdateCore.warn("Unable to find feature.xml in directory:" + currentFeatureDir);
                    } else {
                        URL featureURL = currentFeatureDir.toURL();
                        SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                        featureRef.setSiteModel(this.site);
                        featureRef.setURLString(featureURL.toExternalForm());
                        featureRef.setType("org.eclipse.update.core.installed");
                        this.site.addFeatureReferenceModel(featureRef);
                    }
                    ++index;
                }
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{newFilePath}), e);
            }
        }
    }

    private void parsePackagedFeature(File directory) throws CoreException {
        File featureDir = new File(directory, "features/");
        if (featureDir.exists()) {
            Object newFilePath = null;
            try {
                String[] dir = featureDir.list(FeaturePackagedContentProvider.filter);
                if (dir == null) {
                    throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(directory.getName()) + File.separator + directory.getName() + "directory is empty", null));
                }
                int index = 0;
                while (index < dir.length) {
                    File currentFeatureFile = new File(featureDir, dir[index]);
                    JarContentReference ref = new JarContentReference("", currentFeatureFile);
                    ContentReference result = null;
                    try {
                        result = ref.peek("feature.xml", null, null);
                    }
                    catch (IOException e) {
                        UpdateCore.warn("Exception retrieving feature.xml in file:" + currentFeatureFile, e);
                    }
                    if (result == null) {
                        UpdateCore.warn("Unable to find feature.xml in file:" + currentFeatureFile);
                    } else {
                        URL featureURL = currentFeatureFile.toURL();
                        SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                        featureRef.setSiteModel(this.site);
                        featureRef.setURLString(featureURL.toExternalForm());
                        featureRef.setType("org.eclipse.update.core.packaged");
                        this.site.addFeatureReferenceModel(featureRef);
                    }
                    ++index;
                }
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{newFilePath}), e);
            }
        }
    }

    private void parseInstalledPlugins(File pluginsDir) throws CoreException {
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            return;
        }
        File[] dirs = pluginsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        DefaultPluginParser parser = new DefaultPluginParser();
        if (dirs == null) {
            throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(pluginsDir.getName()) + File.separator + pluginsDir.getName() + "directory is empty", null));
        }
        int i = 0;
        while (i < dirs.length) {
            File pluginFile = new File(dirs[i], "META-INF/MANIFEST.MF");
            InputStream in = null;
            try {
                String pluginFileString;
                try {
                    PluginEntry entry;
                    BundleManifest bundleManifest = new BundleManifest(pluginFile);
                    if (bundleManifest.exists()) {
                        entry = bundleManifest.getPluginEntry();
                        this.addParsedPlugin(entry, dirs[i]);
                    } else {
                        pluginFile = new File(dirs[i], "plugin.xml");
                        if (!pluginFile.exists()) {
                            pluginFile = new File(dirs[i], "fragment.xml");
                        }
                        if (pluginFile != null && pluginFile.exists() && !pluginFile.isDirectory()) {
                            in = new FileInputStream(pluginFile);
                            entry = parser.parse(in);
                            this.addParsedPlugin(entry, dirs[i]);
                        }
                    }
                }
                catch (IOException e) {
                    pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
                    throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{pluginFileString}), e);
                }
                catch (SAXException e) {
                    pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
                    throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{pluginFileString}), e);
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
    }

    private void addParsedPlugin(PluginEntry entry, File file) throws CoreException {
        String location = null;
        try {
            if (entry != null) {
                ((Site)this.site).addPluginEntry(entry);
                ArchiveReferenceModel archive = this.createArchiveReferenceModel();
                String id = entry.getVersionedIdentifier().toString();
                String pluginID = "plugins/" + id + ".jar";
                archive.setPath(pluginID);
                location = file.toURL().toExternalForm();
                archive.setURLString(location);
                this.site.addArchiveReferenceModel(archive);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                    UpdateCore.debug("Added archive to site:" + pluginID + " pointing to: " + location);
                }
            }
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{location}), e);
        }
    }

    private void parsePackagedPlugins(File pluginDir) throws CoreException {
        if (!pluginDir.exists()) {
            return;
        }
        String[] dir = pluginDir.list(FeaturePackagedContentProvider.filter);
        if (dir == null) {
            throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(pluginDir.getName()) + File.separator + pluginDir.getName() + "directory is empty", null));
        }
        int i = 0;
        while (i < dir.length) {
            block35: {
                File file;
                JarContentReference jarReference;
                InputStream in;
                String refString;
                ContentReference ref;
                block32: {
                    block33: {
                        BundleManifest manifest;
                        ref = null;
                        refString = null;
                        in = null;
                        jarReference = null;
                        file = new File(pluginDir, dir[i]);
                        jarReference = new JarContentReference(null, file);
                        ref = jarReference.peek("META-INF/MANIFEST.MF", null, null);
                        if (ref == null || !(manifest = new BundleManifest(in = ref.getInputStream())).exists()) break block32;
                        this.addParsedPlugin(manifest.getPluginEntry(), file);
                        if (in == null) break block33;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (jarReference != null) {
                        try {
                            jarReference.closeArchive();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block35;
                }
                try {
                    try {
                        ref = jarReference.peek("plugin.xml", null, null);
                        if (ref == null) {
                            ref = jarReference.peek("fragment.xml", null, null);
                        }
                        if (ref != null) {
                            in = ref.getInputStream();
                            PluginEntry entry = new DefaultPluginParser().parse(in);
                            this.addParsedPlugin(entry, file);
                        }
                    }
                    catch (IOException e) {
                        try {
                            refString = ref == null ? null : ref.asURL().toExternalForm();
                        }
                        catch (IOException iOException) {}
                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{refString}), e);
                    }
                    catch (SAXException e) {
                        try {
                            refString = ref == null ? null : ref.asURL().toExternalForm();
                        }
                        catch (IOException iOException) {}
                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{refString}), e);
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (jarReference != null) {
                        try {
                            jarReference.closeArchive();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jarReference != null) {
                    try {
                        jarReference.closeArchive();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public SiteModel createSiteMapModel() {
        return new SiteFile();
    }

    @Override
    public boolean canParseSiteType(String type) {
        return super.canParseSiteType(type) || "org.eclipse.update.core.file".equalsIgnoreCase(type);
    }
}

