/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;

public class DetailObservableList
extends ObservableList
implements IObserving {
    private boolean updating = false;
    private IListChangeListener innerChangeListener = new IListChangeListener(){

        @Override
        public void handleListChange(ListChangeEvent event) {
            if (!DetailObservableList.this.updating) {
                DetailObservableList.this.fireListChange(event.diff);
            }
        }
    };
    private Object currentOuterValue;
    private IObservableList innerObservableList;
    private IObservableFactory factory;
    private IObservableValue outerObservableValue;
    private Object detailType;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        @Override
        public void handleValueChange(ValueChangeEvent event) {
            ArrayList oldList = new ArrayList(DetailObservableList.this.wrappedList);
            DetailObservableList.this.updateInnerObservableList(DetailObservableList.this.outerObservableValue);
            DetailObservableList.this.fireListChange(Diffs.computeListDiff(oldList, DetailObservableList.this.wrappedList));
        }
    };

    public DetailObservableList(IObservableFactory factory, IObservableValue outerObservableValue, Object detailType) {
        super(outerObservableValue.getRealm(), Collections.EMPTY_LIST, detailType);
        this.factory = factory;
        this.outerObservableValue = outerObservableValue;
        this.detailType = detailType;
        this.updateInnerObservableList(outerObservableValue);
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableList(IObservableValue outerObservableValue) {
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        this.currentOuterValue = outerObservableValue.getValue();
        if (this.currentOuterValue == null) {
            this.innerObservableList = null;
            this.wrappedList = Collections.EMPTY_LIST;
        } else {
            this.innerObservableList = (IObservableList)this.factory.createObservable(this.currentOuterValue);
            this.wrappedList = this.innerObservableList;
            if (this.detailType != null) {
                Object innerValueType = this.innerObservableList.getElementType();
                Assert.isTrue((boolean)this.getElementType().equals(innerValueType), (String)"Cannot change value type in a nested observable list");
            }
            this.innerObservableList.addListChangeListener(this.innerChangeListener);
        }
    }

    @Override
    public boolean add(Object o) {
        return this.wrappedList.add(o);
    }

    @Override
    public void add(int index, Object element) {
        this.wrappedList.add(index, element);
    }

    @Override
    public boolean remove(Object o) {
        return this.wrappedList.remove(o);
    }

    @Override
    public Object set(int index, Object element) {
        return this.wrappedList.set(index, element);
    }

    @Override
    public Object move(int oldIndex, int newIndex) {
        if (this.innerObservableList != null) {
            return this.innerObservableList.move(oldIndex, newIndex);
        }
        return super.move(oldIndex, newIndex);
    }

    @Override
    public Object remove(int index) {
        return this.wrappedList.remove(index);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.wrappedList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        return this.wrappedList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.wrappedList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.wrappedList.retainAll(c);
    }

    @Override
    public void clear() {
        this.wrappedList.clear();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
            this.outerObservableValue.dispose();
        }
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableList = null;
        this.innerChangeListener = null;
    }

    @Override
    public Object getObserved() {
        if (this.innerObservableList instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableList)).getObserved();
        }
        return null;
    }
}

