/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;

public class DetailObservableSet
extends ObservableSet
implements IObserving {
    private boolean updating = false;
    private ISetChangeListener innerChangeListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            if (!DetailObservableSet.this.updating) {
                DetailObservableSet.this.fireSetChange(event.diff);
            }
        }
    };
    private Object currentOuterValue;
    private IObservableSet innerObservableSet;
    private IObservableValue outerObservableValue;
    private IObservableFactory factory;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            HashSet oldSet = new HashSet(DetailObservableSet.this.wrappedSet);
            DetailObservableSet.this.updateInnerObservableSet(DetailObservableSet.this.outerObservableValue);
            DetailObservableSet.this.fireSetChange(Diffs.computeSetDiff(oldSet, DetailObservableSet.this.wrappedSet));
        }
    };

    public DetailObservableSet(IObservableFactory factory, IObservableValue outerObservableValue, Object detailType) {
        super(outerObservableValue.getRealm(), Collections.EMPTY_SET, detailType);
        this.factory = factory;
        this.outerObservableValue = outerObservableValue;
        this.updateInnerObservableSet(outerObservableValue);
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableSet(IObservableValue outerObservableValue) {
        this.currentOuterValue = outerObservableValue.getValue();
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableSet = null;
            this.wrappedSet = Collections.EMPTY_SET;
        } else {
            this.innerObservableSet = (IObservableSet)this.factory.createObservable(this.currentOuterValue);
            this.wrappedSet = this.innerObservableSet;
            if (this.elementType != null) {
                Object innerValueType = this.innerObservableSet.getElementType();
                Assert.isTrue((boolean)this.elementType.equals(innerValueType), (String)"Cannot change value type in a nested observable set");
            }
            this.innerObservableSet.addSetChangeListener(this.innerChangeListener);
        }
    }

    public boolean add(Object o) {
        this.getterCalled();
        return this.wrappedSet.add(o);
    }

    public boolean remove(Object o) {
        this.getterCalled();
        return this.wrappedSet.remove(o);
    }

    public boolean addAll(Collection c) {
        this.getterCalled();
        return this.wrappedSet.addAll(c);
    }

    public boolean removeAll(Collection c) {
        this.getterCalled();
        return this.wrappedSet.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.getterCalled();
        return this.wrappedSet.retainAll(c);
    }

    public void clear() {
        this.getterCalled();
        this.wrappedSet.clear();
    }

    public void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
            this.outerObservableValue.dispose();
        }
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableSet = null;
        this.innerChangeListener = null;
    }

    public Object getObserved() {
        if (this.innerObservableSet instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableSet)).getObserved();
        }
        return null;
    }
}

