/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.CCGUpdateType;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.BibTeX.BibTeXData;
import jp.sourceforge.concierge.plugin.ExportReferencePlugin;
import jp.sourceforge.concierge.plugin.ReferBibIX.ReferBibIXData;
import jp.sourceforge.concierge.plugin.ReferenceData;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatDomImpl;
import jp.sourceforge.concierge.util.DataDomTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportReference
extends ConciergeViewPart {
    private Shell shell = null;
    private IMemento memento = null;
    private final String[] BibTeX_TableHead = new String[]{"CitationKey", "Content"};
    private final String[] tableHead = new String[]{"Content"};
    private final String BIBTEX_TABLE_COLUMN_WIDTH_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_EXPORTITEM_TABLE_COLUMN_WIDTH_";
    private final String BIBTEX_TABLE_COLUMN_ORDER_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_EXPORTITEM_TABLE_COLUMN_ORDER_";
    private final String REFERBIBIX_TABLE_COLUMN_WIDTH_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_EXPORTITEM_TABLE_COLUMN_WIDTH_";
    private final String REFERBIBIX_TABLE_COLUMN_ORDER_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_EXPORTITEM_TABLE_COLUMN_ORDER_";
    private final String CUSTOMIZE_TABLE_COLUMN_WIDTH_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_EXPORTITEM_TABLE_COLUMN_WIDTH_";
    private final String CUSTOMIZE_TABLE_COLUMN_ORDER_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_EXPORTITEM_TABLE_COLUMN_ORDER_";
    private final String BIBTEX_SASH_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_SASH_";
    private final String REFERBIBIX_SASH_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_SASH_";
    private final String CUSTOMIZE_SASH_ = "JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_SASH_";
    private StyledText bibtexStyledText = null;
    private StyledText referbibixStyledText = null;
    private StyledText customizeReferenceFormatStyledText = null;
    private CTabFolder tabFolder = null;
    private TableViewer bibtexItemTableView = null;
    private TableViewer referbibixItemTableView = null;
    private TableViewer customizeItemTableView = null;
    private SashForm bibtexSashForm = null;
    private SashForm referbibixSashForm = null;
    private SashForm customizeSashForm = null;
    private Action exportFileAction;
    private Action makeStringAction;
    private Action deleteDataDocAction;
    private Action selectAllDataDocAction;
    private Action cutEditorAction;
    private Action copyEditorAction;
    private Action selectAllEditorAction;
    private Action openPreferenceAction;
    private Action horizontalLayoutAction;
    private Action verticalLayoutAction;
    private FontRegistry fontReg = new FontRegistry();

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (memento != null) {
            TableColumn[] columns = this.bibtexItemTableView.getTable().getColumns();
            int i = 0;
            while (i < columns.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_EXPORTITEM_TABLE_COLUMN_WIDTH_" + this.BibTeX_TableHead[i], columns[i].getWidth());
                ++i;
            }
            int[] order = this.bibtexItemTableView.getTable().getColumnOrder();
            int i2 = 0;
            while (i2 < order.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_EXPORTITEM_TABLE_COLUMN_ORDER_" + this.BibTeX_TableHead[order[i2]], i2);
                ++i2;
            }
            memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_SASH_ORIENTATION", this.bibtexSashForm.getOrientation());
            int[] weights = this.bibtexSashForm.getWeights();
            int i3 = 0;
            while (i3 < weights.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_SASH_WEIGHTS_" + i3, weights[i3]);
                ++i3;
            }
            columns = this.referbibixItemTableView.getTable().getColumns();
            i = 0;
            while (i < columns.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_EXPORTITEM_TABLE_COLUMN_WIDTH_" + this.tableHead[i], columns[i].getWidth());
                ++i;
            }
            order = this.referbibixItemTableView.getTable().getColumnOrder();
            i = 0;
            while (i < order.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_EXPORTITEM_TABLE_COLUMN_ORDER_" + this.tableHead[order[i]], i);
                ++i;
            }
            memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_SASH_ORIENTATION", this.referbibixSashForm.getOrientation());
            weights = this.referbibixSashForm.getWeights();
            i3 = 0;
            while (i3 < weights.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_SASH_WEIGHTS_" + i3, weights[i3]);
                ++i3;
            }
            columns = this.customizeItemTableView.getTable().getColumns();
            i = 0;
            while (i < columns.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_EXPORTITEM_TABLE_COLUMN_WIDTH_" + this.tableHead[i], columns[i].getWidth());
                ++i;
            }
            order = this.customizeItemTableView.getTable().getColumnOrder();
            i = 0;
            while (i < order.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_EXPORTITEM_TABLE_COLUMN_ORDER_" + this.tableHead[order[i]], i);
                ++i;
            }
            memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_SASH_ORIENTATION", this.customizeSashForm.getOrientation());
            weights = this.customizeSashForm.getWeights();
            i3 = 0;
            while (i3 < weights.length) {
                memento.putInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_SASH_WEIGHTS_" + i3, weights[i3]);
                ++i3;
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        this.tabFolder = new CTabFolder(parent, 128);
        this.tabFolder.setLayout((Layout)new FillLayout(512));
        this.createBibTexControl(this.tabFolder);
        this.createReferBibIXControl(this.tabFolder);
        this.createCustomizeRefernceFormatControl(this.tabFolder);
        this.tabFolder.setSelection(0);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread(this.bibtexItemTableView.getControl(), new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                block7: {
                    ArrayList al;
                    block8: {
                        if (!ev.collection.equals("data")) {
                            return;
                        }
                        if (ExportReference.this.tabFolder.getSelectionIndex() != 0 || (al = (ArrayList)ExportReference.this.bibtexItemTableView.getInput()) == null || al.size() <= 0) break block7;
                        if (ev.type != CCGUpdateType.DEL_DOCUMENT) break block8;
                        int i = 0;
                        while (i < ev.documents.size()) {
                            int j = 0;
                            while (j < al.size()) {
                                if (((BibTeXData)al.get(j)).getDataDoc().equals(ev.documents.get(i))) {
                                    al.remove(j);
                                    ExportReference.this.bibtexItemTableView.getTable().deselectAll();
                                    ExportReference.this.bibtexStyledText.setText("");
                                    ExportReference.this.bibtexItemTableView.refresh();
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        break block7;
                    }
                    if (ev.type != CCGUpdateType.UPD_DOCUMENT) break block7;
                    int i = 0;
                    while (i < ev.documents.size()) {
                        int j = 0;
                        while (j < al.size()) {
                            if (((BibTeXData)al.get(j)).getDataDoc().equals(ev.documents.get(i))) {
                                ((BibTeXData)al.get(j)).createContent();
                                ExportReference.this.bibtexItemTableView.getTable().deselectAll();
                                ExportReference.this.bibtexStyledText.setText("");
                                ExportReference.this.bibtexItemTableView.refresh();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }));
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread(this.referbibixItemTableView.getControl(), new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                block7: {
                    ArrayList al;
                    block8: {
                        if (!ev.collection.equals("data")) {
                            return;
                        }
                        if (ExportReference.this.tabFolder.getSelectionIndex() != 1 || (al = (ArrayList)ExportReference.this.referbibixItemTableView.getInput()) == null || al.size() <= 0) break block7;
                        if (ev.type != CCGUpdateType.DEL_DOCUMENT) break block8;
                        int i = 0;
                        while (i < ev.documents.size()) {
                            int j = 0;
                            while (j < al.size()) {
                                if (((ReferBibIXData)al.get(j)).getDataDoc().equals(ev.documents.get(i))) {
                                    al.remove(j);
                                    ExportReference.this.referbibixItemTableView.getTable().deselectAll();
                                    ExportReference.this.referbibixStyledText.setText("");
                                    ExportReference.this.referbibixItemTableView.refresh();
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        break block7;
                    }
                    if (ev.type != CCGUpdateType.UPD_DOCUMENT) break block7;
                    int i = 0;
                    while (i < ev.documents.size()) {
                        int j = 0;
                        while (j < al.size()) {
                            if (((ReferBibIXData)al.get(j)).getDataDoc().equals(ev.documents.get(i))) {
                                ((ReferBibIXData)al.get(j)).createContent();
                                ExportReference.this.referbibixItemTableView.getTable().deselectAll();
                                ExportReference.this.referbibixStyledText.setText("");
                                ExportReference.this.referbibixItemTableView.refresh();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }));
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread(this.customizeItemTableView.getControl(), new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                block5: {
                    ArrayList al;
                    block6: {
                        if (!ev.collection.equals("data")) {
                            return;
                        }
                        if (ExportReference.this.tabFolder.getSelectionIndex() != 2 || (al = (ArrayList)ExportReference.this.customizeItemTableView.getInput()) == null || al.size() <= 0) break block5;
                        if (ev.type != CCGUpdateType.DEL_DOCUMENT) break block6;
                        int i = 0;
                        while (i < ev.documents.size()) {
                            if (al.remove(ev.documents.get(i))) {
                                ExportReference.this.customizeItemTableView.refresh();
                            }
                            ++i;
                        }
                        break block5;
                    }
                    if (ev.type != CCGUpdateType.UPD_DOCUMENT) break block5;
                    int i = 0;
                    while (i < ev.documents.size()) {
                        if (al.indexOf(ev.documents.get(i)) != -1) {
                            ExportReference.this.customizeItemTableView.refresh();
                        }
                        ++i;
                    }
                }
            }
        }));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExportReference.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.bibtexItemTableView.getControl());
        this.bibtexItemTableView.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.bibtexItemTableView);
        menu = menuMgr.createContextMenu(this.referbibixItemTableView.getControl());
        this.referbibixItemTableView.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.referbibixItemTableView);
        menu = menuMgr.createContextMenu(this.customizeItemTableView.getControl());
        this.customizeItemTableView.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.customizeItemTableView);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.makeStringAction);
        manager.add((IAction)this.exportFileAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteDataDocAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.makeStringAction);
        manager.add((IAction)this.exportFileAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteDataDocAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.horizontalLayoutAction);
        manager.add((IAction)this.verticalLayoutAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openPreferenceAction);
    }

    private void makeActions() {
        this.exportFileAction = new Action(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    String str = ExportReference.this.bibtexStyledText.getText();
                    if (str.length() == 0) {
                        ExportReference.this.makeStringAction.run();
                    }
                    if (str.length() <= 0) return;
                    FileDialog dialog = new FileDialog(ExportReference.this.shell, 8192);
                    dialog.setFilterNames(new String[]{"BibTeX Files", "All Files (*.*)"});
                    dialog.setFilterExtensions(new String[]{"*.bib", "."});
                    Date dNow = new Date();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    dialog.setFileName(String.valueOf(dateFormat.format(dNow)) + ".bib");
                    dialog.setText("Export BibTeX File");
                    String resultPath = dialog.open();
                    if (resultPath == null || resultPath.length() <= 0) return;
                    FileWriter fw = null;
                    try {
                        try {
                            fw = new FileWriter(resultPath);
                            fw.write(str);
                            return;
                        }
                        catch (IOException excp) {
                            System.err.println(excp.getMessage());
                            try {
                                if (fw == null) return;
                                fw.close();
                                return;
                            }
                            catch (IOException excp2) {
                                System.err.println(excp2.getMessage());
                            }
                        }
                        return;
                    }
                    finally {
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                        }
                        catch (IOException excp) {
                            System.err.println(excp.getMessage());
                        }
                    }
                }
                if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    String str = ExportReference.this.referbibixStyledText.getText();
                    if (str.length() == 0) {
                        ExportReference.this.makeStringAction.run();
                    }
                    if (str.length() <= 0) return;
                    FileDialog dialog = new FileDialog(ExportReference.this.shell, 8192);
                    dialog.setFilterNames(new String[]{"Refer/BibIX Files", "All Files (*.*)"});
                    dialog.setFilterExtensions(new String[]{"*.txt", "."});
                    Date dNow = new Date();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    dialog.setFileName(String.valueOf(dateFormat.format(dNow)) + ".bib");
                    dialog.setText("Export Refer/BibIX File");
                    String resultPath = dialog.open();
                    if (resultPath == null || resultPath.length() <= 0) return;
                    FileWriter fw = null;
                    try {
                        try {
                            fw = new FileWriter(resultPath);
                            fw.write(str);
                            return;
                        }
                        catch (IOException excp) {
                            System.err.println(excp.getMessage());
                            try {
                                if (fw == null) return;
                                fw.close();
                                return;
                            }
                            catch (IOException excp3) {
                                System.err.println(excp3.getMessage());
                            }
                        }
                        return;
                    }
                    finally {
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                        }
                        catch (IOException excp) {
                            System.err.println(excp.getMessage());
                        }
                    }
                }
                if (ExportReference.this.tabFolder.getSelectionIndex() != 2) return;
                String str = ExportReference.this.customizeReferenceFormatStyledText.getText();
                if (str.length() == 0) {
                    ExportReference.this.makeStringAction.run();
                }
                if (str.length() <= 0) return;
                FileDialog dialog = new FileDialog(ExportReference.this.shell, 8192);
                dialog.setFilterNames(new String[]{"Refer/BibIX Files", "All Files (*.*)"});
                dialog.setFilterExtensions(new String[]{"*.txt", "."});
                Date dNow = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                dialog.setFileName(String.valueOf(dateFormat.format(dNow)) + ".bib");
                dialog.setText("Export Customize Reference File");
                String resultPath = dialog.open();
                if (resultPath == null || resultPath.length() <= 0) return;
                FileWriter fw = null;
                try {
                    try {
                        fw = new FileWriter(resultPath);
                        fw.write(str);
                        return;
                    }
                    catch (IOException excp) {
                        System.err.println(excp.getMessage());
                        try {
                            if (fw == null) return;
                            fw.close();
                            return;
                        }
                        catch (IOException excp4) {
                            System.err.println(excp4.getMessage());
                        }
                    }
                    return;
                }
                finally {
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (IOException excp) {
                        System.err.println(excp.getMessage());
                    }
                }
            }
        };
        this.exportFileAction.setText("Export File");
        this.exportFileAction.setToolTipText("Export File");
        this.exportFileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.makeStringAction = new Action(){

            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ExportReference.this.bibtexStyledText.setText("");
                    IStructuredSelection selection = (IStructuredSelection)ExportReference.this.bibtexItemTableView.getSelection();
                    if (selection != null) {
                        if (selection.isEmpty()) {
                            ArrayList al = (ArrayList)ExportReference.this.bibtexItemTableView.getInput();
                            int i = 0;
                            while (i < al.size()) {
                                BibTeXData bibtexData = (BibTeXData)al.get(i);
                                bibtexData.createContent();
                                ExportReference.this.bibtexStyledText.append(bibtexData.getContent());
                                ++i;
                            }
                        } else {
                            for (BibTeXData bibtexData : selection) {
                                bibtexData.createContent();
                                ExportReference.this.bibtexStyledText.append(bibtexData.getContent());
                            }
                        }
                    }
                    ExportReference.this.bibtexItemTableView.refresh();
                    ExportReference.this.bibtexStyledText.redraw();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ExportReference.this.referbibixStyledText.setText("");
                    IStructuredSelection selection = (IStructuredSelection)ExportReference.this.referbibixItemTableView.getSelection();
                    if (selection != null) {
                        if (selection.isEmpty()) {
                            ArrayList al = (ArrayList)ExportReference.this.referbibixItemTableView.getInput();
                            int i = 0;
                            while (i < al.size()) {
                                ReferBibIXData referbibixData = (ReferBibIXData)al.get(i);
                                referbibixData.createContent();
                                ExportReference.this.referbibixStyledText.append(referbibixData.getContent());
                                ++i;
                            }
                        } else {
                            for (ReferBibIXData referbibixData : selection) {
                                referbibixData.createContent();
                                ExportReference.this.referbibixStyledText.append(referbibixData.getContent());
                            }
                        }
                    }
                    ExportReference.this.referbibixStyledText.redraw();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeReferenceFormatStyledText.setText("");
                    IStructuredSelection selection = (IStructuredSelection)ExportReference.this.customizeItemTableView.getSelection();
                    if (selection != null) {
                        if (selection.isEmpty()) {
                            ArrayList al = (ArrayList)ExportReference.this.customizeItemTableView.getInput();
                            int i = 0;
                            while (i < al.size()) {
                                Document datadoc = (Document)al.get(i);
                                ReferenceDataFormatDomImpl.setStyledText(datadoc, null, ExportReference.this.customizeReferenceFormatStyledText, ExportReference.this.fontReg);
                                ExportReference.this.customizeReferenceFormatStyledText.append("\n");
                                ++i;
                            }
                        } else {
                            for (Document datadoc : selection) {
                                ReferenceDataFormatDomImpl.setStyledText(datadoc, null, ExportReference.this.customizeReferenceFormatStyledText, ExportReference.this.fontReg);
                                ExportReference.this.customizeReferenceFormatStyledText.append("\n");
                            }
                        }
                    }
                    ExportReference.this.customizeReferenceFormatStyledText.redraw();
                }
            }
        };
        this.makeStringAction.setText("Make String");
        this.makeStringAction.setToolTipText("Make String");
        this.makeStringAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
        this.deleteDataDocAction = new Action(){

            public void run() {
                IStructuredSelection selection;
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    IStructuredSelection selection2 = (IStructuredSelection)ExportReference.this.bibtexItemTableView.getSelection();
                    if (selection2 != null) {
                        ArrayList al = (ArrayList)ExportReference.this.bibtexItemTableView.getInput();
                        for (BibTeXData bibtexData : selection2) {
                            al.remove(bibtexData);
                        }
                        ExportReference.this.bibtexItemTableView.getTable().deselectAll();
                        ExportReference.this.bibtexStyledText.setText("");
                        ExportReference.this.bibtexItemTableView.refresh();
                    }
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    IStructuredSelection selection3 = (IStructuredSelection)ExportReference.this.referbibixItemTableView.getSelection();
                    if (selection3 != null) {
                        ArrayList al = (ArrayList)ExportReference.this.referbibixItemTableView.getInput();
                        for (ReferBibIXData data : selection3) {
                            al.remove(data);
                        }
                        ExportReference.this.referbibixItemTableView.getTable().deselectAll();
                        ExportReference.this.referbibixStyledText.setText("");
                        ExportReference.this.referbibixItemTableView.refresh();
                    }
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2 && (selection = (IStructuredSelection)ExportReference.this.customizeItemTableView.getSelection()) != null) {
                    ArrayList al = (ArrayList)ExportReference.this.customizeItemTableView.getInput();
                    for (Document doc : selection) {
                        al.remove(doc);
                    }
                    ExportReference.this.customizeItemTableView.refresh();
                }
            }
        };
        this.deleteDataDocAction.setText("Delete Item");
        this.deleteDataDocAction.setToolTipText("Delete Item");
        this.deleteDataDocAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteDataDocAction.setEnabled(false);
        this.selectAllDataDocAction = new Action(){

            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ExportReference.this.bibtexItemTableView.getTable().selectAll();
                    ExportReference.this.bibtexItemTableView.getTable().notifyListeners(13, null);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ExportReference.this.referbibixItemTableView.getTable().selectAll();
                    ExportReference.this.referbibixItemTableView.getTable().notifyListeners(13, null);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeItemTableView.getTable().selectAll();
                    ExportReference.this.customizeItemTableView.getTable().notifyListeners(13, null);
                }
            }
        };
        this.selectAllDataDocAction.setText("Select All");
        this.selectAllDataDocAction.setToolTipText("Select All");
        this.cutEditorAction = new Action(){

            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ExportReference.this.bibtexStyledText.cut();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ExportReference.this.referbibixStyledText.cut();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeReferenceFormatStyledText.cut();
                }
            }
        };
        this.cutEditorAction.setText("Cut");
        this.cutEditorAction.setToolTipText("Cut");
        this.cutEditorAction.setEnabled(false);
        this.copyEditorAction = new Action(){

            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ExportReference.this.bibtexStyledText.copy();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ExportReference.this.referbibixStyledText.copy();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeReferenceFormatStyledText.copy();
                }
            }
        };
        this.copyEditorAction.setText("Copy");
        this.copyEditorAction.setToolTipText("Copy");
        this.copyEditorAction.setEnabled(false);
        this.selectAllEditorAction = new Action(){

            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ExportReference.this.bibtexStyledText.selectAll();
                    ExportReference.this.bibtexStyledText.notifyListeners(13, null);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ExportReference.this.referbibixStyledText.selectAll();
                    ExportReference.this.referbibixStyledText.notifyListeners(13, null);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeReferenceFormatStyledText.selectAll();
                    ExportReference.this.customizeReferenceFormatStyledText.notifyListeners(13, null);
                }
            }
        };
        this.selectAllEditorAction.setText("Select All");
        this.selectAllEditorAction.setToolTipText("Select All");
        this.openPreferenceAction = new Action(){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"jp.sourceforge.concierge.plugin.exportreference.preferences.ExportReferencePreferencePage", null, null);
                dialog.open();
            }
        };
        this.openPreferenceAction.setText("Preference");
        this.openPreferenceAction.setToolTipText("Open Preference");
        this.openPreferenceAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.horizontalLayoutAction = new Action(){

            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ExportReference.this.bibtexSashForm.setOrientation(256);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ExportReference.this.referbibixSashForm.setOrientation(256);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeSashForm.setOrientation(256);
                }
            }
        };
        this.horizontalLayoutAction.setText("Horizontal Layout");
        this.horizontalLayoutAction.setToolTipText("Horizontal Layout");
        this.horizontalLayoutAction.setImageDescriptor(ExportReferencePlugin.getImageDescriptor("icons/th_horizontal.gif"));
        this.verticalLayoutAction = new Action(){

            public void run() {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ExportReference.this.bibtexSashForm.setOrientation(512);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ExportReference.this.referbibixSashForm.setOrientation(512);
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeSashForm.setOrientation(512);
                }
            }
        };
        this.verticalLayoutAction.setText("Vertical Layout");
        this.verticalLayoutAction.setToolTipText("Vertical Layout");
        this.verticalLayoutAction.setImageDescriptor(ExportReferencePlugin.getImageDescriptor("icons/th_vertical.gif"));
    }

    public void setFocus() {
        if (this.tabFolder.getSelectionIndex() == 0) {
            this.bibtexItemTableView.getControl().setFocus();
        } else if (this.tabFolder.getSelectionIndex() == 1) {
            this.referbibixItemTableView.getControl().setFocus();
        } else if (this.tabFolder.getSelectionIndex() == 2) {
            this.customizeItemTableView.getControl().setFocus();
        }
    }

    private Document getDataDocument(String filepath) {
        Request req = new Request(4, (Object)("/mdata[@filepath='" + filepath + "']"), "data");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs != null && docs.size() > 0) {
            return (Document)docs.get(0);
        }
        return null;
    }

    private void createBibTexControl(CTabFolder parent) {
        CTabItem tabItem = new CTabItem(parent, 0);
        tabItem.setText("BibTeX");
        this.bibtexSashForm = new SashForm((Composite)parent, 512);
        this.bibtexSashForm.setLayout((Layout)new FillLayout());
        this.bibtexItemTableView = new TableViewer((Composite)this.bibtexSashForm, 66306);
        this.bibtexItemTableView.setContentProvider((IContentProvider)new ViewContentProvider());
        this.bibtexItemTableView.setLabelProvider((IBaseLabelProvider)new ItemTableViewLabelProvider());
        this.bibtexItemTableView.getTable().setLinesVisible(true);
        this.bibtexItemTableView.getTable().setHeaderVisible(true);
        int[] orders = new int[this.BibTeX_TableHead.length];
        boolean isOrders = true;
        int i = 0;
        while (i < this.BibTeX_TableHead.length) {
            TableColumn tc = new TableColumn(this.bibtexItemTableView.getTable(), 16384, i);
            Integer widthInt = null;
            if (this.memento != null) {
                widthInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_EXPORTITEM_TABLE_COLUMN_WIDTH_" + this.BibTeX_TableHead[i]);
            }
            if (widthInt == null) {
                tc.setWidth(150);
            } else {
                tc.setWidth(widthInt.intValue());
            }
            Integer orderInt = null;
            if (this.memento != null) {
                orderInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_EXPORTITEM_TABLE_COLUMN_ORDER_" + this.BibTeX_TableHead[i]);
            }
            if (orderInt == null) {
                isOrders = false;
            } else {
                orders[i] = orderInt;
            }
            tc.setText(this.BibTeX_TableHead[i]);
            tc.setMoveable(true);
            tc.setResizable(true);
            tc.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    int colNum = ExportReference.this.bibtexItemTableView.getTable().indexOf(column);
                    int direction = ExportReference.this.bibtexItemTableView.getTable().getSortDirection();
                    direction = direction == 128 ? 1024 : 128;
                    BibTeXNameSorter newSorter = new BibTeXNameSorter();
                    BibTeXNameSorter nowSorter = (BibTeXNameSorter)ExportReference.this.bibtexItemTableView.getSorter();
                    if (nowSorter != null) {
                        newSorter.setSortDirection(direction);
                    }
                    newSorter.setColumnIndex(colNum);
                    ExportReference.this.bibtexItemTableView.setSorter((ViewerSorter)newSorter);
                    ExportReference.this.bibtexItemTableView.getTable().setSortColumn(column);
                    ExportReference.this.bibtexItemTableView.getTable().setSortDirection(direction);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        if (isOrders) {
            this.bibtexItemTableView.getTable().setColumnOrder(orders);
        }
        this.bibtexItemTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                ExportReference.this.deleteDataDocAction.setEnabled(!selection.isEmpty());
                if (!selection.isEmpty()) {
                    ExportReference.this.bibtexStyledText.setText("");
                    for (BibTeXData bibtexData : selection) {
                        ExportReference.this.bibtexStyledText.append(bibtexData.getContent());
                    }
                }
            }
        });
        this.bibtexItemTableView.addDropSupport(19, new Transfer[]{FileTransfer.getInstance(), DataDomTransfer.getInstance()}, (DropTargetListener)new ItemTableDropListener());
        this.bibtexItemTableView.addDragSupport(3, new Transfer[]{RTFTransfer.getInstance(), TextTransfer.getInstance()}, (DragSourceListener)new BibTeXDragTableAdapter());
        this.bibtexItemTableView.setInput(new ArrayList());
        this.bibtexItemTableView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length == 2) {
                    col[1].setWidth(r.width - col[0].getWidth());
                }
            }
        });
        this.bibtexItemTableView.getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)ExportReference.this.deleteDataDocAction);
                bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)ExportReference.this.selectAllDataDocAction);
                bars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        this.bibtexStyledText = new StyledText((Composite)this.bibtexSashForm, 2880);
        DropTarget dropTarget = new DropTarget((Control)this.bibtexStyledText, 19);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance(), DataDomTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new ItemTableDropListener());
        this.bibtexStyledText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StyledText st = (StyledText)e.getSource();
                ExportReference.this.cutEditorAction.setEnabled(st.getSelectionCount() > 0);
                ExportReference.this.copyEditorAction.setEnabled(st.getSelectionCount() > 0);
            }
        });
        this.bibtexStyledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)ExportReference.this.cutEditorAction);
                bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)ExportReference.this.copyEditorAction);
                bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)ExportReference.this.selectAllEditorAction);
                bars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        Integer orientationInt = null;
        if (this.memento != null) {
            orientationInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_SASH_ORIENTATION");
        }
        if (orientationInt != null) {
            this.bibtexSashForm.setOrientation(orientationInt.intValue());
        }
        int weights0 = 40;
        int weights1 = 60;
        if (this.memento != null) {
            Integer weightInt = null;
            weightInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_SASH_WEIGHTS_0");
            if (weightInt != null) {
                weights0 = weightInt;
            }
            if ((weightInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_BIBTEX_SASH_WEIGHTS_1")) != null) {
                weights1 = weightInt;
            }
        }
        this.bibtexSashForm.setWeights(new int[]{weights0, weights1});
        tabItem.setControl((Control)this.bibtexSashForm);
    }

    private void createReferBibIXControl(CTabFolder parent) {
        CTabItem tabItem = new CTabItem(parent, 0);
        tabItem.setText("Refer/BibIX");
        this.referbibixSashForm = new SashForm((Composite)parent, 512);
        this.referbibixSashForm.setLayout((Layout)new FillLayout());
        this.referbibixItemTableView = new TableViewer((Composite)this.referbibixSashForm, 66306);
        this.referbibixItemTableView.setContentProvider((IContentProvider)new ViewContentProvider());
        this.referbibixItemTableView.setLabelProvider((IBaseLabelProvider)new ItemTableViewLabelProvider());
        this.referbibixItemTableView.getTable().setLinesVisible(true);
        this.referbibixItemTableView.getTable().setHeaderVisible(true);
        int[] orders = new int[this.tableHead.length];
        boolean isOrders = true;
        int i = 0;
        while (i < this.tableHead.length) {
            TableColumn tc = new TableColumn(this.referbibixItemTableView.getTable(), 16384, i);
            Integer widthInt = null;
            if (this.memento != null) {
                widthInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_EXPORTITEM_TABLE_COLUMN_WIDTH_" + this.tableHead[i]);
            }
            if (widthInt == null) {
                tc.setWidth(150);
            } else {
                tc.setWidth(widthInt.intValue());
            }
            Integer orderInt = null;
            if (this.memento != null) {
                orderInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_EXPORTITEM_TABLE_COLUMN_ORDER_" + this.tableHead[i]);
            }
            if (orderInt == null) {
                isOrders = false;
            } else {
                orders[i] = orderInt;
            }
            tc.setText(this.tableHead[i]);
            tc.setMoveable(true);
            tc.setResizable(true);
            tc.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    int colNum = ExportReference.this.referbibixItemTableView.getTable().indexOf(column);
                    int direction = ExportReference.this.referbibixItemTableView.getTable().getSortDirection();
                    direction = direction == 128 ? 1024 : 128;
                    NameSorter newSorter = new NameSorter();
                    NameSorter nowSorter = (NameSorter)ExportReference.this.referbibixItemTableView.getSorter();
                    if (nowSorter != null) {
                        newSorter.setSortDirection(direction);
                    }
                    newSorter.setColumnIndex(colNum);
                    ExportReference.this.referbibixItemTableView.setSorter((ViewerSorter)newSorter);
                    ExportReference.this.referbibixItemTableView.getTable().setSortColumn(column);
                    ExportReference.this.referbibixItemTableView.getTable().setSortDirection(direction);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        if (isOrders) {
            this.referbibixItemTableView.getTable().setColumnOrder(orders);
        }
        this.referbibixItemTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                ExportReference.this.deleteDataDocAction.setEnabled(!selection.isEmpty());
                if (!selection.isEmpty()) {
                    ExportReference.this.referbibixStyledText.setText("");
                    for (ReferBibIXData data : selection) {
                        ExportReference.this.referbibixStyledText.append(data.getContent());
                        ExportReference.this.referbibixStyledText.append("\n");
                    }
                }
            }
        });
        this.referbibixItemTableView.addDropSupport(19, new Transfer[]{FileTransfer.getInstance(), DataDomTransfer.getInstance()}, (DropTargetListener)new ItemTableDropListener());
        this.referbibixItemTableView.setInput(new ArrayList());
        this.referbibixItemTableView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length == 1) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.referbibixItemTableView.getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)ExportReference.this.deleteDataDocAction);
                bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)ExportReference.this.selectAllDataDocAction);
                bars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        this.referbibixStyledText = new StyledText((Composite)this.referbibixSashForm, 2880);
        DropTarget dropTarget = new DropTarget((Control)this.referbibixStyledText, 19);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance(), DataDomTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new ItemTableDropListener());
        this.referbibixStyledText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StyledText st = (StyledText)e.getSource();
                ExportReference.this.cutEditorAction.setEnabled(st.getSelectionCount() > 0);
                ExportReference.this.copyEditorAction.setEnabled(st.getSelectionCount() > 0);
            }
        });
        this.referbibixStyledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)ExportReference.this.cutEditorAction);
                bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)ExportReference.this.copyEditorAction);
                bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)ExportReference.this.selectAllEditorAction);
                bars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        Integer orientationInt = null;
        if (this.memento != null) {
            orientationInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_SASH_ORIENTATION");
        }
        if (orientationInt != null) {
            this.referbibixSashForm.setOrientation(orientationInt.intValue());
        }
        int weights0 = 40;
        int weights1 = 60;
        if (this.memento != null) {
            Integer weightInt = null;
            weightInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_SASH_WEIGHTS_0");
            if (weightInt != null) {
                weights0 = weightInt;
            }
            if ((weightInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_REFERBIBIX_SASH_WEIGHTS_1")) != null) {
                weights1 = weightInt;
            }
        }
        this.referbibixSashForm.setWeights(new int[]{weights0, weights1});
        tabItem.setControl((Control)this.referbibixSashForm);
    }

    private void createCustomizeRefernceFormatControl(CTabFolder parent) {
        Integer orientationInt;
        CTabItem tabItem = new CTabItem(parent, 0);
        tabItem.setText("Customize Refernce Format");
        this.customizeSashForm = new SashForm((Composite)parent, 512);
        this.customizeSashForm.setLayout((Layout)new FillLayout());
        this.customizeItemTableView = new TableViewer((Composite)this.customizeSashForm, 66306);
        this.customizeItemTableView.setContentProvider((IContentProvider)new ViewContentProvider());
        this.customizeItemTableView.setLabelProvider((IBaseLabelProvider)new ItemTableViewLabelProvider());
        this.customizeItemTableView.getTable().setLinesVisible(true);
        this.customizeItemTableView.getTable().setHeaderVisible(true);
        int[] orders = new int[this.tableHead.length];
        boolean isOrders = true;
        int i = 0;
        while (i < this.tableHead.length) {
            TableColumn tc = new TableColumn(this.customizeItemTableView.getTable(), 16384, i);
            Integer widthInt = null;
            if (this.memento != null) {
                widthInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_EXPORTITEM_TABLE_COLUMN_WIDTH_" + this.tableHead[i]);
            }
            if (widthInt == null) {
                tc.setWidth(150);
            } else {
                tc.setWidth(widthInt.intValue());
            }
            Integer orderInt = null;
            if (this.memento != null) {
                orderInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_EXPORTITEM_TABLE_COLUMN_ORDER_" + this.tableHead[i]);
            }
            if (orderInt == null) {
                isOrders = false;
            } else {
                orders[i] = orderInt;
            }
            tc.setText(this.tableHead[i]);
            tc.setMoveable(true);
            tc.setResizable(true);
            tc.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    int colNum = ExportReference.this.customizeItemTableView.getTable().indexOf(column);
                    int direction = ExportReference.this.customizeItemTableView.getTable().getSortDirection();
                    direction = direction == 128 ? 1024 : 128;
                    NameSorter newSorter = new NameSorter();
                    NameSorter nowSorter = (NameSorter)ExportReference.this.customizeItemTableView.getSorter();
                    if (nowSorter != null) {
                        newSorter.setSortDirection(direction);
                    }
                    newSorter.setColumnIndex(colNum);
                    ExportReference.this.customizeItemTableView.setSorter((ViewerSorter)newSorter);
                    ExportReference.this.customizeItemTableView.getTable().setSortColumn(column);
                    ExportReference.this.customizeItemTableView.getTable().setSortDirection(direction);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        if (isOrders) {
            this.customizeItemTableView.getTable().setColumnOrder(orders);
        }
        this.customizeItemTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                ExportReference.this.deleteDataDocAction.setEnabled(!selection.isEmpty());
            }
        });
        this.customizeItemTableView.addDropSupport(19, new Transfer[]{FileTransfer.getInstance(), DataDomTransfer.getInstance()}, (DropTargetListener)new ItemTableDropListener());
        this.customizeItemTableView.setInput(new ArrayList());
        this.customizeItemTableView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length == 1) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.customizeItemTableView.getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)ExportReference.this.deleteDataDocAction);
                bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)ExportReference.this.selectAllDataDocAction);
                bars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        this.customizeReferenceFormatStyledText = new StyledText((Composite)this.customizeSashForm, 2880);
        DropTarget dropTarget = new DropTarget((Control)this.customizeReferenceFormatStyledText, 19);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance(), DataDomTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new ItemTableDropListener());
        this.customizeReferenceFormatStyledText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StyledText st = (StyledText)e.getSource();
                ExportReference.this.cutEditorAction.setEnabled(st.getSelectionCount() > 0);
                ExportReference.this.copyEditorAction.setEnabled(st.getSelectionCount() > 0);
            }
        });
        this.customizeReferenceFormatStyledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)ExportReference.this.cutEditorAction);
                bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)ExportReference.this.copyEditorAction);
                bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)ExportReference.this.selectAllEditorAction);
                bars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                IActionBars bars = ExportReference.this.getViewSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        if (this.memento != null && (orientationInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_SASH_ORIENTATION")) != null) {
            this.customizeSashForm.setOrientation(orientationInt.intValue());
        }
        int weights0 = 40;
        int weights1 = 60;
        if (this.memento != null) {
            Integer weightInt = null;
            weightInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_SASH_WEIGHTS_0");
            if (weightInt != null) {
                weights0 = weightInt;
            }
            if ((weightInt = this.memento.getInteger("JP_SOURCEFORGE_CONCIERGE_PLUGIN_EXPORTREFERENCE_CUSTOMIZE_SASH_WEIGHTS_1")) != null) {
                weights1 = weightInt;
            }
        }
        this.customizeSashForm.setWeights(new int[]{weights0, weights1});
        tabItem.setControl((Control)this.customizeSashForm);
    }

    private class BibTeXDragTableAdapter
    extends DragSourceAdapter {
        IStructuredSelection selection = null;
        private int column = -1;

        private BibTeXDragTableAdapter() {
        }

        public void dragStart(DragSourceEvent event) {
            this.selection = (IStructuredSelection)ExportReference.this.bibtexItemTableView.getSelection();
            Point pt = new Point(event.x, event.y);
            TableItem item = ExportReference.this.bibtexItemTableView.getTable().getItem(pt);
            if (item != null) {
                int i = 0;
                while (i < ExportReference.this.BibTeX_TableHead.length) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        this.column = i;
                        break;
                    }
                    ++i;
                }
            }
            event.doit = true;
        }

        public void dragFinished(DragSourceEvent event) {
            this.selection = null;
        }

        public void dragSetData(DragSourceEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                StringBuffer sb = new StringBuffer();
                if (this.column == 1) {
                    for (BibTeXData bibtexData : this.selection) {
                        String str = bibtexData.getContent();
                        if (str == null || str.length() <= 0) continue;
                        sb.append(str).append("\n");
                    }
                } else {
                    BibTeXData bibtexData = (BibTeXData)this.selection.getFirstElement();
                    sb.append("\\cite{");
                    sb.append(bibtexData.getCitationkey());
                    sb.append("}");
                }
                if (sb.length() > 0) {
                    event.data = sb.toString();
                }
            } else if (RTFTransfer.getInstance().isSupportedType(event.dataType)) {
                StringBuffer sb = new StringBuffer();
                if (this.column == 1) {
                    for (BibTeXData bibtexData : this.selection) {
                        String str = bibtexData.getContent();
                        if (str == null || str.length() <= 0) continue;
                        sb.append(str).append("\n");
                    }
                } else {
                    BibTeXData bibtexData = (BibTeXData)this.selection.getFirstElement();
                    sb.append("\\cite{");
                    sb.append(bibtexData.getCitationkey());
                    sb.append("}");
                }
                if (sb.length() > 0) {
                    event.data = sb.toString();
                }
            }
        }
    }

    class BibTeXNameSorter
    extends ViewerSorter {
        private int sortKey_ = 0;
        private int sortDirection_ = 128;

        BibTeXNameSorter() {
        }

        public int getSortDirection() {
            return this.sortDirection_;
        }

        public void setSortDirection(int sortDirection) {
            this.sortDirection_ = sortDirection;
        }

        public void setColumnIndex(int sortKey) {
            this.sortKey_ = sortKey;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            String key = ExportReference.this.BibTeX_TableHead[this.sortKey_];
            String s1 = "";
            String s2 = "";
            if (o1 instanceof Document && o2 instanceof Document) {
                String parsername;
                ITypeParser tp;
                String t2;
                Document d2;
                Element e2;
                Element element2;
                String parsername2;
                ITypeParser tp2;
                Document d1 = (Document)o1;
                String t1 = DataDomImpl.getDefaultType((Document)d1);
                Element e1 = DataDomImpl.getDataOfType((Document)d1, (String)t1);
                Element element1 = DataDomImpl.getElement((Element)e1, (String)key);
                if (element1 != null && (tp2 = FrameworkPlugin.getParser((String)(parsername2 = DataDomImpl.getParserName((Element)element1)))) != null) {
                    s1 = tp2.getSingleText(element1);
                }
                if ((element2 = DataDomImpl.getElement((Element)(e2 = DataDomImpl.getDataOfType((Document)(d2 = (Document)o2), (String)(t2 = DataDomImpl.getDefaultType((Document)d2)))), (String)key)) != null && (tp = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)element2)))) != null) {
                    s2 = tp.getSingleText(element2);
                }
            } else if (o1 instanceof BibTeXData && o2 instanceof BibTeXData) {
                BibTeXData bibtexData1 = (BibTeXData)o1;
                BibTeXData bibtexData2 = (BibTeXData)o2;
                if (key.equals(ExportReference.this.BibTeX_TableHead[0])) {
                    s1 = bibtexData1.getCitationkey();
                    s2 = bibtexData2.getCitationkey();
                } else if (key.equals(ExportReference.this.BibTeX_TableHead[1])) {
                    s1 = bibtexData1.getContent();
                    s2 = bibtexData2.getContent();
                }
            }
            if (this.sortDirection_ == 128) {
                return s1.compareTo(s2);
            }
            return s2.compareTo(s1);
        }
    }

    private class ItemTableDropListener
    extends DropTargetAdapter {
        private ItemTableDropListener() {
        }

        public void dragEnter(DropTargetEvent e) {
            if (DataDomTransfer.getInstance().isSupportedType(e.currentDataType)) {
                e.detail = 1;
            }
        }

        public void drop(DropTargetEvent e) {
            String[] filepath;
            if (DataDomTransfer.getInstance().isSupportedType(e.currentDataType)) {
                Document[] docs = (Document[])e.data;
                String typename = null;
                if (docs[0] != null) {
                    typename = TypeDomImpl.getTypeName((Document)docs[0]);
                }
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    BibTeXData bibtexData;
                    ArrayList al = (ArrayList)ExportReference.this.bibtexItemTableView.getInput();
                    StringBuffer sb = new StringBuffer();
                    ExportReference.this.bibtexStyledText.setText("");
                    ExportReference.this.bibtexItemTableView.getTable().deselectAll();
                    int j = al.size() - 1;
                    while (j >= 0) {
                        bibtexData = null;
                        int i = 1;
                        while (i < docs.length) {
                            if (((BibTeXData)al.get(j)).getDataDoc().equals(docs[i])) {
                                bibtexData = (BibTeXData)al.get(j);
                                break;
                            }
                            ++i;
                        }
                        if (bibtexData != null) {
                            al.remove(bibtexData);
                        } else {
                            sb.insert(0, ((BibTeXData)al.get(j)).getContent());
                        }
                        --j;
                    }
                    int i = 1;
                    while (i < docs.length) {
                        bibtexData = new BibTeXData(docs[i]);
                        al.add(bibtexData);
                        bibtexData.createContent(typename);
                        sb.append(bibtexData.getContent());
                        ++i;
                    }
                    ExportReference.this.bibtexStyledText.setText(sb.toString());
                    ExportReference.this.bibtexItemTableView.refresh();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ReferBibIXData referbibixxData;
                    ArrayList al = (ArrayList)ExportReference.this.referbibixItemTableView.getInput();
                    StringBuffer sb = new StringBuffer();
                    ExportReference.this.referbibixStyledText.setText("");
                    ExportReference.this.referbibixItemTableView.getTable().deselectAll();
                    int j = al.size() - 1;
                    while (j >= 0) {
                        referbibixxData = null;
                        int i = 1;
                        while (i < docs.length) {
                            if (((ReferBibIXData)al.get(j)).getDataDoc().equals(docs[i])) {
                                referbibixxData = (ReferBibIXData)al.get(j);
                                break;
                            }
                            ++i;
                        }
                        if (referbibixxData != null) {
                            al.remove(referbibixxData);
                        } else {
                            sb.insert(0, "\n");
                            sb.insert(0, ((ReferBibIXData)al.get(j)).getContent());
                        }
                        --j;
                    }
                    int i = 1;
                    while (i < docs.length) {
                        referbibixxData = new ReferBibIXData(docs[i]);
                        al.add(referbibixxData);
                        referbibixxData.createContent(typename);
                        sb.append(referbibixxData.getContent());
                        ++i;
                    }
                    ExportReference.this.referbibixStyledText.setText(sb.toString());
                    ExportReference.this.referbibixItemTableView.refresh();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ArrayList al = (ArrayList)ExportReference.this.customizeItemTableView.getInput();
                    int i = 1;
                    while (i < docs.length) {
                        if (al.indexOf(docs[i]) == -1) {
                            if (typename == null) {
                                typename = DataDomImpl.getDefaultType((Document)docs[i]);
                            }
                            al.add(docs[i]);
                            ReferenceDataFormatDomImpl.setStyledText(docs[i], typename, ExportReference.this.customizeReferenceFormatStyledText, ExportReference.this.fontReg);
                            ExportReference.this.customizeReferenceFormatStyledText.append("\n");
                        }
                        ++i;
                    }
                }
                if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeItemTableView.refresh();
                }
            } else if (FileTransfer.getInstance().isSupportedType(e.currentDataType) && (filepath = (String[])e.data) != null) {
                if (ExportReference.this.tabFolder.getSelectionIndex() == 0) {
                    ArrayList al = (ArrayList)ExportReference.this.bibtexItemTableView.getInput();
                    StringBuffer sb = new StringBuffer();
                    ExportReference.this.bibtexStyledText.setText("");
                    ExportReference.this.bibtexItemTableView.getTable().deselectAll();
                    int j = al.size() - 1;
                    while (j >= 0) {
                        BibTeXData bibtexData = null;
                        int i = 0;
                        while (i < filepath.length) {
                            Document datadoc = ExportReference.this.getDataDocument(filepath[i]);
                            if (datadoc != null && ((BibTeXData)al.get(j)).getDataDoc().equals(datadoc)) {
                                bibtexData = (BibTeXData)al.get(j);
                                break;
                            }
                            ++i;
                        }
                        if (bibtexData != null) {
                            al.remove(bibtexData);
                        } else {
                            sb.insert(0, ((BibTeXData)al.get(j)).getContent());
                        }
                        --j;
                    }
                    int i = 0;
                    while (i < filepath.length) {
                        Document datadoc = ExportReference.this.getDataDocument(filepath[i]);
                        if (datadoc != null) {
                            BibTeXData bibtexData = new BibTeXData(datadoc);
                            al.add(bibtexData);
                            bibtexData.createContent();
                            sb.append(bibtexData.getContent());
                        }
                        ++i;
                    }
                    ExportReference.this.bibtexStyledText.setText(sb.toString());
                    ExportReference.this.bibtexItemTableView.refresh();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 1) {
                    ArrayList al = (ArrayList)ExportReference.this.referbibixItemTableView.getInput();
                    StringBuffer sb = new StringBuffer();
                    ExportReference.this.referbibixStyledText.setText("");
                    ExportReference.this.referbibixItemTableView.getTable().deselectAll();
                    int j = al.size() - 1;
                    while (j >= 0) {
                        ReferBibIXData referbibixData = null;
                        int i = 0;
                        while (i < filepath.length) {
                            Document datadoc = ExportReference.this.getDataDocument(filepath[i]);
                            if (datadoc != null && ((ReferBibIXData)al.get(j)).getDataDoc().equals(datadoc)) {
                                referbibixData = (ReferBibIXData)al.get(j);
                                break;
                            }
                            ++i;
                        }
                        if (referbibixData != null) {
                            al.remove(referbibixData);
                        } else {
                            sb.insert(0, "\n");
                            sb.insert(0, ((ReferBibIXData)al.get(j)).getContent());
                        }
                        --j;
                    }
                    int i = 0;
                    while (i < filepath.length) {
                        Document datadoc = ExportReference.this.getDataDocument(filepath[i]);
                        if (datadoc != null) {
                            ReferBibIXData referbibixxData = new ReferBibIXData(datadoc);
                            al.add(referbibixxData);
                            referbibixxData.createContent();
                            sb.append(referbibixxData.getContent());
                            sb.append("\n");
                        }
                        ++i;
                    }
                    ExportReference.this.referbibixStyledText.setText(sb.toString());
                    ExportReference.this.referbibixItemTableView.refresh();
                } else if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    int i = 0;
                    while (i < filepath.length) {
                        ArrayList al;
                        Document datadoc = ExportReference.this.getDataDocument(filepath[i]);
                        if (datadoc != null && (al = (ArrayList)ExportReference.this.customizeItemTableView.getInput()).indexOf(datadoc) == -1) {
                            al.add(datadoc);
                            ReferenceDataFormatDomImpl.setStyledText(datadoc, null, ExportReference.this.customizeReferenceFormatStyledText, ExportReference.this.fontReg);
                            ExportReference.this.customizeReferenceFormatStyledText.append("\n");
                        }
                        ++i;
                    }
                }
                if (ExportReference.this.tabFolder.getSelectionIndex() == 2) {
                    ExportReference.this.customizeItemTableView.refresh();
                }
            }
        }
    }

    class ItemTableViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ItemTableViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Document) {
                Document doc = (Document)obj;
                if (index == 0) {
                    return DomImpl.getAllText((Document)doc);
                }
            } else if (obj instanceof BibTeXData) {
                BibTeXData bibtexData = (BibTeXData)obj;
                if (index == 0) {
                    return bibtexData.getCitationkey();
                }
                if (index == 1) {
                    return bibtexData.getContent();
                }
            } else if (obj instanceof ReferBibIXData) {
                ReferBibIXData data = (ReferBibIXData)obj;
                if (index == 0) {
                    return data.getContent();
                }
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class NameSorter
    extends ViewerSorter {
        private int sortKey_ = 0;
        private int sortDirection_ = 128;

        NameSorter() {
        }

        public int getSortDirection() {
            return this.sortDirection_;
        }

        public void setSortDirection(int sortDirection) {
            this.sortDirection_ = sortDirection;
        }

        public void setColumnIndex(int sortKey) {
            this.sortKey_ = sortKey;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            String key = ExportReference.this.tableHead[this.sortKey_];
            String s1 = "";
            String s2 = "";
            if (o1 instanceof Document && o2 instanceof Document) {
                String parsername;
                ITypeParser tp;
                String t2;
                Document d2;
                Element e2;
                Element element2;
                String parsername2;
                ITypeParser tp2;
                Document d1 = (Document)o1;
                String t1 = DataDomImpl.getDefaultType((Document)d1);
                Element e1 = DataDomImpl.getDataOfType((Document)d1, (String)t1);
                Element element1 = DataDomImpl.getElement((Element)e1, (String)key);
                if (element1 != null && (tp2 = FrameworkPlugin.getParser((String)(parsername2 = DataDomImpl.getParserName((Element)element1)))) != null) {
                    s1 = tp2.getSingleText(element1);
                }
                if ((element2 = DataDomImpl.getElement((Element)(e2 = DataDomImpl.getDataOfType((Document)(d2 = (Document)o2), (String)(t2 = DataDomImpl.getDefaultType((Document)d2)))), (String)key)) != null && (tp = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)element2)))) != null) {
                    s2 = tp.getSingleText(element2);
                }
            } else if (o1 instanceof ReferenceData && o2 instanceof ReferenceData) {
                ReferenceData data1 = (ReferenceData)o1;
                ReferenceData data2 = (ReferenceData)o2;
                if (key.equals(ExportReference.this.tableHead[0])) {
                    s1 = data1.getContent();
                    s2 = data2.getContent();
                }
            }
            if (this.sortDirection_ == 128) {
                return s1.compareTo(s2);
            }
            return s2.compareTo(s1);
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }
}

