/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.download;

import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.ConciergeAdapter;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.download.PDFDownloadException;
import jp.sourceforge.concierge.plugin.ipapers.download.downloadPDF;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class PDFDownloadJob
extends Job {
    private String PDFlocation = null;
    private String filelocation = null;
    private Paper anArticle = null;

    public PDFDownloadJob(String name, String filelocation, String PDFlocation, Paper anArticle) {
        super(name);
        this.PDFlocation = PDFlocation;
        this.filelocation = filelocation;
        this.anArticle = anArticle;
    }

    protected IStatus run(IProgressMonitor monitor) {
        downloadPDF dl = new downloadPDF(this.anArticle.getURL());
        monitor.beginTask("Download the PDF file to " + this.filelocation, 100);
        monitor.subTask(this.filelocation);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(20);
        try {
            dl.fetchPDF(this.PDFlocation, this.filelocation);
        }
        catch (PDFDownloadException e) {
            PDFDownloadJob.showErrorMessages(e.getMessage());
            return Status.CANCEL_STATUS;
        }
        monitor.worked(90);
        if (this.isModal(this)) {
            PDFDownloadJob.showResults(this.anArticle, this.filelocation);
        } else {
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, PDFDownloadJob.getReservationCompletedAction(this.anArticle, this.filelocation));
        }
        return Status.OK_STATUS;
    }

    public boolean isModal(Job job) {
        Boolean isModal = (Boolean)job.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    protected static Action getReservationCompletedAction(Paper anArticle, String filelocation) {
        return new Action("View download status"){

            public void run() {
                try {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    anArticle.setFlag(4);
                    anArticle.getPaperInfo().setFilepath(filelocation);
                    MessageBox dlg = new MessageBox(shell, 196);
                    dlg.setMessage("Downloading Complete. Do you want to import the paper?");
                    int result = dlg.open();
                    if (result == 64 && ConciergeAdapter.saveArticle(anArticle.getPaperInfo(), IPapersPlugin.getDefault().getBundle().getSymbolicName())) {
                        anArticle.setFlag(2);
                    }
                }
                catch (CannotGetPaperInfoException cannotGetPaperInfoException) {}
            }
        };
    }

    protected static void showResults(Paper anArticle, String filelocation) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PDFDownloadJob.getReservationCompletedAction(anArticle, filelocation).run();
            }
        });
    }

    protected static Action getErrorMessageAction(String message) {
        return new Action("View download status"){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageBox errDlg = new MessageBox(shell, 1);
                errDlg.setMessage("Cound not fetch PDF (You may not have permission)");
                errDlg.open();
            }
        };
    }

    protected static void showErrorMessages(String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PDFDownloadJob.getErrorMessageAction(message).run();
            }
        });
    }
}

