/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class GenericSpecificationImpl
extends VersionConstraintImpl
implements GenericSpecification {
    private Filter matchingFilter;
    private String type = "generic";
    private int resolution = 0;
    private GenericDescription[] suppliers;

    @Override
    public String getMatchingFilter() {
        return this.matchingFilter == null ? null : this.matchingFilter.toString();
    }

    void setMatchingFilter(String matchingFilter) throws InvalidSyntaxException {
        this.matchingFilter = matchingFilter == null ? null : FrameworkUtil.createFilter(matchingFilter);
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription supplier) {
        if (!(supplier instanceof GenericDescription)) {
            return false;
        }
        GenericDescription candidate = (GenericDescription)supplier;
        if (this.getName() == null || !this.getName().equals(candidate.getName())) {
            return false;
        }
        if (this.getType() == null || !this.getType().equals(candidate.getType())) {
            return false;
        }
        return this.matchingFilter == null || this.matchingFilter.match(candidate.getAttributes());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Eclipse-GenericRequire").append(": ").append(this.getName());
        if (this.getType() != "generic") {
            sb.append(':').append(this.getType());
        }
        if (this.matchingFilter != null) {
            sb.append("; ").append(this.getMatchingFilter());
        }
        return sb.toString();
    }

    @Override
    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type == null || type.equals("generic") ? "generic" : type;
    }

    @Override
    public int getResolution() {
        return this.resolution;
    }

    @Override
    public boolean isResolved() {
        return this.suppliers != null && this.suppliers.length > 0;
    }

    void setResolution(int resolution) {
        this.resolution = resolution;
    }

    @Override
    public BaseDescription getSupplier() {
        return this.suppliers == null || this.suppliers.length == 0 ? null : this.suppliers[0];
    }

    @Override
    protected void setSupplier(BaseDescription supplier) {
        if (supplier == null) {
            this.suppliers = null;
            return;
        }
        int len = this.suppliers == null ? 0 : this.suppliers.length;
        GenericDescription[] temp = new GenericDescription[len + 1];
        if (this.suppliers != null) {
            System.arraycopy(this.suppliers, 0, temp, 0, len);
        }
        temp[len] = (GenericDescription)supplier;
        this.suppliers = temp;
    }

    @Override
    public GenericDescription[] getSuppliers() {
        return this.suppliers;
    }

    void setSupplers(GenericDescription[] suppliers) {
        this.suppliers = suppliers;
    }
}

