/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.BaseSaveAction;
import org.eclipse.ui.internal.IBackgroundSaveListener;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;

public class SaveAction
extends BaseSaveAction
implements IBackgroundSaveListener {
    public SaveAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.SaveAction_text, window);
        this.setText(WorkbenchMessages.SaveAction_text);
        this.setToolTipText(WorkbenchMessages.SaveAction_toolTip);
        this.setId("save");
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.save_action_context");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.file.save");
        ((WorkbenchWindow)window).addBackgroundSaveListener(this);
    }

    @Override
    public void dispose() {
        ((WorkbenchWindow)this.getWorkbenchWindow()).removeBackgroundSaveListener(this);
        super.dispose();
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        ISaveablePart saveView = this.getSaveableView();
        if (saveView != null) {
            ((WorkbenchPage)this.getActivePart().getSite().getPage()).savePart(saveView, this.getActivePart(), false);
            return;
        }
        IEditorPart part = this.getActiveEditor();
        if (part != null) {
            IWorkbenchPage page = part.getSite().getPage();
            page.saveEditor(part, false);
        }
    }

    @Override
    protected void updateState() {
        ISaveablePart saveable = this.getSaveableView();
        if (saveable == null) {
            saveable = this.getActiveEditor();
        }
        if (saveable instanceof ISaveablesSource) {
            ISaveablesSource modelSource = (ISaveablesSource)((Object)saveable);
            this.setEnabled(SaveableHelper.needsSave(modelSource));
            return;
        }
        this.setEnabled(saveable != null && saveable.isDirty());
    }

    @Override
    public void handleBackgroundSaveStarted() {
        this.updateState();
    }
}

