/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.IStickyViewManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.StickyViewManager32;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class StickyViewManager
implements IStickyViewManager {
    private IWorkbenchPage page;

    public StickyViewManager(IWorkbenchPage page) {
        this.page = page;
    }

    public static IStickyViewManager getInstance(IWorkbenchPage page) {
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        boolean enable32Behavior = preferenceStore.getBoolean("ENABLE_32_STICKY_CLOSE_BEHAVIOR");
        IStickyViewManager stickyViewMan = enable32Behavior ? new StickyViewManager32(page) : new StickyViewManager(page);
        return stickyViewMan;
    }

    @Override
    public void add(String perspectiveId, Set stickyViewSet) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void remove(String perspectiveId) {
    }

    @Override
    public void restore(IMemento memento) {
    }

    @Override
    public void save(IMemento memento) {
    }

    @Override
    public void update(Perspective oldPersp, Perspective newPersp) {
        if (oldPersp == null || newPersp == null) {
            return;
        }
        IViewRegistry viewReg = WorkbenchPlugin.getDefault().getViewRegistry();
        IStickyViewDescriptor[] stickyDescs = viewReg.getStickyViews();
        int i = 0;
        while (i < stickyDescs.length) {
            String viewId = stickyDescs[i].getId();
            try {
                if (oldPersp.findView(viewId) != null) {
                    this.page.showView(viewId, null, 3);
                } else if (newPersp.findView(viewId) != null && oldPersp.findView(viewId) == null) {
                    this.page.hideView(newPersp.findView(viewId));
                }
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log("Could not open view :" + viewId, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "Could not open view :" + viewId, (Throwable)((Object)e)));
            }
            ++i;
        }
    }
}

