/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.AbstractObjectPolicy;
import org.eclipse.core.internal.indexing.BinarySmallObject;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStoreContext;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.StoredObject;

public class IndexedStoreObjectPolicy
extends AbstractObjectPolicy {
    @Override
    public StoredObject createObject(Field field, ObjectStore store, ObjectAddress address) throws ObjectStoreException {
        int offset = 0;
        int length = 2;
        int type = field.subfield(offset, length).getInt();
        IndexedStoreObject object = null;
        switch (type) {
            case 1: {
                object = new IndexAnchor(field, store, address);
                break;
            }
            case 3: {
                object = new IndexNode(field, store, address);
                break;
            }
            case 2: {
                object = new IndexedStoreContext(field, store, address);
                break;
            }
            case 5: {
                object = new BinarySmallObject(field, store, address);
                break;
            }
            default: {
                throw new ObjectStoreException(23);
            }
        }
        return object;
    }
}

