/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ExpanderDrawData
extends DrawData {
    public ExpanderDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gc, Rectangle bounds) {
        int treeHandle = theme.treeHandle;
        int gtkStyle = OS.gtk_widget_get_style(treeHandle);
        int drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        int state_type = this.getStateType(0);
        int expander_style = 0;
        if ((this.style & 0x400) != 0) {
            expander_style = 3;
        }
        byte[] detail = Converter.wcsToMbcs(null, "treeview", true);
        int expander_size = theme.getWidgetProperty(treeHandle, "expander-size");
        int x = bounds.x + expander_size / 2;
        int y = bounds.y + expander_size / 2;
        OS.gtk_paint_expander(gtkStyle, drawable, state_type, null, treeHandle, detail, x, y, expander_style);
    }

    @Override
    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        int treeHandle = theme.treeHandle;
        int expander_size = theme.getWidgetProperty(treeHandle, "expander-size");
        if (new Rectangle(bounds.x, bounds.y, expander_size, expander_size).contains(position)) {
            return 0;
        }
        return -1;
    }
}

