/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.tabulator;

import java.io.File;
import java.util.Date;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.TabulatorPlugin;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    protected Image fileicon = TabulatorPlugin.getImageDescriptor("icons/attached.png").createImage();
    protected Image nofileicon = SystemUtil.GetOSType() == 0 ? null : TabulatorPlugin.getImageDescriptor("icons/noattached.png").createImage();
    protected Image nofilebackicon = TabulatorPlugin.getImageDescriptor("icons/noattached_backuped.png").createImage();
    protected Color GREENCOLOR = new Color(null, 0, 128, 0);
    protected Color BLACKCOLOR = new Color(null, 0, 0, 0);
    protected TableViewer tableview = null;
    protected boolean fullpath;
    protected String typename;

    public ItemLabelProvider(TableViewer parent, String type) {
        this.tableview = parent;
        this.fullpath = false;
        this.typename = type;
    }

    public boolean isLabelProperty(Object object, String property) {
        return false;
    }

    public String getColumnText(Object object, int index) {
        Document doc = (Document)object;
        TableColumn tc = this.tableview.getTable().getColumn(index);
        String title = tc.getText();
        if (title.compareTo(TabulatorPlugin.getString("Tabulator.5")) == 0) {
            return new Date(DomImpl.getCreatedTime((Document)doc)).toString();
        }
        if (title.compareTo(TabulatorPlugin.getString("Tabulator.6")) == 0) {
            return new Date(DomImpl.getLastModifiedTime((Document)doc)).toString();
        }
        if (title.compareTo(TabulatorPlugin.getString("Tabulator.7")) == 0) {
            String fname;
            String string = fname = this.fullpath ? DataDomImpl.getFilePath((Document)doc) : DataDomImpl.getFileName((Document)doc);
            if ((fname == null || fname.length() == 0) && (fname = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)((Document)object)))) == null) {
                return null;
            }
            return fname;
        }
        if (this.typename == null) {
            return null;
        }
        ITypeParser parser = (ITypeParser)tc.getData("parser");
        Element delem = DataDomImpl.getElement((Document)doc, (String)title, (String)this.typename);
        return delem != null ? parser.getSingleText(delem) : "";
    }

    public Image getColumnImage(Object object, int index) {
        File ff;
        TableColumn tc = this.tableview.getTable().getColumn(index);
        String title = tc.getText();
        if (title.compareTo(TabulatorPlugin.getString("Tabulator.7")) != 0) {
            return null;
        }
        Document doc = (Document)object;
        String fname = DataDomImpl.getFilePath((Document)doc);
        if (fname != null && fname.length() > 0 && (ff = new File(fname)).exists()) {
            return this.fileicon;
        }
        return FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)doc)) == null ? this.nofileicon : this.nofilebackicon;
    }

    public Color getForeground(Object element, int index) {
        Document doc = (Document)element;
        if (DomImpl.getTextLength((Document)doc) == 0) {
            return this.GREENCOLOR;
        }
        return this.BLACKCOLOR;
    }

    public Color getBackground(Object element, int index) {
        return null;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.GREENCOLOR.dispose();
        this.BLACKCOLOR.dispose();
    }

    public void showFullpath(boolean b) {
        this.fullpath = b;
    }

    public boolean isFullpath() {
        return this.fullpath;
    }
}

