/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleException;

public class SystemBundle
extends BundleHost {
    ProtectionDomain systemDomain;

    protected SystemBundle(Framework framework) throws BundleException {
        super(framework.adaptor.createSystemBundleData(), framework);
        Constants.setInternalSymbolicName(this.bundledata.getSymbolicName());
        this.state = 4;
        this.context = this.createContext();
    }

    @Override
    protected void load() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.systemDomain = this.getClass().getProtectionDomain();
        }
    }

    @Override
    protected boolean reload(AbstractBundle newBundle) {
        return false;
    }

    @Override
    protected void refresh() {
    }

    @Override
    protected boolean unload() {
        return false;
    }

    @Override
    protected void close() {
        this.context.close();
        this.context = null;
        this.state = 1;
    }

    @Override
    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            this.framework.checkAdminPermission(this, "class");
            this.checkValid();
        }
        return Class.forName(name);
    }

    @Override
    public URL getResource(String name) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    @Override
    public void start() {
        this.framework.checkAdminPermission(this, "execute");
    }

    @Override
    protected void resume() {
        this.framework.startLevelManager.initialize();
        this.framework.startLevelManager.launch(this.framework.startLevelManager.getFrameworkStartLevel());
    }

    @Override
    public void stop() {
        this.framework.checkAdminPermission(this, "execute");
        if (this.state == 32) {
            Thread shutdown = this.framework.secureAction.createThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SystemBundle.this.framework.shutdown();
                    }
                    catch (Throwable t) {
                        SystemBundle.this.framework.adaptor.handleRuntimeError(t);
                    }
                }
            }, "System Bundle Shutdown");
            shutdown.start();
        }
    }

    protected void suspend() {
        this.framework.startLevelManager.shutdown();
        this.framework.startLevelManager.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
        this.framework.publishBundleEvent(4, this);
    }

    @Override
    protected void suspend(boolean lock) {
    }

    @Override
    public void update() {
        this.framework.checkAdminPermission(this, "lifecycle");
        if (this.state == 32) {
            Thread restart = this.framework.secureAction.createThread(new Runnable(){

                @Override
                public void run() {
                    String prevSLProp = FrameworkProperties.getProperty("osgi.framework.beginningstartlevel");
                    String sl = String.valueOf(SystemBundle.this.framework.startLevelManager.getStartLevel());
                    FrameworkProperties.setProperty("osgi.framework.beginningstartlevel", sl);
                    FrameworkProperties.setProperty("osgi.framework.relaunch", "");
                    SystemBundle.this.framework.shutdown();
                    SystemBundle.this.framework.launch();
                    FrameworkProperties.clearProperty("osgi.framework.relaunch");
                    if (prevSLProp == null) {
                        FrameworkProperties.clearProperty("osgi.framework.beginningstartlevel");
                    } else {
                        FrameworkProperties.setProperty("osgi.framework.beginningstartlevel", prevSLProp);
                    }
                }
            }, "System Bundle Update");
            restart.start();
        }
    }

    @Override
    public void update(InputStream in) {
        this.update();
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void uninstall() throws BundleException {
        this.framework.checkAdminPermission(this, "lifecycle");
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION);
    }

    @Override
    public boolean hasPermission(Object permission) {
        if (this.systemDomain != null) {
            if (permission instanceof Permission) {
                return this.systemDomain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    protected void unresolvePermissions(AbstractBundle[] refreshedBundles) {
    }

    @Override
    public Dictionary getHeaders(String localeString) {
        return new SystemBundleHeaders(super.getHeaders(localeString));
    }

    class SystemBundleHeaders
    extends Dictionary {
        private final Dictionary headers;

        public SystemBundleHeaders(Dictionary headers) {
            this.headers = headers;
        }

        public Enumeration elements() {
            return this.headers.elements();
        }

        public Object get(Object key) {
            if (!"Export-Package".equals(key)) {
                return this.headers.get(key);
            }
            String systemPackages = FrameworkProperties.getProperty("org.osgi.framework.system.packages");
            String resorts = (String)this.headers.get("Export-Package");
            if (systemPackages != null) {
                resorts = resorts != null ? String.valueOf(resorts) + ", " + systemPackages : systemPackages;
            }
            return resorts;
        }

        @Override
        public boolean isEmpty() {
            return this.headers.isEmpty();
        }

        public Enumeration keys() {
            return this.headers.keys();
        }

        public Object put(Object key, Object value) {
            return this.headers.put(key, value);
        }

        public Object remove(Object key) {
            return this.headers.remove(key);
        }

        @Override
        public int size() {
            return this.headers.size();
        }
    }
}

