/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.internal.indexing.AbstractPagePolicy;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Log;
import org.eclipse.core.internal.indexing.LogReader;
import org.eclipse.core.internal.indexing.LogWriter;
import org.eclipse.core.internal.indexing.Page;
import org.eclipse.core.internal.indexing.PageStoreException;

public class PageStore
implements Observer {
    private static final int NumberOfMetadataAreas = 16;
    private static final int SizeOfMetadataArea = 64;
    private static final int CurrentPageStoreVersion = 1;
    private static final byte[] ZEROES = new byte[1024];
    private String name;
    private RandomAccessFile file;
    private int numberOfPages;
    private int numberOfFileReads;
    private int numberOfFileWrites;
    private int numberOfReads;
    private int numberOfCacheHits;
    private Map modifiedPages;
    private Map acquiredPages;
    private int storeOffset;
    private AbstractPagePolicy policy;
    private byte[] pageBuffer;
    private byte[] metadataBuffer;

    public static void create(String fileName) throws PageStoreException {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            out.close();
        }
        catch (IOException e) {
            throw new PageStoreException(1, (Throwable)e);
        }
    }

    public static void delete(String fileName) {
        new File(fileName).delete();
    }

    public static boolean exists(String fileName) {
        return new File(fileName).exists();
    }

    public PageStore(AbstractPagePolicy policy) {
        this.policy = policy;
        this.storeOffset = 1024;
    }

    public void open(String name) throws PageStoreException {
        this.name = name;
        this.pageBuffer = new byte[8192];
        this.metadataBuffer = new byte[64];
        if (!PageStore.exists(name)) {
            PageStore.create(name);
        }
        try {
            this.file = new RandomAccessFile(name, "rw");
        }
        catch (IOException e) {
            throw new PageStoreException(2, (Throwable)e);
        }
        this.checkMetadata();
        this.numberOfPages = this.numberOfPagesInFile();
        this.numberOfFileReads = 0;
        this.numberOfFileWrites = 0;
        this.numberOfReads = 0;
        this.numberOfCacheHits = 0;
        this.modifiedPages = LogReader.getModifiedPages(this);
        this.flush();
        Log.delete(name);
        this.acquiredPages = new HashMap();
    }

    private void checkMetadata() throws PageStoreException {
        byte[] md = this.readMetadataArea(0);
        Buffer metadata = new Buffer(md);
        Field versionField = metadata.getField(0, 4);
        int pageStoreVersion = versionField.getInt();
        if (pageStoreVersion == 0) {
            versionField.put(1);
            this.writeMetadataArea(0, md);
            return;
        }
        if (pageStoreVersion == 1) {
            return;
        }
        this.convertPageStore(pageStoreVersion);
    }

    private void convertPageStore(int fromVersion) throws PageStoreException {
        throw new PageStoreException(9);
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean commit) {
        if (commit) {
            try {
                this.commit();
            }
            catch (PageStoreException pageStoreException) {}
        }
        try {
            this.file.close();
        }
        catch (IOException iOException) {}
        this.file = null;
    }

    public void commit() throws PageStoreException {
        if (this.modifiedPages.size() == 0) {
            return;
        }
        LogWriter.putModifiedPages(this, this.modifiedPages);
        this.flush();
        Log.delete(this.name);
    }

    private void flush() throws PageStoreException {
        if (this.modifiedPages.size() == 0) {
            return;
        }
        for (Page page : this.modifiedPages.values()) {
            this.writePage(page);
        }
        this.modifiedPages.clear();
    }

    public Page acquire(int pageNumber) throws PageStoreException {
        ++this.numberOfReads;
        Integer key = new Integer(pageNumber);
        Page page = (Page)this.acquiredPages.get(key);
        if (page == null) {
            page = (Page)this.modifiedPages.get(key);
            if (page == null) {
                this.numberOfPages = Math.max(pageNumber + 1, this.numberOfPages);
                page = this.readPage(pageNumber);
            } else {
                ++this.numberOfCacheHits;
            }
            this.acquiredPages.put(key, page);
            page.addObserver(this);
        } else {
            ++this.numberOfCacheHits;
        }
        page.addReference();
        return page;
    }

    public void release(Page page) {
        Integer key = new Integer(page.getPageNumber());
        page.removeReference();
        if (page.hasReferences()) {
            return;
        }
        page.deleteObserver(this);
        this.acquiredPages.remove(key);
    }

    @Override
    public void update(Observable object, Object arg) {
        Page page = (Page)object;
        Integer key = new Integer(page.getPageNumber());
        this.modifiedPages.put(key, page);
    }

    protected long offsetOfPage(int pageNumber) {
        return (long)(pageNumber * 8192) + (long)this.storeOffset;
    }

    protected Page readPage(int pageNumber) throws PageStoreException {
        if (!this.readBuffer(this.offsetOfPage(pageNumber), this.pageBuffer)) {
            throw new PageStoreException(5);
        }
        ++this.numberOfFileReads;
        Page p = this.policy.createPage(pageNumber, this.pageBuffer, this);
        p.addObserver(this);
        return p;
    }

    protected void writePage(Page page) throws PageStoreException {
        page.toBuffer(this.pageBuffer);
        long fileOffset = this.offsetOfPage(page.getPageNumber());
        if (!this.writeBuffer(fileOffset, this.pageBuffer, 0, this.pageBuffer.length)) {
            throw new PageStoreException(4);
        }
        ++this.numberOfFileWrites;
    }

    protected long offsetOfMetadataArea(int i) {
        return (long)i * 64L;
    }

    public byte[] readMetadataArea(int i) throws PageStoreException {
        if (!this.readBuffer(this.offsetOfMetadataArea(i), this.metadataBuffer)) {
            throw new PageStoreException(8);
        }
        return new Buffer(this.metadataBuffer).get(0, this.metadataBuffer.length);
    }

    public void writeMetadataArea(int i, byte[] buffer) throws PageStoreException {
        if (i < 0 || i >= 16) {
            throw new PageStoreException(8);
        }
        if (buffer.length != 64) {
            throw new PageStoreException(8);
        }
        if (!this.writeBuffer(this.offsetOfMetadataArea(i), buffer, 0, buffer.length)) {
            throw new PageStoreException(8);
        }
    }

    protected boolean readBuffer(long fileOffset, byte[] buffer) {
        new Buffer(buffer).clear();
        long fileLength = this.getFileLength();
        if (fileOffset >= fileLength) {
            return true;
        }
        int bytesToRead = (int)Math.min((long)buffer.length, fileLength - fileOffset);
        try {
            this.file.seek(fileOffset);
            this.file.readFully(buffer, 0, bytesToRead);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected boolean writeBuffer(long fileOffset, byte[] buffer, int offset, int length) {
        this.clearFileToOffset(fileOffset);
        try {
            this.file.seek(fileOffset);
            this.file.write(buffer, offset, length);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected long getFileLength() {
        long n = 0L;
        try {
            n = this.file.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
        return n;
    }

    protected void clearFileToOffset(long fileOffset) {
        long fileLength = this.getFileLength();
        while (fileLength < fileOffset) {
            int m = (int)Math.min((long)ZEROES.length, fileOffset - fileLength);
            this.writeBuffer(fileLength, ZEROES, 0, m);
            fileLength += (long)m;
        }
    }

    protected int numberOfPagesInFile() {
        return (int)((this.getFileLength() - this.offsetOfPage(0)) / 8192L);
    }

    public String getName() {
        return this.name;
    }

    public AbstractPagePolicy getPolicy() {
        return this.policy;
    }

    public int numberOfPages() {
        return this.numberOfPages;
    }
}

