/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.mdocument;

import java.util.ArrayList;
import java.util.Collections;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl_internal;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl_internal;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.parser.ParserManager;
import jp.sourceforge.concierge.util.XPathString;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDomImpl_internal
extends DomImpl_internal {
    private static String convertLegalExpression(String name) {
        String str = "";
        name = name.trim();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                str = String.valueOf(str) + String.valueOf(c);
            } else if (Character.isWhitespace(c)) {
                str = String.valueOf(str) + "_";
            } else if (c != ':') {
                str = String.valueOf(str) + "-";
            }
            ++i;
        }
        return str;
    }

    private static Element getFileInfoElement(Document doc) {
        ArrayList<Element> elems = DomImpl_internal.getElements(doc, "fileinfo");
        assert (elems.size() == 1);
        return elems.get(0);
    }

    private static String getFileInfoValue(Document doc, String infotype) {
        Element felem = DataDomImpl_internal.getFileInfoElement(doc);
        ArrayList<Element> elems = DomImpl_internal.getElements(felem, infotype);
        assert (elems.size() == 1);
        return DataDomImpl_internal.getElementContent(elems.get(0));
    }

    private static ArrayList<String> getFileInfoValues(Document doc, String infotype) {
        Element felem = DataDomImpl_internal.getFileInfoElement(doc);
        ArrayList<Element> elems = DomImpl_internal.getElements(felem, infotype);
        assert (elems.size() == 1);
        return DataDomImpl_internal.getElementContents(elems.get(0));
    }

    private static void setFileInfoValue(Document doc, String infotype, String val) {
        Element felem = DataDomImpl_internal.getFileInfoElement(doc);
        ArrayList<Element> elems = DomImpl_internal.getElements(felem, infotype);
        assert (elems.size() == 1);
        DataDomImpl_internal.setElementContent(elems.get(0), val);
    }

    public static Element addDataOfType(Document doc, Document typedoc) {
        try {
            String type = TypeDomImpl.getTypeName(typedoc);
            if (type.compareTo("Unclassified") == 0) {
                return DataDomImpl_internal.getFileInfoElement(doc);
            }
            Element telem = DataDomImpl_internal.getDataOfType(doc, type);
            if (telem != null) {
                return telem;
            }
            Element topelem = DomImpl_internal.appendElement(doc, "data", null);
            DomImpl.setAttribute(topelem, "name", TypeDomImpl.getTypeName(typedoc));
            DataDomImpl_internal.addNamespace(doc, typedoc);
            ArrayList<Element> telems = TypeDomImpl.getAllElements(typedoc);
            int i = 0;
            while (i < telems.size()) {
                Element te = telems.get(i);
                String name = TypeDomImpl.getElementName(te);
                Element de = DataDomImpl_internal.appendElement(topelem, DataDomImpl_internal.convertLegalExpression(name), null);
                de.setAttribute("parser", TypeDomImpl.getParser(te));
                ++i;
            }
            return topelem;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static void removeDataOfType(Document doc, String type) {
        ArrayList<Element> delems = DomImpl_internal.getElements(doc, "data");
        int i = 0;
        while (i < delems.size()) {
            if (type.equals(DomImpl_internal.getAttribute(delems.get(i), "name"))) {
                delems.get(i).getParentNode().removeChild(delems.get(i));
                return;
            }
            ++i;
        }
    }

    protected static void addNamespace(Document doc, Document typedoc) {
        Element mroot = DomImpl_internal.getRootElement(doc);
        ArrayList<Element> elems = DomImpl_internal.getElements(typedoc, "element");
        int i = 0;
        while (i < elems.size()) {
            Element te = elems.get(i);
            String pprefix = TypeDomImpl.getParserNSPrefix(te);
            String pns = TypeDomImpl.getParserNS(te);
            mroot.setAttribute("xmlns:" + pprefix, pns);
            ++i;
        }
    }

    public static Document createDocument() {
        Document doc = DomImpl_internal.createDocument("mdata");
        DomImpl_internal.setAttribute(DomImpl_internal.getRootElement(doc), "deftype", "Unclassified");
        Element finfoelem = DomImpl_internal.appendElement(doc, "fileinfo", null);
        Element fe = DomImpl_internal.appendElement(finfoelem, "title", null);
        DomImpl_internal.setAttribute(fe, "parser", "text");
        fe = DomImpl_internal.appendElement(finfoelem, "keywords", null);
        DomImpl_internal.setAttribute(fe, "parser", "keywords");
        fe = DomImpl_internal.appendElement(finfoelem, "comment", null);
        DomImpl_internal.setAttribute(fe, "parser", "text");
        fe = DomImpl_internal.appendElement(finfoelem, "author", null);
        DomImpl_internal.setAttribute(fe, "parser", "authors");
        fe = DomImpl_internal.appendElement(finfoelem, "creator", null);
        DomImpl_internal.setAttribute(fe, "parser", "text");
        fe = DomImpl_internal.appendElement(finfoelem, "creationdate", null);
        DomImpl_internal.setAttribute(fe, "parser", "text");
        fe = DomImpl_internal.appendElement(finfoelem, "lastmoddate", null);
        DomImpl_internal.setAttribute(fe, "parser", "text");
        fe = DomImpl_internal.appendElement(finfoelem, "relatedID", null);
        DomImpl_internal.setAttribute(fe, "parser", "keywords");
        String[] pname = new String[]{"text", "keywords", "authors"};
        Element mroot = DomImpl_internal.getRootElement(doc);
        int i = 0;
        while (i < pname.length) {
            ITypeParser parser = ParserManager.getInstance(pname[i]);
            String prefix = parser.getParserNSPrefix();
            String pns = parser.getParserNS();
            DomImpl_internal.setAttribute(mroot, "xmlns:" + prefix, pns);
            ++i;
        }
        return doc;
    }

    public static Document createDocument(Document typedoc) {
        Document doc = DataDomImpl_internal.createDocument();
        if (typedoc == null || TypeDomImpl_internal.getTypeName(typedoc).compareTo("Unclassified") == 0) {
            return doc;
        }
        DataDomImpl_internal.addDataOfType(doc, typedoc);
        return doc;
    }

    protected static void setTitle(Document doc, String title) {
        DataDomImpl_internal.setFileInfoValue(doc, "title", title);
    }

    protected static String getTitle(Document doc) {
        return DataDomImpl_internal.getFileInfoValue(doc, "title");
    }

    protected static void setKeywords(Document doc, String keywords) {
        DataDomImpl_internal.setFileInfoValue(doc, "keywords", keywords);
    }

    protected static String getKeywords(Document doc) {
        return DataDomImpl_internal.getFileInfoValue(doc, "keywords");
    }

    protected static ArrayList<String> getKeywordsAsArray(Document doc) {
        return DataDomImpl_internal.getFileInfoValues(doc, "keywords");
    }

    protected static void setComment(Document doc, String comment) {
        DataDomImpl_internal.setFileInfoValue(doc, "comment", comment);
    }

    protected static String getComment(Document doc) {
        return DataDomImpl_internal.getFileInfoValue(doc, "comment");
    }

    protected static void setAuthor(Document doc, String author) {
        DataDomImpl_internal.setFileInfoValue(doc, "author", author);
    }

    protected static String getAuthor(Document doc) {
        return DataDomImpl_internal.getFileInfoValue(doc, "author");
    }

    protected static void setCreator(Document doc, String creator) {
        DataDomImpl_internal.setFileInfoValue(doc, "creator", creator);
    }

    protected static String getCreator(Document doc) {
        return DataDomImpl_internal.getFileInfoValue(doc, "creator");
    }

    protected static void setCreateDate(Document doc, String cdate) {
        DataDomImpl_internal.setFileInfoValue(doc, "creationdate", cdate);
    }

    protected static String getCreateDate(Document doc) {
        return DataDomImpl_internal.getFileInfoValue(doc, "creationdate");
    }

    protected static void setLastModDate(Document doc, String mdate) {
        DataDomImpl_internal.setFileInfoValue(doc, "lastmoddate", mdate);
    }

    protected static String getLastModDate(Document doc) {
        return DataDomImpl_internal.getFileInfoValue(doc, "lastmoddate");
    }

    protected static void setRelatedIDs(Document doc, ArrayList<String> ids) {
        if (ids.size() == 0) {
            return;
        }
        String idstr = ids.get(0);
        int i = 1;
        while (i < ids.size()) {
            idstr = String.valueOf(idstr) + "," + ids.get(i);
            ++i;
        }
        DataDomImpl_internal.setFileInfoValue(doc, "relatedID", idstr);
    }

    protected static ArrayList<String> getRelatedIDs(Document doc) {
        return DataDomImpl_internal.getFileInfoValues(doc, "relatedID");
    }

    protected static void setDefaultType(Document doc, String type) {
        DomImpl_internal.setAttribute(DomImpl_internal.getRootElement(doc), "deftype", type);
    }

    protected static String getDefaultType(Document doc) {
        return DomImpl_internal.getAttribute(DomImpl_internal.getRootElement(doc), "deftype");
    }

    protected static Element getDataOfType(Document doc, String type) {
        if (type.equals("Unclassified")) {
            ArrayList<Element> info = DomImpl_internal.getElements(doc, "fileinfo");
            assert (info.size() != 0);
            return info.get(0);
        }
        ArrayList<Element> data = DomImpl_internal.getElements(doc, "data");
        int i = 0;
        while (i < data.size()) {
            Element elem = data.get(i);
            if (DomImpl_internal.getAttribute(elem, "name").equals(type)) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    protected static void setFilePath(Document doc, String path) {
        doc.getDocumentElement().setAttribute("filepath", path);
        doc.getDocumentElement().setAttribute("filename", FilenameUtils.getName((String)path));
    }

    protected static String getFilePath(Document doc) {
        return doc.getDocumentElement().getAttribute("filepath");
    }

    protected static String getFileName(Document doc) {
        return FilenameUtils.getName((String)doc.getDocumentElement().getAttribute("filename"));
    }

    protected static ArrayList<Element> getAllParsersElements(Document doc, String type) {
        Element data = DataDomImpl_internal.getDataOfType(doc, type);
        if (data == null) {
            return new ArrayList<Element>();
        }
        return DataDomImpl_internal.getAllParsersElements(data);
    }

    protected static ArrayList<Element> getAllParsersElements(Element data) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = data.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                list.add((Element)n);
            }
            ++i;
        }
        return list;
    }

    protected static Element getElement(Document doc, String name, String type) {
        Element data = DataDomImpl_internal.getDataOfType(doc, type);
        return DataDomImpl_internal.getElement(data, name);
    }

    protected static Element getElement(Element data, String name) {
        NodeList nl = data.getElementsByTagName(DataDomImpl_internal.convertLegalExpression(name));
        Element elem = null;
        if (nl.getLength() > 0) {
            elem = (Element)nl.item(0);
        }
        return elem;
    }

    protected static void setElementContent(Element delem, String content) {
        String parsername = delem.getAttribute("parser");
        ITypeParser parser = FrameworkPlugin.getParser(parsername);
        if (content != null) {
            parser.putToElement(delem, content);
        }
    }

    protected static String getElementContent(Element delem) {
        String parsername = delem.getAttribute("parser");
        ITypeParser parser = FrameworkPlugin.getParser(parsername);
        return parser.getSingleText(delem);
    }

    protected static ArrayList<String> getElementContents(Element delem) {
        String parsername = delem.getAttribute("parser");
        ITypeParser parser = FrameworkPlugin.getParser(parsername);
        return parser.getMultiText(delem);
    }

    protected static Element replaceElement(Element delem, String name, String pref, String parser) {
        Element newelem = DomImpl_internal.createElement(delem, DataDomImpl_internal.convertLegalExpression(name), pref);
        newelem.setAttribute("parser", parser);
        delem.getParentNode().replaceChild(newelem, delem);
        return newelem;
    }

    protected static Element appendElement(Element data, String name, String pref, String parser) {
        Element newelem = DomImpl_internal.appendElement(data, DataDomImpl_internal.convertLegalExpression(name), pref);
        newelem.setAttribute("parser", parser);
        return newelem;
    }

    protected static ArrayList<Element> getElements(Element elem, String name, String pref) {
        return DomImpl_internal.getElements(elem, DataDomImpl_internal.convertLegalExpression(name), pref);
    }

    public static String getStringOfFilePathQuery(String path) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(path);
        return "/mdata[" + XPathString.getAttributeEqualsPredicate("filepath", values, false) + "]";
    }

    public static String getStringOfTypeQuery(String type) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(type);
        return "/mdata/data[" + XPathString.getAttributeEqualsPredicate("name", values, false) + "]";
    }

    public static String getStringOfIDQuery(long id) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(id));
        return "/mdata[" + XPathString.getAttributeEqualsPredicate("id", values, false) + "]";
    }

    protected static String getAllText(Document doc, String type) {
        Element data = DataDomImpl_internal.getDataOfType(doc, type);
        if (data == null) {
            return "";
        }
        return DataDomImpl_internal.getAllText(data);
    }

    protected static String getAllText(Document doc) {
        String str = "";
        ArrayList<Element> dlist = DomImpl_internal.getElements(doc, "data");
        int i = 0;
        while (i < dlist.size()) {
            str = String.valueOf(str) + DataDomImpl_internal.getAllText(dlist.get(i));
            ++i;
        }
        return str;
    }

    protected static String getAllText(Element data) {
        String str = "";
        ArrayList<Element> list = DataDomImpl_internal.getAllParsersElements(data);
        int i = 0;
        while (i < list.size()) {
            if (str.length() > 0) {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + DomImpl_internal.getAllText(list.get(i));
            ++i;
        }
        return str;
    }

    protected static String getAllTypes(Document doc) {
        ArrayList<String> types = DataDomImpl_internal.getAllTypesAsArray(doc);
        if (types.size() == 0) {
            return "Unclassified";
        }
        String tstr = types.get(0);
        int i = 1;
        while (i < types.size()) {
            tstr = String.valueOf(tstr) + "," + types.get(i);
            ++i;
        }
        return tstr;
    }

    protected static ArrayList<String> getAllTypesAsArray(Document doc) {
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<Element> delems = DomImpl_internal.getElements(doc, "data");
        int i = 0;
        while (i < delems.size()) {
            String type = DomImpl_internal.getAttribute(delems.get(i), "name");
            if (!type.equals("Unclassified")) {
                types.add(type);
            }
            ++i;
        }
        Collections.sort(types);
        return types;
    }

    protected static boolean isInstance(Document doc) {
        return doc.getDocumentElement().getNodeName().compareTo("mdata") == 0;
    }

    protected static boolean hasTypeOf(Document doc, String type) {
        if (type.equals("Unclassified")) {
            return true;
        }
        ArrayList<Element> delems = DomImpl_internal.getElements(doc, "data");
        int i = 0;
        while (i < delems.size()) {
            if (type.equals(DomImpl_internal.getAttribute(delems.get(i), "name"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static String getFileInformationText(Document doc) {
        ArrayList<Element> info = DomImpl_internal.getElements(doc, "fileinfo");
        assert (info.size() == 0);
        return DomImpl_internal.getAllText(info.get(0));
    }
}

