/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.styledtexteditor;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.utils.LineUtils;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;

public class StyleManager {
    public static final int LISTINDENTSIZE = 25;
    private static final int DEFAULTINDENTRATIO = 5;
    private FontRegistry fregistry = new FontRegistry();
    private ColorRegistry colorReg = new ColorRegistry();
    private Font defaultFont;
    private Color defaultBackground;
    private Color defaultForeground;
    private StyledText styledtext = null;

    public static boolean isDummyBullet(Bullet b) {
        if (b == null) {
            return false;
        }
        if (b.style == null) {
            return false;
        }
        if (b.style.metrics == null) {
            return false;
        }
        return b.style.metrics.ascent == 1;
    }

    public Color newColor(Device device, int red, int green, int blue) {
        Color newColor = new Color(device, red, green, blue);
        Color color = this.colorReg.get(newColor.toString());
        if (color == null) {
            this.colorReg.put(newColor.toString(), newColor.getRGB());
        } else {
            newColor.dispose();
            newColor = null;
            newColor = color;
        }
        return newColor;
    }

    public StyleManager(StyledText st) {
        this.styledtext = st;
    }

    public boolean isApplyed(Point range, StyleRange style, int update) {
        int i = range.x;
        while (i < range.y) {
            StyleRange sr = this.styledtext.getStyleRangeAtOffset(i);
            if (sr != null) {
                switch (update) {
                    case 1: 
                    case 2: 
                    case 16: {
                        return false;
                    }
                    case 8: {
                        if (sr.font != null && sr.font.equals((Object)style.font)) {
                            return true;
                        }
                    }
                    case 64: {
                        if (!sr.strikeout) break;
                        return true;
                    }
                    case 32: {
                        if (!sr.underline) break;
                        return true;
                    }
                    case 4: {
                        if (!(sr.font == null ? (sr.fontStyle & style.fontStyle) != 0 : (sr.font.getFontData()[0].getStyle() & style.fontStyle) != 0)) break;
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public void applyStyle(StyleRange newsr, StyleRange style, int update) {
        if ((update & 2) != 0) {
            newsr.background = style.background;
        }
        if ((update & 1) != 0) {
            newsr.foreground = style.foreground;
        }
        if ((update & 8) != 0) {
            newsr.font = style.font;
        }
        if ((update & 0x10) != 0) {
            newsr.rise = style.rise;
        }
        if ((update & 0x20) != 0) {
            newsr.underline = style.underline;
        }
        if ((update & 0x40) != 0) {
            newsr.strikeout = style.strikeout;
        }
        if ((update & 0x80) != 0) {
            newsr.metrics = style.metrics;
        }
        if ((update & 4) != 0) {
            if (newsr.font == null) {
                switch (style.fontStyle) {
                    case 1: 
                    case 2: {
                        if (newsr.fontStyle == 0) {
                            newsr.fontStyle = style.fontStyle;
                            break;
                        }
                        newsr.fontStyle |= style.fontStyle;
                        break;
                    }
                    case -3: 
                    case -2: {
                        newsr.fontStyle &= style.fontStyle;
                    }
                }
            } else {
                FontData fd = newsr.font.getFontData()[0];
                int fdstyle = fd.getStyle();
                switch (style.fontStyle) {
                    case 1: 
                    case 2: {
                        if (fdstyle == 0) {
                            fdstyle = style.fontStyle;
                            break;
                        }
                        fdstyle |= style.fontStyle;
                        break;
                    }
                    case -3: 
                    case -2: {
                        fdstyle &= style.fontStyle;
                    }
                }
                fd.setStyle(fdstyle);
                if (this.fregistry.hasValueFor(fd.toString())) {
                    newsr.font = this.fregistry.get(fd.toString());
                } else {
                    newsr.font = new Font((Device)this.styledtext.getDisplay(), fd);
                    this.fregistry.put(fd.toString(), newsr.font.getFontData());
                }
            }
        }
    }

    public StyleRange getStyleRangeAtOffset(StyleRange[] srs, int offset) {
        int i = 0;
        while (i < srs.length) {
            if (srs[i].start <= offset && offset < srs[i].start + srs[i].length) {
                return srs[i];
            }
            ++i;
        }
        return null;
    }

    public void setNewStyleAtRange(Point range, StyleRange style, int update) {
        int start = range.x;
        int length = 0;
        StyleRange[] srs = this.styledtext.getStyleRanges(range.x, range.y - range.x, true);
        ArrayList<StyleRange> newsrs = new ArrayList<StyleRange>();
        int i = range.x;
        while (i < range.y) {
            StyleRange sr = this.getStyleRangeAtOffset(srs, i);
            if (sr != null) {
                StyleRange nsr;
                if (length > 0) {
                    StyleRange nsr2 = new StyleRange(start, length, null, null, 0);
                    this.applyStyle(nsr2, style, update);
                    newsrs.add(nsr2);
                    start += length;
                }
                String s = this.styledtext.getText(i, i);
                length = sr.start + sr.length - start;
                if (s.compareTo("\ufffc") == 0) {
                    nsr = (StyleRange)sr.clone();
                    nsr.start = start;
                    nsr.length = length;
                    this.applyStyle(nsr, style, update);
                    nsr.foreground = nsr.background != null ? nsr.background : this.styledtext.getBackground();
                    newsrs.add(nsr);
                } else {
                    nsr = (StyleRange)sr.clone();
                    nsr.start = start;
                    nsr.length = length;
                    this.applyStyle(nsr, style, update);
                    newsrs.add(nsr);
                }
                start = i + length;
                i = start - 1;
                length = 0;
            } else {
                ++length;
            }
            ++i;
        }
        if (length > 0) {
            StyleRange nsr = new StyleRange(start, length, null, null, 0);
            this.applyStyle(nsr, style, update);
            newsrs.add(nsr);
        }
        StyleRange[] srsarr = new StyleRange[newsrs.size()];
        int i2 = 0;
        while (i2 < srsarr.length) {
            srsarr[i2] = (StyleRange)newsrs.get(i2);
            ++i2;
        }
        if (srsarr.length > 0) {
            this.styledtext.replaceStyleRanges(range.x, range.y - range.x, new StyleRange[]{new StyleRange()});
            this.styledtext.replaceStyleRanges(range.x, range.y - range.x, srsarr);
        }
    }

    public Bullet getDummyBullet() {
        StyleRange sr = new StyleRange();
        sr.metrics = new GlyphMetrics(1, 0, 0);
        Bullet blt = new Bullet(16, sr);
        blt.text = "";
        return blt;
    }

    public Bullet getIndentBullet(int indent) {
        StyleRange sr = new StyleRange();
        sr.metrics = new GlyphMetrics(0, 0, indent * 5);
        Bullet blt = new Bullet(16, sr);
        blt.text = "";
        return blt;
    }

    public void updateStyle() {
        String fontname = LabNotePlugin.getDefault().getPreferenceStore().getString("fontname");
        int fontsize = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize");
        int fontstyle = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle");
        Font font = fontname.length() == 0 ? null : new Font((Device)this.styledtext.getDisplay(), fontname, fontsize, fontstyle);
        FontData fd = font.getFontData()[0];
        if (this.fregistry.hasValueFor(fd.toString())) {
            font.dispose();
            font = this.fregistry.get(fd.toString());
        } else {
            this.fregistry.put(fd.toString(), font.getFontData());
        }
        this.styledtext.setFont(font);
        int red = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred");
        int green = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen");
        int blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue");
        Color color = this.newColor((Device)this.styledtext.getDisplay(), red, green, blue);
        this.styledtext.setForeground(color);
        this.defaultForeground = color;
        red = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred");
        green = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen");
        blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue");
        color = this.newColor((Device)this.styledtext.getDisplay(), red, green, blue);
        this.styledtext.setBackground(color);
        this.defaultBackground = color;
        int headNumber = 0;
        Color foreColor = null;
        int red2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred" + headNumber);
        int green2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen" + headNumber);
        int blue2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue" + headNumber);
        foreColor = this.newColor((Device)this.styledtext.getDisplay(), red2, green2, blue2);
        Color backColor = null;
        Color lineColor = null;
        int red3 = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred" + headNumber);
        int green3 = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen" + headNumber);
        int blue3 = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue" + headNumber);
        lineColor = backColor = this.newColor((Device)this.styledtext.getDisplay(), red3, green3, blue3);
        String fontname2 = LabNotePlugin.getDefault().getPreferenceStore().getString("fontname" + headNumber);
        int fontsize2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize" + headNumber);
        int fontstyle2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle" + headNumber);
        boolean underline = LabNotePlugin.getDefault().getPreferenceStore().getBoolean("underline" + headNumber);
        int count = this.styledtext.getLineCount();
        int i = 0;
        while (i < count) {
            Bullet blt = this.styledtext.getLineBullet(i);
            if (blt != null && blt.style.metrics.ascent == 1) {
                this.setHeadStyle(i, fontname2, fontsize2, fontstyle2, underline, foreColor, backColor);
                this.styledtext.setLineBackground(i, 1, lineColor);
            }
            ++i;
        }
        this.styledtext.redraw();
    }

    public void updateStyle(int line) {
    }

    public void LoadPrefNormalStyle() {
        String fontname = LabNotePlugin.getDefault().getPreferenceStore().getString("fontname");
        int fontsize = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize");
        int fontstyle = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle");
        Font font = fontname.length() == 0 ? null : new Font((Device)this.styledtext.getDisplay(), fontname, fontsize, fontstyle);
        FontData fd = font.getFontData()[0];
        if (this.fregistry.hasValueFor(fd.toString())) {
            font.dispose();
            font = this.fregistry.get(fd.toString());
        } else {
            this.fregistry.put(fd.toString(), font.getFontData());
        }
        this.styledtext.setFont(font);
        this.defaultFont = this.styledtext.getFont();
        int red = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred");
        int green = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen");
        int blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue");
        Color color = this.newColor((Device)this.styledtext.getDisplay(), red, green, blue);
        this.styledtext.setForeground(color);
        this.defaultForeground = this.styledtext.getForeground();
        red = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred");
        green = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen");
        blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue");
        color = this.newColor((Device)this.styledtext.getDisplay(), red, green, blue);
        this.styledtext.setBackground(color);
        this.defaultBackground = this.styledtext.getBackground();
    }

    public void setHeadStyle(int sl, String fontname, int fontsize, int style, boolean ul, Color foreColor, Color backColor) {
        StyleRange newstyle = new StyleRange();
        newstyle.font = fontname.length() == 0 ? null : new Font((Device)this.styledtext.getDisplay(), fontname, fontsize, style);
        newstyle.underline = ul;
        newstyle.foreground = foreColor;
        newstyle.background = backColor;
        if (newstyle.font != null) {
            FontData fd = newstyle.font.getFontData()[0];
            if (this.fregistry.hasValueFor(fd.toString())) {
                newstyle.font.dispose();
                newstyle.font = this.fregistry.get(fd.toString());
            } else {
                this.fregistry.put(fd.toString(), newstyle.font.getFontData());
            }
        }
        Point pt = new Point(0, 0);
        pt.x = this.styledtext.getOffsetAtLine(sl);
        pt.y = LineUtils.getLastOffsetAtLine(this.styledtext, sl) + 1;
        this.setNewStyleAtRange(pt, newstyle, 43);
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }
}

