/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.smart;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CacheDB;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.search.NoSearchResultsFoundException;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchFactory;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchMethod;
import jp.sourceforge.concierge.plugin.ipapers.search.SearchQueryMaker;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedQuery;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SearchHistory;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SearchHistoryList;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearchList;

public class SmartSearch {
    private Timestamp searchTime;
    private String type;
    private String name;
    private String period;
    private ArrayList<SmartQueryItem> queries = new ArrayList();
    private Timer timer = null;
    private SearchTask task = null;

    public SmartSearch() {
        this.queries.add(new SmartQueryItem());
        this.queries.add(new SmartQueryItem());
        this.queries.add(new SmartQueryItem());
        this.queries.add(new SmartQueryItem());
        this.queries.add(new SmartQueryItem());
        this.searchTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
    }

    public int numberOfQuery() {
        return this.queries.size();
    }

    public SmartQueryItem get(int i) {
        return this.queries.get(i);
    }

    public ArrayList<SmartQueryItem> getQuery() {
        return this.queries;
    }

    public Timestamp getSearchTime() {
        return this.searchTime;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setSearchTime(Timestamp time) {
        this.searchTime = time;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setPeriod(String p) {
        this.period = p;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(String.valueOf(this.name) + "," + this.period + "," + this.searchTime + ",");
        int i = 0;
        while (i < this.queries.size()) {
            s.append(this.queries.get((int)i).target);
            s.append(",");
            s.append(this.queries.get((int)i).keyword);
            s.append(",");
            s.append(this.queries.get((int)i).parameter);
            ++i;
        }
        return s.toString();
    }

    public void search() {
        block6: {
            PaperSearchFactory paperSearchFactory = PaperSearchFactory.getInstance();
            PubMedQuery query = new PubMedQuery();
            ((SearchQueryMaker)query).makeQuery(this);
            Date date = new Date();
            this.searchTime = new Timestamp(date.getTime());
            try {
                PaperSearchMethod search = paperSearchFactory.paperSearch(query.getType());
                ArrayList<Paper> results = search.search(query.getQuery());
                if (results.size() > 0) {
                    SearchHistory h = new SearchHistory(this.name, this.searchTime, "SmartSearch");
                    SearchHistoryList.getInstance().addHistory(h);
                    int i = 0;
                    while (i < results.size()) {
                        results.get(i).getPaperInfo();
                        CacheDB.getInstance().storeInfoToCache(results.get(i), this.searchTime);
                        ++i;
                    }
                }
                SmartSearchList.getInstance().updateSmartSearch(this);
            }
            catch (NoSearchResultsFoundException e) {
                if (IPapersPlugin.log.isInfoEnabled()) {
                    IPapersPlugin.log.error((Object)e.getMessage());
                }
            }
            catch (Exception e) {
                if (!IPapersPlugin.log.isInfoEnabled()) break block6;
                IPapersPlugin.log.error((Object)e.getMessage());
            }
        }
    }

    public long getSearchPeriod() {
        long searchPeriod = 0L;
        if (this.period.compareToIgnoreCase("ones a day") != 0 || this.period.compareToIgnoreCase("Daily") != 0) {
            searchPeriod = 5184000L;
        } else if (this.period.compareToIgnoreCase("ones a week") != 0 || this.period.compareToIgnoreCase("Weekly") != 0) {
            searchPeriod = 36288000L;
        } else if (this.period.compareToIgnoreCase("ones a month") != 0 || this.period.compareToIgnoreCase("Monthly") != 0) {
            searchPeriod = 155520000L;
        }
        return searchPeriod;
    }

    public void setTimer() {
        if (this.period.compareToIgnoreCase("manual") != 0) {
            if (this.task == null) {
                this.task = new SearchTask(this);
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
                long lastSearch = this.searchTime.getTime();
                long searchPeriod = this.getSearchPeriod();
                Date nextSearch = new Date(lastSearch + searchPeriod);
                this.timer.schedule((TimerTask)this.task, nextSearch, searchPeriod);
                if (IPapersPlugin.log.isInfoEnabled()) {
                    IPapersPlugin.log.info((Object)("start timer " + this.name + ": next search is " + nextSearch.toString()));
                }
            }
        }
    }

    private static class SearchTask
    extends TimerTask {
        private SmartSearch query;

        public SearchTask(SmartSearch q) {
            this.query = q;
        }

        @Override
        public void run() {
            this.query.search();
        }
    }

    public static class SmartQueryItem {
        public String target;
        public String keyword;
        public String parameter;

        public void setTarget(String t) {
            this.target = t;
        }

        public void setKeyword(String k) {
            this.keyword = k;
        }

        public void setParameter(String p) {
            this.parameter = p;
        }

        public String getTarget() {
            return this.target;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getParameter() {
            return this.parameter;
        }
    }
}

