/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandInterpreter;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandProvider;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class FrameworkConsole
implements Runnable {
    protected BufferedReader in;
    protected PrintWriter out;
    protected final BundleContext context;
    protected final OSGi osgi;
    protected final String[] args;
    protected final CommandProvider osgicp;
    protected final ServiceTracker cptracker;
    static final String defaultEncoding = "iso8859-1";
    static final String encoding = FrameworkProperties.getProperty("osgi.console.encoding", FrameworkProperties.getProperty("file.encoding", "iso8859-1"));
    protected final boolean useSocketStream;
    protected boolean disconnect = false;
    protected final int port;
    protected ConsoleSocketGetter scsg = null;
    protected Socket s;
    boolean blockOnready = FrameworkProperties.getProperty("osgi.dev") != null || FrameworkProperties.getProperty("osgi.console.blockOnReady") != null;
    volatile boolean shutdown = false;

    public FrameworkConsole(OSGi osgi, String[] args) {
        this(osgi, args, 0, false);
    }

    public FrameworkConsole(OSGi osgi, int port, String[] args) {
        this(osgi, args, port, true);
    }

    private FrameworkConsole(OSGi osgi, String[] args, int port, boolean useSocketStream) {
        this.args = args;
        this.osgi = osgi;
        this.useSocketStream = useSocketStream;
        this.port = port;
        this.context = osgi.getBundleContext();
        this.cptracker = new ServiceTracker(this.context, CommandProvider.class.getName(), null);
        this.cptracker.open();
        this.osgicp = new FrameworkCommandProvider(osgi).intialize();
    }

    private void getDefaultStreams() {
        FilterInputStream is = new FilterInputStream(System.in){

            @Override
            public void close() throws IOException {
            }
        };
        this.in = this.createBufferedReader(is);
        FilterOutputStream os = new FilterOutputStream(System.out){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(byte[] var0, int var1, int var2) throws IOException {
                this.out.write(var0, var1, var2);
            }
        };
        this.out = this.createPrintWriter(os);
        this.disconnect = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSocketStream() {
        Socket temp;
        block11: {
            System.out.println(NLS.bind(ConsoleMsg.CONSOLE_LISTENING_ON_PORT, String.valueOf(this.port)));
            FrameworkConsole frameworkConsole = this;
            synchronized (frameworkConsole) {
                if (this.scsg == null) {
                    this.scsg = new ConsoleSocketGetter(new ServerSocket(this.port));
                }
                this.scsg.setAcceptConnections(true);
            }
            temp = this.scsg.getSocket();
            if (temp != null) break block11;
            return false;
        }
        try {
            FrameworkConsole frameworkConsole = this;
            synchronized (frameworkConsole) {
                this.s = temp;
                this.in = this.createBufferedReader(this.s.getInputStream());
                this.out = this.createPrintWriter(this.s.getOutputStream());
                this.disconnect = false;
            }
            return true;
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private BufferedReader createBufferedReader(InputStream _in) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(_in, encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            reader = new BufferedReader(new InputStreamReader(_in));
        }
        return reader;
    }

    PrintWriter createPrintWriter(OutputStream _out) {
        PrintWriter writer;
        try {
            writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(_out, encoding)), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(_out)), true);
        }
        return writer;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public boolean getUseSocketStream() {
        return this.useSocketStream;
    }

    @Override
    public void run() {
        this.getDefaultStreams();
        try {
            this.console(this.args);
        }
        catch (IOException e) {
            e.printStackTrace(this.out);
        }
        while (!this.shutdown) {
            if (this.useSocketStream && !this.getSocketStream()) {
                return;
            }
            this.console();
        }
    }

    public void console(String[] args) throws IOException {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                this.docommand(args[i]);
                ++i;
            }
        }
    }

    protected void console() {
        BufferedReader br = this.in;
        String consolePrompt = "\r\n" + ConsoleMsg.CONSOLE_PROMPT;
        while (!this.disconnected()) {
            String cmdline;
            block9: {
                this.out.print(consolePrompt);
                this.out.flush();
                cmdline = null;
                try {
                    if (this.blockOnready && !this.useSocketStream) {
                        try {
                            while (!br.ready()) {
                                Thread.sleep(300L);
                            }
                            cmdline = br.readLine();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        cmdline = br.readLine();
                    }
                }
                catch (IOException ioe) {
                    if (this.shutdown) break block9;
                    ioe.printStackTrace(this.out);
                }
            }
            if (cmdline == null) {
                if (this.useSocketStream) break;
                this.shutdown();
                break;
            }
            if (this.shutdown) continue;
            this.docommand(cmdline);
        }
    }

    protected void docommand(String cmdline) {
        FrameworkCommandInterpreter intcp;
        String command;
        if (cmdline != null && cmdline.length() > 0 && (command = (intcp = new FrameworkCommandInterpreter(cmdline, this.getServices(), this)).nextArgument()) != null) {
            intcp.execute(command);
        }
    }

    public synchronized void disconnect() {
        if (!this.disconnect) {
            this.disconnect = true;
            if (this.useSocketStream) {
                if (this.s != null) {
                    try {
                        this.s.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.out != null) {
                    this.out.close();
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private synchronized boolean disconnected() {
        return this.disconnect;
    }

    public String getInput() {
        String input;
        try {
            input = this.in.readLine();
            System.out.println("<" + input + ">");
        }
        catch (IOException iOException) {
            input = "";
        }
        return input;
    }

    public Object[] getServices() {
        Object[] serviceRefs = this.cptracker.getServiceReferences();
        if (serviceRefs == null) {
            return new Object[0];
        }
        Util.dsort(serviceRefs, 0, serviceRefs.length);
        Object[] serviceObjects = new Object[serviceRefs.length];
        int i = 0;
        while (i < serviceRefs.length) {
            serviceObjects[i] = this.context.getService((ServiceReference)serviceRefs[i]);
            ++i;
        }
        return serviceObjects;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.cptracker.close();
        this.disconnect();
        if (this.scsg != null) {
            try {
                this.scsg.shutdown();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    class ConsoleSocketGetter
    implements Runnable {
        private final ServerSocket server;
        private Socket socket;
        private boolean acceptConnections = true;
        private final Object lock = new Object();

        ConsoleSocketGetter(ServerSocket server) {
            this.server = server;
            Thread t = new Thread((Runnable)this, "ConsoleSocketGetter");
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!FrameworkConsole.this.shutdown) {
                try {
                    Object o;
                    this.socket = this.server.accept();
                    if (!this.acceptConnections) {
                        o = FrameworkConsole.this.createPrintWriter(this.socket.getOutputStream());
                        ((PrintWriter)o).println(ConsoleMsg.CONSOLE_TELNET_CONNECTION_REFUSED);
                        ((PrintWriter)o).println(ConsoleMsg.CONSOLE_TELNET_CURRENTLY_USED);
                        ((PrintWriter)o).println(ConsoleMsg.CONSOLE_TELNET_ONE_CLIENT_ONLY);
                        ((PrintWriter)o).close();
                        this.socket.close();
                        continue;
                    }
                    o = this.lock;
                    synchronized (o) {
                        this.lock.notify();
                    }
                }
                catch (Exception e) {
                    if (FrameworkConsole.this.shutdown) continue;
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
            this.setAcceptConnections(false);
            return this.socket;
        }

        public void setAcceptConnections(boolean acceptConnections) {
            this.acceptConnections = acceptConnections;
        }

        public void shutdown() throws IOException {
            this.server.close();
        }
    }
}

