/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.imageviewer;

import jp.sourceforge.concierge.plugin.ImageUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class SelectionArea {
    private Image areaimage;
    private Rectangle curarea = null;
    private Color delcolor = null;
    private Color drawcolor = null;

    protected void finalize() throws Throwable {
        this.areaimage.dispose();
        this.delcolor.dispose();
        this.drawcolor.dispose();
        super.finalize();
    }

    public SelectionArea(Control control, int width, int height) {
        this.areaimage = new Image((Device)control.getDisplay(), ImageUtils.createImageData(width, height));
        this.delcolor = ImageUtils.getTransparentColor(control);
        this.drawcolor = ImageUtils.getSelectionColor(control);
    }

    public void selection(Point p1, Point p2) {
        int h;
        int t;
        int w;
        int l;
        GC gc = new GC((Drawable)this.areaimage);
        if (this.curarea != null) {
            gc.setForeground(this.delcolor);
            gc.setLineWidth(1);
            gc.drawRectangle(this.curarea);
        }
        if (p1.x > p2.x) {
            l = p2.x;
            w = p1.x - p2.x;
        } else {
            l = p1.x;
            w = p2.x - p1.x;
        }
        if (p1.y > p2.y) {
            t = p2.y;
            h = p1.y - p2.y;
        } else {
            t = p1.y;
            h = p2.y - p1.y;
        }
        this.curarea = new Rectangle(l, t, w, h);
        gc.setForeground(this.drawcolor);
        gc.setLineStyle(2);
        gc.drawRectangle(this.curarea);
        gc.dispose();
    }

    public void reset() {
        GC gc = new GC((Drawable)this.areaimage);
        if (this.curarea != null) {
            gc.setForeground(this.delcolor);
            gc.setLineWidth(1);
            gc.drawRectangle(this.curarea);
        }
        this.curarea = null;
        gc.dispose();
    }

    public Image getImage() {
        return this.areaimage;
    }

    public Rectangle getSelection() {
        return this.curarea;
    }

    public void drawImage(GC gc, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.curarea == null) {
            return;
        }
        ImageData id = this.areaimage.getImageData();
        if (sx + sw > id.width) {
            sw = id.width - sx;
        }
        if (sy + sh > id.height) {
            sh = id.height - sy;
        }
        gc.drawImage(this.areaimage, sx, sy, sw, sh, dx, dy, dw, dh);
    }
}

