/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.search.BaseFilter;

public class BackLevelFilter
extends BaseFilter {
    @Override
    public boolean accept(IFeature match) {
        PluginVersionIdentifier matchVid = match.getVersionedIdentifier().getVersion();
        IFeature[] installed = UpdateUtils.getInstalledFeatures(match.getVersionedIdentifier(), false);
        if (installed.length == 0) {
            return true;
        }
        int i = 0;
        while (i < installed.length) {
            PluginVersionIdentifier ivid = installed[i].getVersionedIdentifier().getVersion();
            if (!matchVid.isGreaterThan(ivid)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accept(IFeatureReference match) {
        try {
            PluginVersionIdentifier matchVid = match.getVersionedIdentifier().getVersion();
            IFeature[] installed = UpdateUtils.getInstalledFeatures(match.getVersionedIdentifier(), false);
            if (installed.length == 0) {
                return true;
            }
            int i = 0;
            while (true) {
                if (i >= installed.length) {
                    return true;
                }
                PluginVersionIdentifier ivid = installed[i].getVersionedIdentifier().getVersion();
                if (!matchVid.isGreaterThan(ivid)) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

