/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.PerspectiveMenu;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChangeToPerspectiveMenu
extends PerspectiveMenu {
    public ChangeToPerspectiveMenu(IWorkbenchWindow window, String id) {
        super(window, id);
        ((WorkbenchWindow)window).addSubmenu(2);
        this.showActive(true);
    }

    @Override
    protected void run(IPerspectiveDescriptor desc) {
        IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
        int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
        IWorkbenchPage page = this.getWindow().getActivePage();
        IPerspectiveDescriptor persp = null;
        if (page != null) {
            persp = page.getPerspective();
        }
        IHandlerService handlerService = (IHandlerService)this.getWindow().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)this.getWindow().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.perspectives.showPerspective");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.eclipse.ui.perspectives.showPerspective.perspectiveId", desc.getId());
        if (2 == mode && persp != null) {
            parameters.put("org.eclipse.ui.perspectives.showPerspective.newWindow", "true");
        }
        ParameterizedCommand pCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
        try {
            handlerService.executeCommand(pCommand, null);
        }
        catch (ExecutionException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)e));
        }
        catch (NotDefinedException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)e));
        }
        catch (NotEnabledException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)e));
        }
        catch (NotHandledException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)e));
        }
    }
}

