/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Widget;

public class CComboObservableValue
extends AbstractSWTObservableValue {
    private final CCombo ccombo;
    private final String attribute;
    private boolean updating = false;
    private String currentValue;
    private ModifyListener modifyListener;

    public CComboObservableValue(CCombo ccombo, String attribute) {
        super((Widget)ccombo);
        this.ccombo = ccombo;
        this.attribute = attribute;
        this.init();
    }

    public CComboObservableValue(Realm realm, CCombo ccombo, String attribute) {
        super(realm, (Widget)ccombo);
        this.ccombo = ccombo;
        this.attribute = attribute;
        this.init();
    }

    private void init() {
        if (!this.attribute.equals("selection") && !this.attribute.equals("text")) {
            throw new IllegalArgumentException();
        }
        this.currentValue = this.ccombo.getText();
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CComboObservableValue.this.updating) {
                    String oldValue = CComboObservableValue.this.currentValue;
                    CComboObservableValue.this.currentValue = CComboObservableValue.this.ccombo.getText();
                    CComboObservableValue.this.notifyIfChanged(oldValue, CComboObservableValue.this.currentValue);
                }
            }
        };
        this.ccombo.addModifyListener(this.modifyListener);
    }

    public void doSetValue(Object value) {
        String oldValue = this.ccombo.getText();
        try {
            this.updating = true;
            if (this.attribute.equals("text")) {
                String stringValue = value != null ? value.toString() : "";
                this.ccombo.setText(stringValue);
            } else if (this.attribute.equals("selection")) {
                String[] items = this.ccombo.getItems();
                int index = -1;
                if (value == null) {
                    this.ccombo.select(-1);
                } else if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        if (value.equals(items[i])) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        this.ccombo.setText((String)value);
                    } else {
                        this.ccombo.select(index);
                    }
                }
            }
        }
        finally {
            this.updating = false;
            this.currentValue = this.ccombo.getText();
        }
        this.notifyIfChanged(oldValue, this.currentValue);
    }

    public Object doGetValue() {
        if (this.attribute.equals("text")) {
            return this.ccombo.getText();
        }
        Assert.isTrue((boolean)this.attribute.equals("selection"), (String)("unexpected attribute: " + this.attribute));
        return this.ccombo.getText();
    }

    public Object getValueType() {
        Assert.isTrue((this.attribute.equals("text") || this.attribute.equals("selection") ? 1 : 0) != 0, (String)("unexpected attribute: " + this.attribute));
        return String.class;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.modifyListener != null && !this.ccombo.isDisposed()) {
            this.ccombo.removeModifyListener(this.modifyListener);
        }
    }

    private void notifyIfChanged(String oldValue, String newValue) {
        if (!oldValue.equals(newValue)) {
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)this.ccombo.getText()));
        }
    }
}

