/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.presentation;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.DataExtractorPlugin;
import jp.sourceforge.concierge.plugin.IFileFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PresentationDialogArea
implements IConciergeDialogArea {
    private Hashtable<String, Text> ttable = new Hashtable();
    private Document document;
    private IEditorEventListener elistener;
    private Group group1 = null;
    private Composite comp1 = null;

    public Control createDialogArea(Composite parent) {
        this.ttable.clear();
        parent.setLayout((Layout)new GridLayout(1, false));
        this.group1 = new Group(parent, 64);
        this.group1.setText("Reference Information");
        this.group1.setLayoutData((Object)new GridData(768));
        this.group1.setLayout((Layout)new GridLayout(2, false));
        GridData gd1 = new GridData(128);
        Label lb = new Label((Composite)this.group1, 64);
        lb.setText("Presentation Title");
        lb.setAlignment(131072);
        lb.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(768);
        Text tx = new Text((Composite)this.group1, 2052);
        tx.setLayoutData((Object)gd2);
        this.ttable.put("PresentationTitle", tx);
        tx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PresentationDialogArea.this.elistener != null) {
                    PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                }
            }
        });
        gd1 = new GridData(128);
        lb = new Label((Composite)this.group1, 64);
        lb.setText("Author");
        lb.setAlignment(131072);
        lb.setLayoutData((Object)gd1);
        gd2 = new GridData(768);
        tx = new Text((Composite)this.group1, 2052);
        tx.setLayoutData((Object)gd2);
        this.ttable.put("Author", tx);
        tx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PresentationDialogArea.this.elistener != null) {
                    PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                }
            }
        });
        gd1 = new GridData(128);
        lb = new Label((Composite)this.group1, 64);
        lb.setText("Abstract");
        lb.setAlignment(131072);
        lb.setLayoutData((Object)gd1);
        gd2 = new GridData(768);
        gd2.heightHint = 100;
        tx = new Text((Composite)this.group1, 2052);
        tx.setLayoutData((Object)gd2);
        this.ttable.put("Abstract", tx);
        tx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PresentationDialogArea.this.elistener != null) {
                    PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                }
            }
        });
        gd1 = new GridData(128);
        lb = new Label((Composite)this.group1, 64);
        lb.setText("Conference Name");
        lb.setAlignment(131072);
        lb.setLayoutData((Object)gd1);
        gd2 = new GridData(768);
        tx = new Text((Composite)this.group1, 2052);
        tx.setLayoutData((Object)gd2);
        this.ttable.put("ConferenceName", tx);
        tx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PresentationDialogArea.this.elistener != null) {
                    PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                }
            }
        });
        gd1 = new GridData(128);
        lb = new Label((Composite)this.group1, 64);
        lb.setText("Place");
        lb.setAlignment(131072);
        lb.setLayoutData((Object)gd1);
        gd2 = new GridData(768);
        tx = new Text((Composite)this.group1, 2052);
        tx.setLayoutData((Object)gd2);
        this.ttable.put("Place", tx);
        tx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PresentationDialogArea.this.elistener != null) {
                    PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                }
            }
        });
        gd1 = new GridData(128);
        lb = new Label((Composite)this.group1, 64);
        lb.setText("Date");
        lb.setAlignment(131072);
        lb.setLayoutData((Object)gd1);
        gd2 = new GridData(768);
        this.comp1 = new Composite((Composite)this.group1, 0);
        this.comp1.setLayoutData((Object)gd2);
        this.comp1.setLayout((Layout)new GridLayout(4, false));
        GridData gd3 = new GridData(128);
        Label lb3 = new Label(this.comp1, 64);
        lb3.setText("From");
        lb3.setAlignment(131072);
        lb3.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(768);
        Text tx2 = new Text(this.comp1, 2052);
        tx2.setLayoutData((Object)gd4);
        this.ttable.put("DateFrom", tx2);
        tx2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PresentationDialogArea.this.elistener != null) {
                    PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                }
            }
        });
        gd3 = new GridData(128);
        lb3 = new Label(this.comp1, 64);
        lb3.setText("To");
        lb3.setAlignment(131072);
        lb3.setLayoutData((Object)gd3);
        gd4 = new GridData(768);
        tx2 = new Text(this.comp1, 2052);
        tx2.setLayoutData((Object)gd4);
        this.ttable.put("DateTo", tx2);
        tx2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PresentationDialogArea.this.elistener != null) {
                    PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                }
            }
        });
        this.refresh();
        return parent;
    }

    public void fillout() {
        String filepath = DataDomImpl.getFilePath((Document)this.document);
        if (filepath != null && filepath.length() > 0) {
            try {
                String author;
                IFileFilter filter = DataExtractorPlugin.getFilter((String)filepath);
                String title = filter.getData("Title");
                if (title != null) {
                    this.ttable.get("PresentationTitle").setText(title);
                }
                if ((author = filter.getData("Author")) != null) {
                    this.ttable.get("Author").setText(author);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public String getType() {
        return "Presentation";
    }

    public boolean isEnabled() {
        return this.group1.isEnabled();
    }

    public void refresh() {
        if (this.document == null) {
            return;
        }
        Element te = DataDomImpl.getDataOfType((Document)this.document, (String)"Presentation");
        if (te == null) {
            return;
        }
        ArrayList elems = DataDomImpl.getAllParsersElements((Element)te);
        int i = 0;
        while (i < elems.size()) {
            Element e = (Element)elems.get(i);
            String en = DataDomImpl.getTagName((Element)e);
            String pn = DataDomImpl.getParserName((Element)e);
            ITypeParser parser = FrameworkPlugin.getParser((String)pn);
            Text txt = this.ttable.get(en);
            if (txt != null) {
                txt.setText(parser.getSingleText(e));
                txt.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (PresentationDialogArea.this.elistener != null) {
                            PresentationDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PresentationDialogArea.this.document));
                        }
                    }
                });
            }
            ++i;
        }
    }

    public Document saveDocument() {
        if (this.document == null) {
            return null;
        }
        Document schema = TypeManager.getTypeDocument((String)"Presentation");
        Element data = DataDomImpl.getDataOfType((Document)this.document, (String)"Presentation");
        if (data == null) {
            data = DataDomImpl.addDataOfType((Document)this.document, (Document)schema);
        }
        ArrayList metas = DataDomImpl.getAllParsersElements((Element)data);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Text text = this.ttable.get(tname);
            if (text != null) {
                Element schm = TypeDomImpl.getElement((Document)schema, (String)tname);
                String pname = TypeDomImpl.getParser((Element)schm);
                ITypeParser parser = FrameworkPlugin.getParser((String)pname);
                parser.putToElement(meta, text.getText());
            }
            ++i;
        }
        return this.document;
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public void setDocumentChangeListener(IEditorEventListener listener) {
        this.elistener = listener;
    }

    public void setEnabled(boolean enabled) {
        Color lc = null;
        lc = enabled ? this.group1.getDisplay().getSystemColor(2) : this.group1.getDisplay().getSystemColor(15);
        Control[] ctrls1 = this.group1.getChildren();
        int i = 0;
        while (i < ctrls1.length) {
            if (ctrls1[i] instanceof Label) {
                ctrls1[i].setForeground(lc);
            }
            ctrls1[i].setEnabled(enabled);
            ++i;
        }
        this.group1.setEnabled(enabled);
        Control[] ctrls2 = this.comp1.getChildren();
        int i2 = 0;
        while (i2 < ctrls2.length) {
            if (ctrls2[i2] instanceof Label) {
                ctrls2[i2].setForeground(lc);
            }
            ctrls2[i2].setEnabled(enabled);
            ++i2;
        }
        this.comp1.setEnabled(enabled);
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return this.group1.isDisposed();
    }
}

