/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.imageviewer;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextInput
extends Dialog {
    private String value = "";
    private Point location;
    private Font font = null;

    protected void finalize() throws Throwable {
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        super.finalize();
    }

    public TextInput(Shell parentShell) {
        super(new Shell(parentShell, 0));
        this.setShellStyle(0);
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Text text = new Text(parent, 0);
        if (this.font != null) {
            text.setFont(this.font);
        }
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                Shell ds = TextInput.this.getShell();
                Point p = ds.getSize();
                int ratio = TextInput.this.font != null ? TextInput.this.font.getFontData()[0].getHeight() : 10;
                int xsz = ((Text)e.widget).getCharCount() * ratio;
                if (p.x < xsz) {
                    ds.setSize(xsz + 12, p.y);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    TextInput.this.value = ((Text)e.widget).getText();
                    TextInput.this.close();
                }
            }
        });
        return parent;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.location != null) {
            return this.location;
        }
        return super.getInitialLocation(initialSize);
    }

    protected void initializeBounds() {
        super.initializeBounds();
    }

    public void setInitialLocation(Point location) {
        this.location = location;
    }

    public String getValue() {
        return this.value;
    }

    public void setFont(Font f) {
        this.font = new Font(null, f.getFontData());
    }
}

