/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.view;

import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.CacheQuery;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.QueryComposeDialog;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SearchHistory;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SearchHistoryList;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearch;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearchList;
import jp.sourceforge.concierge.plugin.ipapers.view.SearchHistoryContentProvider;
import jp.sourceforge.concierge.plugin.ipapers.view.SearchHistoryLabelProvider;
import jp.sourceforge.concierge.plugin.ipapers.view.SearchViewBase;
import jp.sourceforge.concierge.plugin.ipapers.view.SmartSearchContentProvider;
import jp.sourceforge.concierge.plugin.ipapers.view.SmartSearchLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;

public class SmartSearchView
extends SearchViewBase {
    private Table historyTable = null;
    private TableViewer historyViewer = null;
    private Table smartTable = null;
    private TableViewer smartViewer = null;
    private IWorkbenchPartSite parentViewPartSite;
    private IMemento memento;

    public SmartSearchView(IWorkbenchPartSite site, IMemento mem) {
        this.parentViewPartSite = site;
        this.memento = mem;
    }

    public void createSmartSearchTab(CTabFolder tabFolder) throws Exception {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText("Smart Search");
        Composite inputComposite = new Composite((Composite)tabFolder, 0);
        GridLayout inputLayout = new GridLayout(2, false);
        inputComposite.setLayout((Layout)inputLayout);
        tabItem.setControl((Control)inputComposite);
        SashForm sash_form = new SashForm(inputComposite, 256);
        sash_form.setLayoutData((Object)new GridData(1808));
        this.createSmartTable(sash_form);
        this.createHistoryTable(sash_form);
    }

    private ColumnPixelData[] getColumnLayouts(ColumnPixelData[] data, String name) {
        ColumnPixelData[] result = new ColumnPixelData[data.length];
        int i = 0;
        while (i < data.length) {
            Integer widthInt;
            int width = data[i].width;
            if (this.memento != null && (widthInt = this.memento.getInteger(String.valueOf(name) + i)) != null && widthInt > 0) {
                width = widthInt;
            }
            result[i] = new ColumnPixelData(width);
            ++i;
        }
        return result;
    }

    public void saveColumnWidth(IMemento memento) {
        TableColumn[] smartColumns = this.smartViewer.getTable().getColumns();
        int i = 0;
        while (i < smartColumns.length) {
            memento.putInteger("TAG_SMART_COLUMN_WIDTH" + i, smartColumns[i].getWidth());
            ++i;
        }
    }

    private void createSmartTable(SashForm sash_form) {
        this.smartTable = new Table((Composite)sash_form, 68096);
        this.smartTable.setHeaderVisible(true);
        this.smartTable.setLinesVisible(true);
        String[] smartCols = new String[]{"Name", "Latest Search Date", "Type"};
        ColumnPixelData[] SMART_DEFAULT_COLUMN_LAYOUTS = new ColumnPixelData[]{new ColumnPixelData(100), new ColumnPixelData(200), new ColumnPixelData(100)};
        ColumnPixelData[] smartColumnLayouts = this.getColumnLayouts(SMART_DEFAULT_COLUMN_LAYOUTS, "TAG_SMART_COLUMN_WIDTH");
        int i = 0;
        while (i < smartCols.length) {
            TableColumn col = new TableColumn(this.smartTable, 16384);
            col.setText(smartCols[i]);
            col.setWidth(smartColumnLayouts[i].width);
            ++i;
        }
        this.smartTable.setHeaderVisible(true);
        this.smartTable.setLinesVisible(true);
        this.smartViewer = new TableViewer(this.smartTable);
        this.smartViewer.setContentProvider((IContentProvider)new SmartSearchContentProvider());
        this.smartViewer.setLabelProvider((IBaseLabelProvider)new SmartSearchLabelProvider());
        this.smartViewer.setInput((Object)SmartSearchList.getInstance());
        this.smartViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedSmart = selection.getFirstElement();
                if (selectedSmart != null) {
                    SearchHistoryList.getInstance().setHistory(((SmartSearch)selectedSmart).getName());
                }
            }
        });
        MenuManager smartMenuMgr = new MenuManager("#PopupMenu");
        smartMenuMgr.setRemoveAllWhenShown(false);
        Menu smartMenu = smartMenuMgr.createContextMenu(this.smartViewer.getControl());
        this.smartViewer.getControl().setMenu(smartMenu);
        this.parentViewPartSite.registerContextMenu(smartMenuMgr, (ISelectionProvider)this.smartViewer);
        Action addSmartAction = new Action(){

            public void run() {
                SmartSearchView.this.addSmartItem();
            }
        };
        addSmartAction.setText("Append smart search");
        smartMenuMgr.add((IAction)addSmartAction);
        Action editSmartAction = new Action(){

            public void run() {
                SmartSearchView.this.editSmartItem();
            }
        };
        editSmartAction.setText("Edit selected smart search");
        smartMenuMgr.add((IAction)editSmartAction);
        Action removeSmartAction = new Action(){

            public void run() {
                SmartSearchView.this.removeSmartItem();
            }
        };
        removeSmartAction.setText("Remove selected smart search");
        smartMenuMgr.add((IAction)removeSmartAction);
        Action searchSmartAction = new Action(){

            public void run() {
                SmartSearchView.this.search_Smart();
            }
        };
        searchSmartAction.setText("Search now");
        smartMenuMgr.add((IAction)searchSmartAction);
        smartMenuMgr.add((IContributionItem)new Separator("additions"));
    }

    private void createHistoryTable(SashForm sash_form) {
        this.historyTable = new Table((Composite)sash_form, 68096);
        this.historyTable.setHeaderVisible(true);
        this.historyTable.setLinesVisible(true);
        String[] historyCols = new String[]{"History"};
        ColumnPixelData[] DEFAULT_COLUMN_LAYOUTS = new ColumnPixelData[]{new ColumnPixelData(200)};
        ColumnPixelData[] columnLayouts = this.getColumnLayouts(DEFAULT_COLUMN_LAYOUTS, "TAG_HOSTORY_COLUMN_WIDTH");
        int i = 0;
        while (i < historyCols.length) {
            TableColumn col = new TableColumn(this.historyTable, 16384);
            col.setText(historyCols[i]);
            col.setWidth(columnLayouts[i].width);
            ++i;
        }
        this.historyTable.setHeaderVisible(true);
        this.historyTable.setLinesVisible(true);
        this.historyViewer = new TableViewer(this.historyTable);
        this.historyViewer.setContentProvider((IContentProvider)new SearchHistoryContentProvider());
        this.historyViewer.setLabelProvider((IBaseLabelProvider)new SearchHistoryLabelProvider());
        this.historyViewer.setInput((Object)SearchHistoryList.getInstance());
        this.historyViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedSearch = selection.getFirstElement();
                if (selectedSearch != null) {
                    CacheQuery paperSearchQuery = new CacheQuery();
                    paperSearchQuery.makeQuery((SearchHistory)selectedSearch);
                    SmartSearchView.this.searchWithQuery(paperSearchQuery);
                }
            }
        });
        MenuManager historyMenuMgr = new MenuManager("#PopupMenu");
        historyMenuMgr.setRemoveAllWhenShown(false);
        Menu historyMenu = historyMenuMgr.createContextMenu(this.historyViewer.getControl());
        this.historyViewer.getControl().setMenu(historyMenu);
        this.parentViewPartSite.registerContextMenu(historyMenuMgr, (ISelectionProvider)this.historyViewer);
        Action removeHistoryAction = new Action(){

            public void run() {
                SmartSearchView.this.removeSelectedHistory();
            }
        };
        removeHistoryAction.setText("Remove selected history");
        historyMenuMgr.add((IAction)removeHistoryAction);
        historyMenuMgr.add((IContributionItem)new Separator("additions"));
    }

    private void editSmartItem() {
        TableItem[] selectedItems;
        SmartSearch smartSearchItem;
        Shell shell = IPapersPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        QueryComposeDialog cd = new QueryComposeDialog(shell, smartSearchItem = (SmartSearch)(selectedItems = this.smartViewer.getTable().getSelection())[0].getData(), 1);
        if (cd.open() == 0) {
            return;
        }
    }

    private void addSmartItem() {
        SmartSearch smartSearchItem;
        Shell shell = IPapersPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        QueryComposeDialog cd = new QueryComposeDialog(shell, smartSearchItem = new SmartSearch(), 0);
        if (cd.open() == 0) {
            return;
        }
    }

    private void removeSmartItem() {
        TableItem[] selectedItems = this.smartViewer.getTable().getSelection();
        SmartSearch smartSearchItem = (SmartSearch)selectedItems[0].getData();
        SmartSearchList.getInstance().removeSmartSearch(smartSearchItem);
    }

    private void search_Smart() {
        TableItem[] selectedItems = this.smartViewer.getTable().getSelection();
        SmartSearch smartSearchItem = (SmartSearch)selectedItems[0].getData();
        smartSearchItem.search();
    }

    private void removeSelectedHistory() {
        TableItem[] selectedItems = this.historyViewer.getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            SearchHistory anHistory = (SearchHistory)selectedItems[i].getData();
            anHistory.getQuery();
            SearchHistoryList.getInstance().removeHistory(anHistory);
            ++i;
        }
    }
}

