/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.tabulator;

import java.util.ArrayList;
import java.util.Collections;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.TabulatorPlugin;
import jp.sourceforge.concierge.plugin.tabulator.AllItemLabelProvider;
import jp.sourceforge.concierge.plugin.tabulator.ItemContentProvider;
import jp.sourceforge.concierge.plugin.tabulator.ItemLabelProvider;
import jp.sourceforge.concierge.plugin.tabulator.comparator.BaseComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.CommonAuthorComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.CommonKeywordsComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.CommonTitleComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.ContentComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.CreateComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.DefaultComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.FileComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.LastModComparator;
import jp.sourceforge.concierge.plugin.tabulator.comparator.TypeComparator;
import jp.sourceforge.concierge.plugin.tabulator.dnd.DragTableAdapter;
import jp.sourceforge.concierge.util.DataDomTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternalTabulator
extends Composite {
    private TableViewer tableview;
    private Image fileimg = TabulatorPlugin.getImageDescriptor("icons/ftitle.png").createImage();
    private SelectionAdapter tclistener;
    private ContentComparator contentComparator = new ContentComparator();
    private CreateComparator createComparator = new CreateComparator();
    private DefaultComparator defaultComparator = new DefaultComparator();
    private FileComparator fileComparator = new FileComparator();
    private LastModComparator lastModComparator = new LastModComparator();
    private TypeComparator typeComparator = new TypeComparator();
    private CommonAuthorComparator authorComparator = new CommonAuthorComparator();
    private CommonTitleComparator titleComparator = new CommonTitleComparator();
    private CommonKeywordsComparator keywordComparator = new CommonKeywordsComparator();
    private Document ctypedoc = null;
    private final String memetofullpath = "InternalTabulatorFULLPATH";

    private void addTableColumn(Table table, String title, Image img, int width, boolean rsz, boolean mv, Object parser, Object elem, ControlListener cl, BaseComparator comp) {
        TableColumn tc = new TableColumn(table, 16384);
        tc.setWidth(width);
        tc.setText(title);
        tc.setResizable(rsz);
        tc.setMoveable(mv);
        tc.setData("sortdirection", (Object)new Integer(128));
        tc.addSelectionListener((SelectionListener)this.tclistener);
        if (img != null) {
            tc.setImage(img);
        }
        if (parser != null) {
            tc.setData("parser", parser);
        }
        if (elem != null) {
            tc.setData("element", elem);
        }
        if (cl != null) {
            tc.addControlListener(cl);
        }
        if (comp != null) {
            tc.setData("comparator", (Object)comp);
        }
    }

    private int[] convertorders(int[] orders) {
        int[] neworders = new int[orders.length];
        int i = 0;
        while (i < orders.length) {
            neworders[orders[i]] = i;
            ++i;
        }
        return neworders;
    }

    private void setDirection(TableColumn tc) {
        Table tbl = this.tableview.getTable();
        int dir = (Integer)tc.getData("sortdirection");
        int newdir = dir == 128 ? 1024 : 128;
        tbl.setSortColumn(tc);
        tbl.setSortDirection(newdir);
        tc.setData("sortdirection", (Object)new Integer(newdir));
    }

    public boolean inFileColumn(int x) {
        TableColumn[] cols = this.tableview.getTable().getColumns();
        int[] order = this.tableview.getTable().getColumnOrder();
        int colwidth = 0;
        int i = 0;
        while (i < order.length) {
            if (cols[order[i]].getText().compareTo("File") == 0) {
                return colwidth <= x && x <= colwidth + cols[order[i]].getWidth();
            }
            colwidth += cols[order[i]].getWidth();
            ++i;
        }
        return false;
    }

    public void prepareTableForType(Document typedoc) {
        Table table = this.tableview.getTable();
        boolean fullpath = ((ItemLabelProvider)this.tableview.getLabelProvider()).isFullpath();
        ItemLabelProvider lp = new ItemLabelProvider(this.tableview, TypeDomImpl.getTypeName((Document)typedoc));
        lp.showFullpath(fullpath);
        TableColumn[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].dispose();
            ++i;
        }
        table.setHeaderVisible(true);
        ArrayList elements = TypeDomImpl.getAllElements((Document)typedoc);
        int[] orders = new int[elements.size() + 3];
        this.addTableColumn(table, "File", this.fileimg, 100, true, false, null, null, null, this.fileComparator);
        orders[0] = 0;
        int i2 = 1;
        while (i2 < elements.size() + 1) {
            Element elem = (Element)elements.get(i2 - 1);
            orders[i2] = TypeDomImpl.getColOrder((Element)elem);
            if (orders[i2] < 0) {
                orders[i2] = i2;
            } else {
                int n = i2;
                orders[n] = orders[n] + 1;
            }
            int width = TypeDomImpl.getColWidth((Element)elem);
            if (width < 0) {
                width = 100;
            }
            String itemname = TypeDomImpl.getElementName((Element)elem);
            String itemtype = TypeDomImpl.getParser((Element)elem);
            ITypeParser parser = FrameworkPlugin.getParser((String)itemtype);
            this.addTableColumn(table, itemname, null, width, true, true, parser, elem, null, this.defaultComparator);
            ++i2;
        }
        this.addTableColumn(table, "Item cdate", null, 100, true, true, null, null, null, this.createComparator);
        this.addTableColumn(table, "Item mdate", null, 100, true, true, null, null, null, this.lastModComparator);
        orders[elements.size() + 1] = elements.size() + 1;
        orders[elements.size() + 2] = elements.size() + 2;
        table.setColumnOrder(this.convertorders(orders));
        this.tableview.setContentProvider((IContentProvider)new ItemContentProvider());
        this.tableview.setLabelProvider((IBaseLabelProvider)lp);
    }

    private void prepareTableForAll() {
        Table table = this.tableview.getTable();
        boolean fullpath = ((ItemLabelProvider)this.tableview.getLabelProvider()).isFullpath();
        AllItemLabelProvider alp = new AllItemLabelProvider(this.tableview);
        alp.showFullpath(fullpath);
        TableColumn[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].dispose();
            ++i;
        }
        table.setHeaderVisible(true);
        String[] title = new String[]{"File", "Title", "Keyword", "Author", "Type", "Item cdate", "Item mdate", "Content"};
        Image[] imageArray = new Image[8];
        imageArray[0] = this.fileimg;
        Image[] imgs = imageArray;
        int[] width = new int[]{100, 200, 200, 100, 100, 100, 100, 100};
        boolean[] blArray = new boolean[8];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        boolean[] crmv = blArray;
        boolean[] crsz = new boolean[]{true, true, true, true, true, true, true, true};
        BaseComparator[] comp = new BaseComparator[]{this.fileComparator, this.titleComparator, this.keywordComparator, this.authorComparator, this.typeComparator, this.createComparator, this.lastModComparator, this.contentComparator};
        int i2 = 0;
        while (i2 < title.length) {
            this.addTableColumn(table, title[i2], imgs[i2], width[i2], crsz[i2], crmv[i2], null, null, null, comp[i2]);
            ++i2;
        }
        this.tableview.setContentProvider((IContentProvider)new ItemContentProvider());
        this.tableview.setLabelProvider((IBaseLabelProvider)alp);
    }

    private void saveColumnStatus() {
        Table table = this.tableview.getTable();
        int[] orders = table.getColumnOrder();
        int i = 0;
        while (i < orders.length) {
            TableColumn tc = table.getColumn(orders[i]);
            Element el = (Element)tc.getData("element");
            if (el != null) {
                TypeDomImpl.setColOrder((Element)el, (int)i);
                TypeDomImpl.setColWidth((Element)el, (int)tc.getWidth());
            }
            ++i;
        }
        TypeDomImpl.orderNormalize((Document)this.ctypedoc);
        ArrayList<Request> list = new ArrayList<Request>();
        Request req = new Request(3, (Object)this.ctypedoc, "type");
        req.options = 8;
        list.add(req);
        FrameworkPlugin.updateDocuments(list, (Object)TabulatorPlugin.getDefault().getBundle().getSymbolicName());
    }

    public InternalTabulator(Composite parent, int style, IMemento memento) {
        super(parent, style);
        boolean fullpath = false;
        try {
            Integer fp = memento.getInteger("InternalTabulatorFULLPATH");
            if (fp != null) {
                fullpath = fp == 1;
            }
        }
        catch (Exception exception) {}
        GridLayout tbgl = new GridLayout(1, true);
        tbgl.marginWidth = 0;
        tbgl.marginHeight = 0;
        tbgl.verticalSpacing = 0;
        tbgl.horizontalSpacing = 0;
        this.setLayout((Layout)tbgl);
        this.tableview = new TableViewer((Composite)this, 66306);
        this.tableview.getTable().setLayoutData((Object)new GridData(1808));
        this.tableview.getTable().setLinesVisible(true);
        AllItemLabelProvider alp = new AllItemLabelProvider(this.tableview);
        alp.showFullpath(fullpath);
        this.tableview.setContentProvider((IContentProvider)new ItemContentProvider());
        this.tableview.setLabelProvider((IBaseLabelProvider)alp);
        this.tclistener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList list = (ArrayList)InternalTabulator.this.tableview.getInput();
                if (list == null) {
                    return;
                }
                TableColumn tc = (TableColumn)e.widget;
                BaseComparator comp = (BaseComparator)tc.getData("comparator");
                if (comp == null) {
                    return;
                }
                if (comp instanceof FileComparator) {
                    ((FileComparator)comp).fullpath = ((ItemLabelProvider)InternalTabulator.this.tableview.getLabelProvider()).isFullpath();
                }
                InternalTabulator.this.tableview.setInput(null);
                comp.setColumn(tc);
                comp.changeSortOrder();
                Collections.sort(list, comp);
                InternalTabulator.this.tableview.setInput((Object)list);
                InternalTabulator.this.setDirection(tc);
                Table tbl = InternalTabulator.this.tableview.getTable();
                TableColumn[] tcs = tbl.getColumns();
                int cnt = 0;
                while (cnt < tcs.length) {
                    if (tcs[cnt].equals(tc)) break;
                    ++cnt;
                }
                int[] orders = tbl.getColumnOrder();
                int i = 0;
                while (i < orders.length) {
                    if (orders[i] == cnt) {
                        tbl.showColumn(tcs[i]);
                        break;
                    }
                    ++i;
                }
            }
        };
        Transfer[] transferTypes = null;
        DataDomTransfer dataDomTransfer = DataDomTransfer.getInstance();
        TextTransfer textTransfer = TextTransfer.getInstance();
        RTFTransfer rtfTransfer = RTFTransfer.getInstance();
        transferTypes = new Transfer[]{dataDomTransfer, rtfTransfer, textTransfer};
        this.tableview.addDragSupport(3, transferTypes, (DragSourceListener)new DragTableAdapter(this));
        this.prepareTableForAll();
    }

    public void setDocuments(ArrayList<Document> docs, Document typedoc) {
        if (this.ctypedoc != null) {
            this.saveColumnStatus();
        }
        this.ctypedoc = typedoc;
        this.tableview.setInput(null);
        if (typedoc == null || TypeDomImpl.getTypeName((Document)typedoc).compareTo("Unclassified") == 0) {
            this.prepareTableForAll();
        } else {
            this.prepareTableForType(typedoc);
        }
        this.tableview.setInput(docs);
    }

    public TableViewer getView() {
        return this.tableview;
    }

    public void saveStatus(IMemento memento) {
        if (((ItemLabelProvider)this.tableview.getLabelProvider()).isFullpath()) {
            memento.putInteger("InternalTabulatorFULLPATH", 1);
        } else {
            memento.putInteger("InternalTabulatorFULLPATH", 0);
        }
        if (this.ctypedoc != null) {
            this.saveColumnStatus();
        }
    }

    public Document getCurrentTypeDocument() {
        return this.ctypedoc;
    }
}

