/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.SafeFileTable;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class SaveContext
implements ISaveContext {
    protected Plugin plugin;
    protected int kind;
    protected boolean needDelta;
    protected boolean needSaveNumber;
    protected SafeFileTable fileTable;
    protected int previousSaveNumber;
    protected IProject project;

    protected SaveContext(Plugin plugin, int kind, IProject project) throws CoreException {
        this.plugin = plugin;
        this.kind = kind;
        this.project = project;
        this.needDelta = false;
        this.needSaveNumber = false;
        String pluginId = plugin.getBundle().getSymbolicName();
        this.fileTable = new SafeFileTable(pluginId);
        this.previousSaveNumber = this.getWorkspace().getSaveManager().getSaveNumber(pluginId);
    }

    public void commit() throws CoreException {
        if (this.needSaveNumber) {
            String pluginId = this.plugin.getBundle().getSymbolicName();
            IPath oldLocation = this.getWorkspace().getMetaArea().getSafeTableLocationFor(pluginId);
            this.getWorkspace().getSaveManager().setSaveNumber(pluginId, this.getSaveNumber());
            this.fileTable.setLocation(this.getWorkspace().getMetaArea().getSafeTableLocationFor(pluginId));
            this.fileTable.save();
            oldLocation.toFile().delete();
        }
    }

    @Override
    public IPath[] getFiles() {
        return this.getFileTable().getFiles();
    }

    protected SafeFileTable getFileTable() {
        return this.fileTable;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public int getPreviousSaveNumber() {
        return this.previousSaveNumber;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public int getSaveNumber() {
        int result = this.getPreviousSaveNumber() + 1;
        return result > 0 ? result : 1;
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public boolean isDeltaNeeded() {
        return this.needDelta;
    }

    @Override
    public IPath lookup(IPath file) {
        return this.getFileTable().lookup(file);
    }

    @Override
    public void map(IPath file, IPath location) {
        this.getFileTable().map(file, location);
    }

    @Override
    public void needDelta() {
        this.needDelta = true;
    }

    @Override
    public void needSaveNumber() {
        this.needSaveNumber = true;
    }
}

