/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class WorkspaceRoot
extends Container
implements IWorkspaceRoot {
    private final Map projectTable = Collections.synchronizedMap(new HashMap(16));
    private final IPath workspaceLocation;

    protected WorkspaceRoot(IPath path, Workspace container) {
        super(path, container);
        Assert.isTrue((boolean)path.equals((Object)Path.ROOT));
        this.workspaceLocation = FileUtil.canonicalPath(Platform.getLocation());
        Assert.isNotNull((Object)this.workspaceLocation);
    }

    @Override
    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags |= deleteContent ? 4 : 8, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags, monitor);
    }

    @Override
    public boolean exists(int flags, boolean checkType) {
        return true;
    }

    @Override
    public IContainer[] findContainersForLocation(IPath location) {
        return this.findContainersForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute()));
    }

    @Override
    public IContainer[] findContainersForLocationURI(URI location) {
        if (!location.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return (IContainer[])this.getLocalManager().allResourcesFor(location, false);
    }

    @Override
    public IFile[] findFilesForLocation(IPath location) {
        return this.findFilesForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute()));
    }

    @Override
    public IFile[] findFilesForLocationURI(URI location) {
        if (!location.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return (IFile[])this.getLocalManager().allResourcesFor(location, true);
    }

    @Override
    public IContainer getContainerForLocation(IPath location) {
        return this.getLocalManager().containerForLocation(location);
    }

    @Override
    public String getDefaultCharset(boolean checkImplicit) {
        if (checkImplicit) {
            return ResourcesPlugin.getEncoding();
        }
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        return enc == null || enc.length() == 0 ? null : enc;
    }

    @Override
    public IFile getFileForLocation(IPath location) {
        return this.getLocalManager().fileForLocation(location);
    }

    @Override
    public long getLocalTimeStamp() {
        return -1L;
    }

    @Override
    public IPath getLocation() {
        return this.workspaceLocation;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public IContainer getParent() {
        return null;
    }

    @Override
    public IProject getProject() {
        return null;
    }

    @Override
    public IProject getProject(String name) {
        Project result = (Project)this.projectTable.get(name);
        if (result == null) {
            IPath projectPath = new Path(null, name).makeAbsolute();
            String message = "Path for project must have only one segment.";
            Assert.isLegal((projectPath.segmentCount() == 1 ? 1 : 0) != 0, (String)message);
            String canonicalName = projectPath.lastSegment();
            result = (Project)this.projectTable.get(canonicalName);
            if (result != null) {
                return result;
            }
            result = new Project(projectPath, this.workspace);
            this.projectTable.put(canonicalName, result);
        }
        return result;
    }

    @Override
    public IPath getProjectRelativePath() {
        return Path.EMPTY;
    }

    @Override
    public IProject[] getProjects() {
        return this.getProjects(0);
    }

    @Override
    public IProject[] getProjects(int memberFlags) {
        IResource[] roots = this.getChildren(memberFlags);
        IProject[] result = new IProject[roots.length];
        System.arraycopy(roots, 0, result, 0, roots.length);
        return result;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public void internalSetLocal(boolean flag, int depth) throws CoreException {
        if (depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(0);
        int i = 0;
        while (i < children.length) {
            ((Resource)children[i]).internalSetLocal(flag, depth);
            ++i;
        }
    }

    @Override
    public boolean isDerived(int options) {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isLinked(int options) {
        return false;
    }

    @Override
    public boolean isLocal(int depth) {
        return this.isLocal(-1, depth);
    }

    @Override
    public boolean isLocal(int flags, int depth) {
        if (depth == 0) {
            return true;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(0);
        int i = 0;
        while (i < children.length) {
            if (!children[i].isLocal(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isPhantom() {
        return false;
    }

    @Override
    public void setDefaultCharset(String charset) {
        Preferences resourcesPreferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (charset != null) {
            resourcesPreferences.setValue("encoding", charset);
        } else {
            resourcesPreferences.setToDefault("encoding");
        }
    }

    @Override
    public void setHidden(boolean isHidden) {
    }

    @Override
    public long setLocalTimeStamp(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Illegal time stamp: " + value);
        }
        return value;
    }

    @Override
    public void setReadOnly(boolean readonly) {
    }

    @Override
    public void touch(IProgressMonitor monitor) {
    }
}

