/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableList;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableMap;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableSet;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public abstract class MultiValidator
extends ValidationStatusProvider {
    private Realm realm;
    private IObservableValue validationStatus;
    private IObservableValue unmodifiableValidationStatus;
    private WritableList targets;
    private IObservableList unmodifiableTargets;
    private IObservableList models;
    IListChangeListener targetsListener = new IListChangeListener(){

        @Override
        public void handleListChange(ListChangeEvent event) {
            event.diff.accept(new ListDiffVisitor(){

                @Override
                public void handleAdd(int index, Object element) {
                    ((IObservable)element).addChangeListener(MultiValidator.this.dependencyListener);
                }

                @Override
                public void handleRemove(int index, Object element) {
                    ((IObservable)element).removeChangeListener(MultiValidator.this.dependencyListener);
                }
            });
        }
    };
    private IChangeListener dependencyListener = new IChangeListener(){

        @Override
        public void handleChange(ChangeEvent event) {
            MultiValidator.this.revalidate();
        }
    };

    public MultiValidator() {
        this(Realm.getDefault());
    }

    public MultiValidator(Realm realm) {
        Assert.isNotNull((Object)realm, (String)"Realm cannot be null");
        this.realm = realm;
        this.validationStatus = new WritableValue(realm, ValidationStatus.ok(), IStatus.class);
        this.targets = new WritableList(realm, new ArrayList(), IObservable.class);
        this.targets.addListChangeListener(this.targetsListener);
        this.unmodifiableTargets = Observables.unmodifiableObservableList(this.targets);
        this.models = Observables.emptyObservableList(realm);
    }

    private void checkObservable(IObservable target) {
        Assert.isNotNull((Object)target, (String)"Target observable cannot be null");
        Assert.isTrue((boolean)this.realm.equals(target.getRealm()), (String)"Target observable must be in the same realm as MultiValidator");
    }

    @Override
    public IObservableValue getValidationStatus() {
        if (this.unmodifiableValidationStatus == null) {
            this.revalidate();
            this.unmodifiableValidationStatus = Observables.unmodifiableObservableValue(this.validationStatus);
        }
        return this.unmodifiableValidationStatus;
    }

    private void revalidate() {
        final IObservable[] dependencies = ObservableTracker.runAndMonitor(new Runnable(){

            @Override
            public void run() {
                try {
                    IStatus status = MultiValidator.this.validate();
                    if (status == null) {
                        status = ValidationStatus.ok();
                    }
                    MultiValidator.this.validationStatus.setValue(status);
                }
                catch (RuntimeException e) {
                    MultiValidator.this.validationStatus.setValue(ValidationStatus.error(e.getMessage(), e));
                }
            }
        }, null, null);
        ObservableTracker.runAndIgnore(new Runnable(){

            @Override
            public void run() {
                ArrayList newTargets = new ArrayList(Arrays.asList(dependencies));
                MultiValidator.this.targets.retainAll((Collection)newTargets);
                newTargets.removeAll(MultiValidator.this.targets);
                newTargets.remove(MultiValidator.this.validationStatus);
                newTargets.remove(MultiValidator.this.unmodifiableValidationStatus);
                newTargets.remove(MultiValidator.this.targets);
                newTargets.remove(MultiValidator.this.unmodifiableTargets);
                newTargets.remove(MultiValidator.this.models);
                MultiValidator.this.targets.addAll((Collection)newTargets);
            }
        });
    }

    protected abstract IStatus validate();

    public IObservableValue observeValidatedValue(IObservableValue target) {
        this.checkObservable(target);
        return new ValidatedObservableValue(target, this.getValidationStatus());
    }

    public IObservableList observeValidatedList(IObservableList target) {
        this.checkObservable(target);
        return new ValidatedObservableList(target, this.getValidationStatus());
    }

    public IObservableSet observeValidatedSet(IObservableSet target) {
        this.checkObservable(target);
        return new ValidatedObservableSet(target, this.getValidationStatus());
    }

    public IObservableMap observeValidatedMap(IObservableMap target) {
        this.checkObservable(target);
        return new ValidatedObservableMap(target, this.getValidationStatus());
    }

    @Override
    public IObservableList getTargets() {
        return this.unmodifiableTargets;
    }

    @Override
    public IObservableList getModels() {
        return this.models;
    }

    @Override
    public void dispose() {
        if (this.targets != null) {
            this.targets.clear();
        }
        if (this.unmodifiableValidationStatus != null) {
            this.unmodifiableValidationStatus.dispose();
            this.unmodifiableValidationStatus = null;
        }
        if (this.validationStatus != null) {
            this.validationStatus.dispose();
            this.validationStatus = null;
        }
        if (this.unmodifiableTargets != null) {
            this.unmodifiableTargets.dispose();
            this.unmodifiableTargets = null;
        }
        if (this.targets != null) {
            this.targets.dispose();
            this.targets = null;
        }
        if (this.models != null) {
            this.models.dispose();
            this.models = null;
        }
        this.realm = null;
        super.dispose();
    }
}

