/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import java.io.File;
import jp.sourceforge.concierge.widget.TextInputDialog;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FileNameInputDialog
extends TextInputDialog {
    private static final Character[] c = new Character[]{Character.valueOf('\u00a5'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf(':'), Character.valueOf('\"'), Character.valueOf('|')};
    private ControlDecoration decoration = null;
    private Image decimage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    private String path = null;

    private boolean isInputError() {
        String newpath;
        File f;
        String t = this.textBox.getText().trim();
        if (t.equals(this.text)) {
            return false;
        }
        if (t.length() == 0) {
            this.decoration.setDescriptionText("Filename is empty.");
            return true;
        }
        int i = 0;
        while (i < c.length) {
            if (t.contains(c[i].toString())) {
                this.decoration.setDescriptionText("Filename contains illegal characters.");
                return true;
            }
            ++i;
        }
        if (this.path != null && (f = new File(newpath = String.valueOf(this.path) + t)).exists()) {
            this.decoration.setDescriptionText("File already exists.");
            return true;
        }
        return false;
    }

    public FileNameInputDialog(Shell shell, String t, String m) {
        super(shell, t, m);
    }

    protected Control createDialogArea(Composite parent) {
        Control darea = super.createDialogArea(parent);
        this.decoration = new ControlDecoration((Control)this.textBox, 16512);
        this.decoration.setMarginWidth(1);
        this.decoration.setImage(this.decimage);
        this.decoration.setDescriptionText("Filename contains illegal characters or empty.");
        this.decoration.hide();
        this.textBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.err.println("A");
            }
        });
        this.textBox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (FileNameInputDialog.this.isInputError()) {
                    FileNameInputDialog.this.decoration.show();
                    FileNameInputDialog.this.getButton(0).setEnabled(false);
                } else {
                    FileNameInputDialog.this.decoration.hide();
                    FileNameInputDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.textBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FileNameInputDialog.this.isInputError()) {
                    FileNameInputDialog.this.decoration.show();
                    FileNameInputDialog.this.getButton(0).setEnabled(false);
                } else {
                    FileNameInputDialog.this.decoration.hide();
                    FileNameInputDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        return darea;
    }

    public String getValue() {
        return String.valueOf(this.path) + this.text;
    }

    public void setValue(String val) {
        this.path = FilenameUtils.getFullPath((String)val);
        this.text = FilenameUtils.getName((String)val);
    }
}

