/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ibooks;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.iBooksPlugin;
import jp.sourceforge.concierge.plugin.ibooks.AmazonXmlSAX;
import jp.sourceforge.concierge.plugin.ibooks.BookRegister;
import jp.sourceforge.concierge.util.FileLauncher;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConciergeDialogArea
implements IConciergeDialogArea {
    private Document schema = TypeManager.getTypeDocument((String)"Book");
    private Document datadoc = null;
    private IEditorEventListener elistener;
    private Hashtable<String, Control> texthash = new Hashtable();
    private Composite superParent = null;
    private static final int thumbnailImageSize = 120;

    public Control createDialogArea(Composite parent) {
        this.superParent = parent;
        this.superParent.setLayout((Layout)new GridLayout(1, false));
        Group referenceInfoGp = new Group(this.superParent, 0);
        referenceInfoGp.setText("Reference Info");
        referenceInfoGp.setLayoutData((Object)new GridData(1808));
        referenceInfoGp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)referenceInfoGp, 0);
        label.setText("Author");
        Text authorText = new Text((Composite)referenceInfoGp, 2048);
        authorText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Author", (Control)authorText);
        ITypeParser p = FrameworkPlugin.getParser((String)"authors");
        if (p != null) {
            authorText.setToolTipText(p.getMessage());
        }
        authorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                }
            }
        });
        label = new Label((Composite)referenceInfoGp, 0);
        label.setText("Title");
        Text titleText = new Text((Composite)referenceInfoGp, 2048);
        titleText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Title", (Control)titleText);
        p = FrameworkPlugin.getParser((String)"text");
        if (p != null) {
            titleText.setToolTipText(p.getMessage());
        }
        titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                }
            }
        });
        Composite composite0 = new Composite((Composite)referenceInfoGp, 0);
        GridData gd0 = new GridData(768);
        gd0.horizontalSpan = 2;
        composite0.setLayoutData((Object)gd0);
        GridLayout gl0 = new GridLayout(2, false);
        gl0.marginWidth = 0;
        gl0.marginHeight = 0;
        composite0.setLayout((Layout)gl0);
        Composite composite1 = new Composite(composite0, 0);
        GridData gd1 = new GridData(768);
        composite1.setLayoutData((Object)gd1);
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite1.setLayout((Layout)gl);
        Label label2 = new Label(composite1, 0);
        label2.setText("Publisher");
        Text publisherText = new Text(composite1, 2048);
        publisherText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Publisher", (Control)publisherText);
        ITypeParser p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            publisherText.setToolTipText(p2.getMessage());
        }
        publisherText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                }
            }
        });
        label2 = new Label(composite1, 0);
        label2.setText("Category");
        Text categoryText = new Text(composite1, 2048);
        categoryText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Category", (Control)categoryText);
        p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            categoryText.setToolTipText(p2.getMessage());
        }
        categoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                }
            }
        });
        label2 = new Label(composite1, 0);
        label2.setText("Year");
        Text yearText = new Text(composite1, 2048);
        yearText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Year", (Control)yearText);
        p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            yearText.setToolTipText(p2.getMessage());
        }
        yearText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                }
            }
        });
        label2 = new Label(composite1, 0);
        label2.setText("Price");
        Text priceText = new Text(composite1, 2048);
        priceText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Price", (Control)priceText);
        p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            priceText.setToolTipText(p2.getMessage());
        }
        priceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                }
            }
        });
        Label thumbnail = new Label(composite0, 0x1000000);
        GridData gd = new GridData(1808);
        gd.widthHint = 120;
        gd.heightHint = 120;
        thumbnail.setLayoutData((Object)gd);
        this.texthash.put("thumbnail", (Control)thumbnail);
        thumbnail.setToolTipText("");
        label = new Label((Composite)referenceInfoGp, 0);
        label.setText("ISBN");
        Text isbnText = new Text((Composite)referenceInfoGp, 2048);
        isbnText.setLayoutData((Object)new GridData(768));
        this.texthash.put("ISBN", (Control)isbnText);
        p = FrameworkPlugin.getParser((String)"text");
        if (p != null) {
            isbnText.setToolTipText(p.getMessage());
        }
        isbnText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                }
            }
        });
        Group linkageGp = new Group(this.superParent, 0);
        linkageGp.setText("Linkage Info");
        linkageGp.setLayoutData((Object)new GridData(768));
        linkageGp.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label((Composite)linkageGp, 0);
        label3.setText("Amazon URL");
        Link urlLink = new Link((Composite)linkageGp, 0);
        urlLink.setLayoutData((Object)new GridData(768));
        this.texthash.put("URL", (Control)urlLink);
        ITypeParser p3 = FrameworkPlugin.getParser((String)"text");
        if (p3 != null) {
            urlLink.setToolTipText(p3.getMessage());
        }
        urlLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileLauncher.LaunchBrowser((String)event.text);
            }
        });
        this.refresh();
        return parent;
    }

    public Document saveDocument() {
        Element data = DataDomImpl.getDataOfType((Document)this.datadoc, (String)"Book");
        if (data == null) {
            data = DataDomImpl.addDataOfType((Document)this.datadoc, (Document)this.schema);
        }
        ArrayList metas = DataDomImpl.getAllParsersElements((Element)data);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tagname = DataDomImpl.getTagName((Element)meta);
            Control obj = this.texthash.get(tagname);
            if (obj != null && obj instanceof Text) {
                Text txt = (Text)obj;
                Element schemaelem = TypeDomImpl.getElement((Document)this.schema, (String)tagname);
                String pluginname = TypeDomImpl.getParser((Element)schemaelem);
                try {
                    ITypeParser parser = FrameworkPlugin.getParser((String)pluginname);
                    if (parser != null) {
                        parser.putToElement(meta, txt.getText());
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        Control obj = this.texthash.get("thumbnail");
        if (obj != null && obj instanceof Label) {
            long id;
            Image curImage;
            Label label = (Label)obj;
            Image oldimage = label.getImage();
            if (oldimage != null) {
                label.setImage(null);
                oldimage.dispose();
                oldimage = null;
            }
            if ((curImage = FrameworkPlugin.getThumbnailImage((long)(id = DomImpl.getID((Document)this.datadoc)))) == null) {
                String imageURL = label.getToolTipText();
                iBooksPlugin.getDefault().saveThumbnailFile(imageURL, DomImpl.getID((Document)this.datadoc));
            }
        }
        return this.datadoc;
    }

    public void fillout() {
        AmazonXmlSAX xs = null;
        Control isbnObj = this.texthash.get("ISBN");
        if (isbnObj != null && isbnObj instanceof Text) {
            Text txt = (Text)isbnObj;
            System.out.println(txt.getText());
            xs = AmazonXmlSAX.SearchASIN(txt.getText(), "http://webservices.amazon.co.jp/", null);
            if (xs == null) {
                xs = AmazonXmlSAX.SearchASIN(txt.getText(), "http://webservices.amazon.com/", null);
            } else if (xs.getList().size() == 0) {
                xs = AmazonXmlSAX.SearchASIN(txt.getText(), "http://webservices.amazon.com/", null);
            }
        }
        if (xs != null && xs.getList().size() > 0) {
            BookRegister br = xs.getList().get(0);
            Document typedoc = TypeManager.getTypeDocument((String)"Book");
            ArrayList typeelems = TypeDomImpl.getAllElements((Document)typedoc);
            int i = 0;
            while (i < typeelems.size()) {
                Element typeelem = (Element)typeelems.get(i);
                String itemname = TypeDomImpl.getElementName((Element)typeelem);
                String value = br.get(itemname);
                if (value != null) {
                    try {
                        Control obj = this.texthash.get(itemname);
                        if (obj != null && obj instanceof Text) {
                            Text txt = (Text)obj;
                            txt.setText(value);
                        }
                    }
                    catch (Exception e) {
                        System.out.print(e.getMessage());
                    }
                }
                ++i;
            }
            Control obj = this.texthash.get("thumbnail");
            if (obj != null && obj instanceof Label) {
                long id;
                Image curImage;
                Label label = (Label)obj;
                Image oldimage = label.getImage();
                if (oldimage != null) {
                    label.setImage(null);
                    oldimage.dispose();
                    oldimage = null;
                }
                if ((curImage = FrameworkPlugin.getThumbnailImage((long)(id = DomImpl.getID((Document)this.datadoc)))) != null) {
                    curImage.dispose();
                    curImage = null;
                    Image image = iBooksPlugin.getDefault().createNoThumbnailImage();
                    label.setImage(image);
                    label.setToolTipText("");
                } else {
                    Image image = iBooksPlugin.getDefault().createCatchThumbnailImage(br.getIMAGEURL());
                    label.setImage(image);
                    label.setToolTipText(br.getIMAGEURL());
                }
            }
        }
    }

    public String getType() {
        return "Book";
    }

    public boolean isEnabled() {
        return this.superParent.isEnabled();
    }

    public void refresh() {
        ArrayList metas = DataDomImpl.getAllParsersElements((Document)this.datadoc, (String)"Book");
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tagname = DataDomImpl.getTagName((Element)meta);
            Element schemaelem = TypeDomImpl.getElement((Document)this.schema, (String)tagname);
            String pluginname = TypeDomImpl.getParser((Element)schemaelem);
            ITypeParser parser = FrameworkPlugin.getParser((String)pluginname);
            if (parser != null) {
                String cntnt = parser.getSingleText(meta);
                Control obj = this.texthash.get(tagname);
                if (obj != null) {
                    if (obj instanceof Text) {
                        Text txt = (Text)obj;
                        txt.setText(cntnt);
                        txt.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                if (ConciergeDialogArea.this.elistener != null) {
                                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.datadoc));
                                }
                            }
                        });
                    } else if (obj instanceof Link) {
                        Link link = (Link)obj;
                        if (cntnt != null && cntnt.length() > 0) {
                            link.setText("<a href=\"" + cntnt + "\">" + cntnt.substring(0, 48) + "...</a>");
                        }
                    }
                }
            }
            ++i;
        }
        Control obj = this.texthash.get("thumbnail");
        if (obj != null && obj instanceof Label) {
            Label label = (Label)obj;
            Image oldimage = label.getImage();
            if (oldimage != null) {
                label.setImage(null);
                oldimage.dispose();
                oldimage = null;
            }
            long id = DomImpl.getID((Document)this.datadoc);
            Image image = iBooksPlugin.getDefault().loadThumbnailFile(id);
            label.setImage(image);
            label.setToolTipText("");
        }
    }

    public void setDocument(Document datadoc) {
        this.datadoc = datadoc;
    }

    public void setDocumentChangeListener(IEditorEventListener listener) {
        this.elistener = listener;
    }

    public void setEnabled(boolean enabled) {
        this.superParent.setEnabled(enabled);
        Color color = null;
        color = enabled ? this.superParent.getDisplay().getSystemColor(2) : this.superParent.getDisplay().getSystemColor(15);
        this.allEnabled(this.superParent, enabled, color);
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return this.superParent.isDisposed();
    }

    private void allEnabled(Composite parent, boolean enabled, Color color) {
        Control[] controls = parent.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                this.allEnabled((Composite)controls[i], enabled, color);
            } else if (controls[i] instanceof Text) {
                Text txt;
                if (!enabled && (txt = (Text)controls[i]).getText().length() > 0) {
                    txt.setText("");
                }
            } else if (controls[i] instanceof Label) {
                controls[i].setForeground(color);
                if (!enabled) {
                    Label label = (Label)controls[i];
                    label.setToolTipText("");
                    Image img = label.getImage();
                    if (img != null) {
                        label.setImage(null);
                        img.dispose();
                        img = null;
                    }
                }
            }
            controls[i].setEnabled(enabled);
            ++i;
        }
    }
}

